/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android.camera;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Looper;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import boofcv.android.camera.CameraPreview;
import boofcv.android.camera.VideoProcessing;
import boofcv.misc.BoofMiscOps;

public abstract class VideoDisplayActivity
extends Activity
implements Camera.PreviewCallback {
    protected Camera mCamera;
    protected Camera.CameraInfo mCameraInfo = new Camera.CameraInfo();
    private Visualization mDraw;
    private CameraPreview mPreview;
    protected VideoProcessing processing;
    ProgressDialog progressDialog;
    protected final Object lockProgress = new Object();
    boolean hidePreview = true;
    boolean showFPS = false;
    LinearLayout contentView;
    FrameLayout preview;
    protected int previewRotation;

    protected VideoDisplayActivity() {
    }

    protected VideoDisplayActivity(boolean hidePreview) {
        this.hidePreview = hidePreview;
    }

    public void setProcessing(VideoProcessing processing) {
        if (this.processing != null) {
            this.processing.stopProcessing();
        }
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new RuntimeException("Not called from a GUI thread. Bad stuff could happen");
        }
        this.processing = processing;
        if (processing != null && this.mCamera != null) {
            processing.init((View)this.mDraw, this.mCamera, this.mCameraInfo, this.previewRotation);
        }
    }

    public LinearLayout getViewContent() {
        return this.contentView;
    }

    public FrameLayout getViewPreview() {
        return this.preview;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.contentView = new LinearLayout((Context)this);
        this.contentView.setOrientation(1);
        LinearLayout.LayoutParams contentParam = new LinearLayout.LayoutParams(-1, -1);
        this.preview = new FrameLayout((Context)this);
        LinearLayout.LayoutParams frameLayoutParam = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        this.contentView.addView((View)this.preview, (ViewGroup.LayoutParams)frameLayoutParam);
        this.mDraw = new Visualization(this);
        this.mPreview = new CameraPreview((Context)this, this, this.hidePreview);
        this.preview.addView((View)this.mPreview);
        this.preview.addView((View)this.mDraw);
        this.setContentView((View)this.contentView, (ViewGroup.LayoutParams)contentParam);
    }

    protected void onResume() {
        super.onResume();
        if (this.mCamera != null) {
            throw new RuntimeException("Bug, camera should not be initialized already");
        }
        this.setUpAndConfigureCamera();
    }

    protected void onPause() {
        super.onPause();
        this.hideProgressDialog();
        if (this.processing != null) {
            VideoProcessing p = this.processing;
            this.processing = null;
            p.stopProcessing();
        }
        if (this.mCamera != null) {
            this.mPreview.setCamera(null);
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    private void setUpAndConfigureCamera() {
        this.mCamera = this.openConfigureCamera(this.mCameraInfo);
        this.setCameraDisplayOrientation(this.mCameraInfo, this.mCamera);
        this.mPreview.setCamera(this.mCamera);
        if (this.processing != null) {
            this.processing.init((View)this.mDraw, this.mCamera, this.mCameraInfo, this.previewRotation);
        }
    }

    protected abstract Camera openConfigureCamera(Camera.CameraInfo var1);

    public void setCameraDisplayOrientation(Camera.CameraInfo info, Camera camera) {
        int result;
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
        this.previewRotation = result;
    }

    public void onPreviewFrame(byte[] bytes, Camera camera) {
        if (this.processing != null) {
            this.processing.convertPreview(bytes, camera);
        }
    }

    protected void setProgressMessage(String message) {
        this.runOnUiThread(() -> {
            Object object = this.lockProgress;
            synchronized (object) {
                if (this.progressDialog != null) {
                    this.progressDialog.setMessage((CharSequence)message);
                    return;
                }
                this.progressDialog = new ProgressDialog((Context)this);
                this.progressDialog.setMessage((CharSequence)message);
                this.progressDialog.setIndeterminate(true);
                this.progressDialog.setProgressStyle(0);
            }
            long showTime = System.currentTimeMillis() + 1000L;
            while (showTime > System.currentTimeMillis()) {
                BoofMiscOps.sleep((long)5L);
            }
            Object object2 = this.lockProgress;
            synchronized (object2) {
                if (this.progressDialog != null) {
                    this.progressDialog.show();
                }
            }
        });
        while (this.progressDialog == null) {
            BoofMiscOps.sleep((long)5L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideProgressDialog() {
        Object object = this.lockProgress;
        synchronized (object) {
            if (this.progressDialog == null) {
                return;
            }
        }
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            object = this.lockProgress;
            synchronized (object) {
                this.progressDialog.dismiss();
                this.progressDialog = null;
            }
        } else {
            this.runOnUiThread(() -> {
                Object object = this.lockProgress;
                synchronized (object) {
                    this.progressDialog.dismiss();
                    this.progressDialog = null;
                }
            });
            while (this.progressDialog != null) {
                BoofMiscOps.sleep((long)10L);
            }
        }
    }

    public boolean isShowFPS() {
        return this.showFPS;
    }

    public void setShowFPS(boolean showFPS) {
        this.showFPS = showFPS;
    }

    private class Visualization
    extends SurfaceView {
        private Paint textPaint;
        double[] history;
        int historyNum;
        Activity activity;
        long previous;

        public Visualization(Activity context) {
            super((Context)context);
            this.textPaint = new Paint();
            this.history = new double[10];
            this.historyNum = 0;
            this.previous = 0L;
            this.activity = context;
            this.textPaint.setARGB(255, 200, 0, 0);
            this.textPaint.setTextSize(60.0f);
            this.setWillNotDraw(false);
        }

        protected void onDraw(Canvas canvas) {
            double meanFps;
            block5: {
                canvas.save();
                if (VideoDisplayActivity.this.processing != null) {
                    VideoDisplayActivity.this.processing.onDraw(canvas);
                }
                long current = System.currentTimeMillis();
                long elapsed = current - this.previous;
                this.previous = current;
                this.history[this.historyNum++] = 1000.0 / (double)elapsed;
                this.historyNum %= this.history.length;
                meanFps = 0.0;
                for (int i = 0; i < this.history.length; ++i) {
                    meanFps += this.history[i];
                }
                meanFps /= (double)this.history.length;
                try {
                    canvas.restore();
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("Underflow in restore - more restores than saves")) break block5;
                    throw e;
                }
            }
            if (VideoDisplayActivity.this.showFPS) {
                canvas.drawText(String.format("FPS = %5.2f", meanFps), 50.0f, 50.0f, this.textPaint);
            }
        }
    }
}

