/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android.camera2;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.widget.Toast;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SimpleCamera2Activity
extends Activity {
    private static final String TAG = "SimpleCamera2";
    private CameraCaptureSession mPreviewSession;
    protected TextureView mTextureView;
    protected View mView;
    private CameraOpen open = new CameraOpen();
    protected int viewWidth;
    protected int viewHeight;
    protected float cameraToDisplayDensity;
    private volatile boolean firstFrame;
    private volatile boolean canProcessImages;
    private int failuresToDecodeImage;
    protected boolean verbose = false;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    protected DisplayMetrics displayMetrics;
    private final View.OnLayoutChangeListener mViewLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View view, int left, int top, int right, int bottom, int leftWas, int topWas, int rightWas, int bottomWas) {
            int width = right - left;
            int height = bottom - top;
            if (SimpleCamera2Activity.this.verbose) {
                Log.i((String)SimpleCamera2Activity.TAG, (String)("onLayoutChange() TL=" + top + "x" + left + " view=" + width + "x" + height + " mCameraSize=" + (((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraSize != null)));
            }
            if (((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraSize == null) {
                SimpleCamera2Activity.this.openCamera(width, height);
            }
            view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        }
    };
    private final TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            if (SimpleCamera2Activity.this.verbose) {
                Log.i((String)SimpleCamera2Activity.TAG, (String)("onSurfaceTextureAvailable() view=" + width + "x" + height + " mCameraSize=" + (((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraSize != null)));
            }
            SimpleCamera2Activity.this.openCamera(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            if (SimpleCamera2Activity.this.verbose) {
                Log.i((String)SimpleCamera2Activity.TAG, (String)("onSurfaceTextureSizeChanged() view=" + width + "x" + height));
            }
            SimpleCamera2Activity.this.configureTransform(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    };
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            boolean success;
            block10: {
                if (SimpleCamera2Activity.this.verbose) {
                    Log.i((String)SimpleCamera2Activity.TAG, (String)("CameraDevice Callback onOpened() id=" + cameraDevice.getId() + " camera=" + (Object)((Object)((SimpleCamera2Activity)SimpleCamera2Activity.this).open.state)));
                }
                if (!((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.isLocked()) {
                    throw new RuntimeException("Camera not locked!");
                }
                if (((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraDevice != null) {
                    throw new RuntimeException("onOpen() and mCameraDevice is not null");
                }
                success = false;
                try {
                    ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraDevice = cameraDevice;
                    if (((SimpleCamera2Activity)SimpleCamera2Activity.this).open.state == CameraState.OPENING) {
                        ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.state = CameraState.OPEN;
                        SimpleCamera2Activity.this.startPreview();
                        if (null != SimpleCamera2Activity.this.mTextureView) {
                            SimpleCamera2Activity.this.configureTransform(SimpleCamera2Activity.this.mTextureView.getWidth(), SimpleCamera2Activity.this.mTextureView.getHeight());
                        }
                        success = true;
                        break block10;
                    }
                    if (((SimpleCamera2Activity)SimpleCamera2Activity.this).open.state == CameraState.CLOSING) {
                        SimpleCamera2Activity.this.open.closeCamera();
                        break block10;
                    }
                    ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraDevice = null;
                    throw new RuntimeException("Unexpected camera state " + (Object)((Object)((SimpleCamera2Activity)SimpleCamera2Activity.this).open.state));
                }
                finally {
                    ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.unlock();
                }
            }
            if (success) {
                SimpleCamera2Activity.this.onCameraOpened(cameraDevice);
            }
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            boolean unexpected;
            if (SimpleCamera2Activity.this.verbose) {
                Log.i((String)SimpleCamera2Activity.TAG, (String)("CameraDevice Callback onDisconnected() id=" + cameraDevice.getId()));
            }
            boolean bl = unexpected = !((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.isLocked();
            if (unexpected) {
                ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.lock();
            }
            try {
                ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraDevice = cameraDevice;
                SimpleCamera2Activity.this.open.closeCamera();
            }
            finally {
                ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.unlock();
            }
            SimpleCamera2Activity.this.onCameraDisconnected(cameraDevice);
            if (unexpected) {
                Log.e((String)SimpleCamera2Activity.TAG, (String)"  Camera disconnection was unexpected. Restarting activity");
                SimpleCamera2Activity.this.recreate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            boolean unexpected;
            if (SimpleCamera2Activity.this.verbose) {
                Log.e((String)SimpleCamera2Activity.TAG, (String)("CameraDevice Callback onError() error=" + error));
            }
            boolean bl = unexpected = !((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.isLocked();
            if (unexpected) {
                ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.lock();
            }
            try {
                ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mCameraDevice = cameraDevice;
                SimpleCamera2Activity.this.open.closeCamera();
            }
            finally {
                ((SimpleCamera2Activity)SimpleCamera2Activity.this).open.mLock.unlock();
            }
            if (unexpected) {
                Log.e((String)SimpleCamera2Activity.TAG, (String)"   No lock applied to the camera. Unexpected problem?");
            }
            SimpleCamera2Activity.this.finish();
        }
    };
    private ImageReader.OnImageAvailableListener onAvailableListener = imageReader -> {
        if (imageReader.getMaxImages() == 0) {
            Log.e((String)TAG, (String)"No images available. Has image.close() not been called?");
            return;
        }
        Image image = imageReader.acquireLatestImage();
        if (image == null) {
            if (this.verbose) {
                Log.d((String)TAG, (String)"OnImageAvailableListener: acquireLatestImage() returned null");
            }
            return;
        }
        try {
            int cameraOrientation;
            int cameraHeight;
            int cameraWidth;
            this.open.mLock.lock();
            try {
                if (this.open.mCameraSize == null || this.open.state != CameraState.OPEN) {
                    return;
                }
                cameraWidth = this.open.mCameraSize.getWidth();
                cameraHeight = this.open.mCameraSize.getHeight();
                cameraOrientation = this.open.mSensorOrientation;
            }
            finally {
                this.open.mLock.unlock();
            }
            if (this.firstFrame) {
                if (this.verbose) {
                    Log.i((String)TAG, (String)"OnImageAvailableListener: first frame!");
                }
                this.canProcessImages = false;
                if (cameraWidth != image.getWidth() || cameraHeight != image.getHeight()) {
                    Log.e((String)TAG, (String)("Android broke resolution contract. Actual=" + image.getWidth() + "x" + image.getHeight() + "  Expected=" + cameraWidth + "x" + cameraHeight));
                    this.open.mLock.lock();
                    try {
                        if (this.open.mCameraSize == null) {
                            if (this.verbose) {
                                Log.i((String)TAG, (String)"OnImageAvailableListener: open.mCameraSize == null");
                            }
                            return;
                        }
                        this.open.mCameraSize = new Size(image.getWidth(), image.getHeight());
                    }
                    finally {
                        this.open.mLock.unlock();
                    }
                    this.firstFrame = false;
                    this.runOnUiThread(() -> {
                        this.configureTransform(this.viewWidth, this.viewHeight);
                        this.onCameraResolutionChange(cameraWidth, cameraHeight, cameraOrientation);
                        this.canProcessImages = true;
                        if (this.verbose) {
                            Log.i((String)TAG, (String)"OnImageAvailableListener: UI Called back for first frame resolution finished");
                        }
                    });
                } else {
                    this.firstFrame = false;
                    this.canProcessImages = true;
                }
            }
            if (this.canProcessImages) {
                this.processFrame(image);
                this.failuresToDecodeImage = 0;
            }
        }
        catch (IllegalStateException e) {
            if (this.verbose) {
                Log.e((String)TAG, (String)("OnImageAvailableListener exception=" + e.getMessage()));
            }
            this.handleOnImageAvailableException(e);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("OnImageAvailableListener exception=" + e.getClass().getName() + " message=" + e.getMessage()));
            ++this.failuresToDecodeImage;
            if (this.failuresToDecodeImage >= 10) {
                throw e;
            }
        }
        finally {
            image.close();
        }
    };

    protected void startCameraTexture(TextureView view) {
        if (this.verbose) {
            Log.i((String)TAG, (String)("startCamera(TextureView=" + (view != null) + ")"));
        }
        this.mTextureView = view;
        this.mView = null;
        this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
    }

    protected void startCameraView(View view) {
        if (this.verbose) {
            Log.i((String)TAG, (String)("startCamera(View=" + (view != null) + ")"));
        }
        this.mView = view;
        this.mTextureView = null;
        view.addOnLayoutChangeListener(this.mViewLayoutChangeListener);
    }

    protected void startCamera() {
        if (this.verbose) {
            Log.i((String)TAG, (String)"startCamera()");
        }
        this.mView = null;
        this.mTextureView = null;
        this.runOnUiThread(() -> this.openCamera(0, 0));
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (this.verbose) {
            Log.i((String)TAG, (String)"onCreate()");
        }
        super.onCreate(savedInstanceState);
        this.displayMetrics = Resources.getSystem().getDisplayMetrics();
    }

    protected void onResume() {
        if (this.verbose) {
            Log.i((String)TAG, (String)"onResume()");
        }
        super.onResume();
        this.startBackgroundThread();
        this.open.mLock.lock();
        try {
            switch (this.open.state) {
                case OPENING: {
                    throw new RuntimeException("Camera shouldn't be in opening state when starting onResume()");
                }
                case CLOSING: {
                    if (this.verbose) {
                        Log.i((String)TAG, (String)(" camera is closing. Going to just close it now. device=" + (this.open.mCameraDevice == null)));
                    }
                    if (this.open.mCameraDevice == null) break;
                    this.open.closeCamera();
                    break;
                }
                case OPEN: {
                    throw new RuntimeException("Camera is opened. Was not cleaned up correctly onPause()");
                }
                case CLOSED: {
                    break;
                }
                default: {
                    throw new RuntimeException("New state was added and this needs to be updated. " + (Object)((Object)this.open.state));
                }
            }
            this.open.state = CameraState.OPENING;
        }
        finally {
            this.open.mLock.unlock();
        }
        if (this.mTextureView != null) {
            if (this.mTextureView.isAvailable()) {
                this.openCamera(this.mTextureView.getWidth(), this.mTextureView.getHeight());
            } else {
                this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
            }
        } else if (this.mView != null) {
            if (this.mView.getWidth() != 0 && this.mView.getHeight() != 0) {
                this.openCamera(this.mView.getWidth(), this.mView.getHeight());
            } else {
                this.mView.addOnLayoutChangeListener(this.mViewLayoutChangeListener);
            }
        } else if (this.open.mCameraDevice == null) {
            this.startCamera();
        }
    }

    protected void onPause() {
        if (this.verbose) {
            Log.i((String)TAG, (String)"onPause()");
        }
        this.closeCamera();
        this.stopBackgroundThread();
        super.onPause();
    }

    protected int selectResolution(int widthTexture, int heightTexture, Size[] resolutions) {
        int bestIndex = -1;
        double bestAspect = Double.MAX_VALUE;
        double bestArea = 0.0;
        double textureAspect = widthTexture > 0 ? (double)widthTexture / (double)heightTexture : 0.0;
        for (int i = 0; i < resolutions.length; ++i) {
            double aspectScore;
            Size s = resolutions[i];
            int width = s.getWidth();
            int height = s.getHeight();
            double d = aspectScore = widthTexture > 0 ? Math.abs((double)width - (double)height * textureAspect) / (double)width : 1.0;
            if (aspectScore < bestAspect) {
                bestIndex = i;
                bestAspect = aspectScore;
                bestArea = width * height;
                continue;
            }
            if (!(Math.abs(aspectScore - bestArea) <= 1.0E-8)) continue;
            bestIndex = i;
            double area = width * height;
            if (!(area > bestArea)) continue;
            bestArea = area;
        }
        return bestIndex;
    }

    protected void onCameraResolutionChange(int cameraWidth, int cameraHeight, int orientation) {
        if (this.verbose) {
            Log.i((String)TAG, (String)("onCameraResolutionChange( " + cameraWidth + " , " + cameraHeight + ")"));
        }
    }

    protected void configureCamera(CameraDevice device, CameraCharacteristics characteristics, CaptureRequest.Builder captureRequestBuilder) {
        if (this.verbose) {
            Log.i((String)TAG, (String)"configureCamera() default function");
        }
        captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
    }

    protected boolean selectCamera(String id, CameraCharacteristics characteristics) {
        Integer facing;
        if (this.verbose) {
            Log.i((String)TAG, (String)"selectCamera() default function");
        }
        return (facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING)) == null || facing != 0;
    }

    protected abstract void processFrame(Image var1);

    protected void openCamera(int widthTexture, int heightTexture) {
        if (this.verbose) {
            Log.i((String)TAG, (String)("openCamera( texture: " + widthTexture + "x" + heightTexture + ") activity=" + ((Object)((Object)this)).getClass().getSimpleName()));
        }
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new RuntimeException("Attempted to openCamera() when not in the main looper thread!");
        }
        if (this.isFinishing()) {
            if (this.verbose) {
                Log.d((String)TAG, (String)"openCamera isFinishing()==true");
            }
            return;
        }
        CameraManager manager = (CameraManager)this.getSystemService("camera");
        if (manager == null) {
            throw new RuntimeException("Null camera manager");
        }
        boolean releaseLock = true;
        try {
            String[] cameras;
            if (this.verbose) {
                Log.d((String)TAG, (String)("openCamera open.state==" + (Object)((Object)this.open.state)));
            }
            if (!this.open.mLock.tryLock(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            if (this.open.state == CameraState.CLOSING) {
                if (this.verbose) {
                    Log.d((String)TAG, (String)("Close request was made after the open request. Aborting and closing. device=" + (this.open.mCameraDevice == null)));
                }
                if (this.open.mCameraDevice != null) {
                    this.open.closeCamera();
                }
                this.open.state = CameraState.CLOSED;
                this.open.clearCamera();
                return;
            }
            if (this.open.state != CameraState.CLOSED && this.open.state != CameraState.OPENING) {
                throw new RuntimeException("Unexpected state=" + (Object)((Object)this.open.state));
            }
            this.open.state = CameraState.OPENING;
            if (this.mBackgroundHandler == null) {
                if (this.verbose) {
                    Log.i((String)TAG, (String)"Background handler is null. Aborting.");
                }
                return;
            }
            if (this.open.mCameraDevice != null) {
                throw new RuntimeException("Tried to open camera with one already open");
            }
            this.viewWidth = widthTexture;
            this.viewHeight = heightTexture;
            this.cameraToDisplayDensity = 0.0f;
            this.firstFrame = true;
            this.failuresToDecodeImage = 0;
            for (String cameraId : cameras = manager.getCameraIdList()) {
                Size[] sizes;
                int which;
                StreamConfigurationMap map;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                if (!this.selectCamera(cameraId, characteristics) || (map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) == null || (which = this.selectResolution(widthTexture, heightTexture, sizes = map.getOutputSizes(35))) < 0 || which >= sizes.length) continue;
                this.open.mCameraSize = sizes[which];
                this.open.cameraId = cameraId;
                this.open.mSensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                this.cameraToDisplayDensity = this.displayDensityAdjusted();
                if (this.verbose) {
                    Log.i((String)TAG, (String)("selected cameraId=" + cameraId + " orientation=" + this.open.mSensorOrientation + " res=" + this.open.mCameraSize.getWidth() + "x" + this.open.mCameraSize.getHeight()));
                }
                this.open.mCameraCharacterstics = characteristics;
                this.onCameraResolutionChange(this.open.mCameraSize.getWidth(), this.open.mCameraSize.getHeight(), this.open.mSensorOrientation);
                this.open.mPreviewReader = ImageReader.newInstance((int)this.open.mCameraSize.getWidth(), (int)this.open.mCameraSize.getHeight(), (int)35, (int)2);
                this.open.mPreviewReader.setOnImageAvailableListener(this.onAvailableListener, this.mBackgroundHandler);
                this.configureTransform(widthTexture, heightTexture);
                manager.openCamera(cameraId, this.mStateCallback, null);
                releaseLock = false;
                return;
            }
            if (this.handleNoCameraSelected()) {
                Toast.makeText((Context)this, (CharSequence)"No camera selected!", (int)1).show();
                this.finish();
            }
        }
        catch (CameraAccessException e) {
            Toast.makeText((Context)this, (CharSequence)"Cannot access the camera.", (int)0).show();
            if (this.handleCameraOpenException((Exception)((Object)e))) {
                this.finish();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Null pointer in openCamera()");
            if (this.handleCameraOpenException(e)) {
                Toast.makeText((Context)this, (CharSequence)"Null pointer. Camera2 API not supported?", (int)1).show();
                this.finish();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.");
        }
        finally {
            if (releaseLock) {
                this.open.mLock.unlock();
            }
        }
    }

    protected boolean handleNoCameraSelected() {
        return true;
    }

    protected boolean handleCameraOpenException(Exception e) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reopenCameraAtResolution(int cameraWidth, int cameraHeight) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new RuntimeException("Attempted to reopenCameraAtResolution main looper thread!");
        }
        boolean releaseLock = true;
        this.open.mLock.lock();
        try {
            if (this.verbose) {
                Log.i((String)TAG, (String)("Reopening camera is null == " + (this.open.mCameraDevice == null) + " state=" + (Object)((Object)this.open.state) + " activity=" + ((Object)((Object)this)).getClass().getSimpleName()));
            }
            if (this.open.state != CameraState.OPEN) {
                throw new RuntimeException("BUG! Attempted to re-open camera when not open");
            }
            if (null == this.open.mCameraDevice) {
                throw new RuntimeException("Can't re-open a closed camera");
            }
            this.closePreviewSession();
            this.open.mCameraSize = null;
            this.firstFrame = true;
            CameraManager manager = (CameraManager)this.getSystemService("camera");
            if (manager == null) {
                throw new RuntimeException("Null camera manager");
            }
            try {
                this.open.mPreviewReader = ImageReader.newInstance((int)cameraWidth, (int)cameraHeight, (int)35, (int)2);
                this.open.mPreviewReader.setOnImageAvailableListener(this.onAvailableListener, this.mBackgroundHandler);
                this.configureTransform(this.viewWidth, this.viewHeight);
                manager.openCamera(this.open.cameraId, this.mStateCallback, null);
                releaseLock = false;
            }
            catch (IllegalArgumentException e) {
                Toast.makeText((Context)this, (CharSequence)e.getMessage(), (int)1).show();
                this.finish();
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (releaseLock) {
                this.open.mLock.unlock();
            }
        }
    }

    protected boolean closeCamera() {
        if (this.verbose) {
            Log.i((String)TAG, (String)("closeCamera() activity=" + ((Object)((Object)this)).getClass().getSimpleName()));
        }
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new RuntimeException("Attempted to close camera not on the main looper thread!");
        }
        boolean closed = false;
        this.open.mLock.lock();
        try {
            if (this.verbose) {
                Log.i((String)TAG, (String)("closeCamera: camera=" + (this.open.mCameraDevice == null) + " state=" + (Object)((Object)this.open.state)));
            }
            this.closePreviewSession();
            if (this.open.state == CameraState.OPENING) {
                this.open.state = CameraState.CLOSING;
                if (this.open.mCameraDevice != null) {
                    throw new RuntimeException("BUG! Camera is opening and should be null until opened");
                }
            } else {
                if (null != this.open.mCameraDevice) {
                    closed = true;
                    this.open.closeCamera();
                }
                this.open.state = CameraState.CLOSED;
                this.open.clearCamera();
            }
        }
        finally {
            this.open.mLock.unlock();
        }
        return closed;
    }

    private void startPreview() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new RuntimeException("Not on main looper! Modify code to remove assumptions");
        }
        if (this.verbose) {
            Log.i((String)TAG, (String)"startPreview()");
        }
        this.open.mLock.lock();
        try {
            if (null == this.open.mCameraDevice || null == this.open.mCameraSize) {
                Log.i((String)TAG, (String)"  aborting startPreview. Camera not open yet.");
                return;
            }
            this.closePreviewSession();
            this.open.surfaces = new ArrayList<Surface>();
            this.open.mPreviewRequestBuilder = this.open.mCameraDevice.createCaptureRequest(1);
            if (this.mTextureView != null && this.mTextureView.isAvailable()) {
                SurfaceTexture texture = this.mTextureView.getSurfaceTexture();
                assert (texture != null);
                texture.setDefaultBufferSize(this.open.mCameraSize.getWidth(), this.open.mCameraSize.getHeight());
                Surface previewSurface = new Surface(texture);
                this.open.surfaces.add(previewSurface);
                this.open.mPreviewRequestBuilder.addTarget(previewSurface);
            }
            Surface readerSurface = this.open.mPreviewReader.getSurface();
            this.open.surfaces.add(readerSurface);
            this.open.mPreviewRequestBuilder.addTarget(readerSurface);
            this.createCaptureSession();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        finally {
            this.open.mLock.unlock();
        }
    }

    private void createCaptureSession() throws CameraAccessException {
        this.configureCamera(this.open.mCameraDevice, this.open.mCameraCharacterstics, this.open.mPreviewRequestBuilder);
        this.mPreviewSession = null;
        this.open.mCameraDevice.createCaptureSession(this.open.surfaces, new CameraCaptureSession.StateCallback(){

            public void onConfigured(@NonNull CameraCaptureSession session) {
                Log.i((String)SimpleCamera2Activity.TAG, (String)"CameraCaptureSession.onConfigured()");
                SimpleCamera2Activity.this.updatePreview(session);
            }

            public void onConfigureFailed(@NonNull CameraCaptureSession session) {
                Log.i((String)SimpleCamera2Activity.TAG, (String)"CameraCaptureSession.onConfigureFailed()");
                Toast.makeText((Context)SimpleCamera2Activity.this, (CharSequence)"Failed", (int)0).show();
            }
        }, null);
    }

    protected boolean changeCameraConfiguration() {
        Log.i((String)TAG, (String)"CameraCaptureSession.changeCameraConfiguration()");
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new RuntimeException("Not on main looper! Modify code to remove assumptions");
        }
        if (null == this.open.mCameraDevice || null == this.open.mCameraSize) {
            Log.i((String)TAG, (String)"  aborting changeCameraConfiguration. Camera not open yet.");
            return false;
        }
        this.open.mLock.lock();
        try {
            if (null == this.mPreviewSession) {
                Log.i((String)TAG, (String)" Abort camera configuration change. Not ready yet");
                boolean bl = false;
                return bl;
            }
            this.createCaptureSession();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        finally {
            this.open.mLock.unlock();
        }
        return true;
    }

    protected boolean isCameraReadyReconfiguration() {
        this.open.mLock.lock();
        try {
            boolean bl = this.mPreviewSession != null;
            return bl;
        }
        finally {
            this.open.mLock.unlock();
        }
    }

    private void updatePreview(CameraCaptureSession session) {
        if (null == this.open.mCameraDevice) {
            return;
        }
        this.open.mLock.lock();
        try {
            this.mPreviewSession = session;
            this.mPreviewSession.setRepeatingRequest(this.open.mPreviewRequestBuilder.build(), null, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        finally {
            this.open.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureTransform(int viewWidth, int viewHeight) {
        int cameraHeight;
        int cameraWidth;
        this.open.mLock.lock();
        try {
            if (null == this.mTextureView || null == this.open.mCameraSize) {
                return;
            }
            cameraWidth = this.open.mCameraSize.getWidth();
            cameraHeight = this.open.mCameraSize.getHeight();
        }
        finally {
            this.open.mLock.unlock();
        }
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)cameraHeight, (float)cameraWidth);
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == rotation || 3 == rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)cameraHeight, (float)viewWidth / (float)cameraWidth);
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        }
        this.mTextureView.setTransform(matrix);
    }

    private void closePreviewSession() {
        boolean alreadyLocked;
        if (this.verbose) {
            Log.i((String)TAG, (String)"closePreviewSession");
        }
        if (!(alreadyLocked = this.open.mLock.isLocked())) {
            this.open.mLock.lock();
        }
        if (this.mPreviewSession != null) {
            this.mPreviewSession.close();
            this.mPreviewSession = null;
        }
        if (!alreadyLocked) {
            this.open.mLock.unlock();
        }
    }

    protected void onCameraOpened(@NonNull CameraDevice cameraDevice) {
    }

    protected void onCameraDisconnected(@NonNull CameraDevice cameraDevice) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cameraIntrinsicNominal(CameraPinhole intrinsic) {
        this.open.mLock.lock();
        try {
            Size cameraSize = this.open.mCameraSize;
            if (cameraSize == null) {
                boolean bl = false;
                return bl;
            }
            if (this.open.mCameraCharacterstics != null) {
                SizeF physicalSize = (SizeF)this.open.mCameraCharacterstics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
                Rect activeSize = (Rect)this.open.mCameraCharacterstics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                Size pixelSize = (Size)this.open.mCameraCharacterstics.get(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE);
                float[] focalLengths = (float[])this.open.mCameraCharacterstics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
                if (focalLengths != null && focalLengths.length > 0 && physicalSize != null && activeSize != null && pixelSize != null) {
                    float fl = focalLengths[0];
                    float widthToPixel = (float)pixelSize.getWidth() / physicalSize.getWidth();
                    float heightToPixel = (float)pixelSize.getHeight() / physicalSize.getHeight();
                    float s = (float)this.open.mCameraSize.getWidth() / (float)activeSize.width();
                    intrinsic.fx = fl * widthToPixel * s;
                    intrinsic.fy = fl * heightToPixel * s;
                    intrinsic.skew = 0.0;
                    intrinsic.cx = (float)activeSize.centerX() * s;
                    intrinsic.cy = (float)activeSize.centerY() * s;
                    intrinsic.width = this.open.mCameraSize.getWidth();
                    intrinsic.height = this.open.mCameraSize.getHeight();
                    boolean bl = true;
                    return bl;
                }
            }
            intrinsic.setTo((CameraPinhole)PerspectiveOps.createIntrinsic((int)this.open.mCameraSize.getWidth(), (int)this.open.mCameraSize.getHeight(), (double)60.0, null));
            boolean bl = true;
            return bl;
        }
        finally {
            this.open.mLock.unlock();
        }
    }

    protected void handleOnImageAvailableException(RuntimeException e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float displayDensityAdjusted() {
        this.open.mLock.lock();
        try {
            if (this.open.mCameraSize == null) {
                float f = this.displayMetrics.density;
                return f;
            }
            int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
            int screenWidth = rotation == 0 || rotation == 2 ? this.displayMetrics.widthPixels : this.displayMetrics.heightPixels;
            int cameraWidth = this.open.mSensorOrientation == 0 || this.open.mSensorOrientation == 180 ? this.open.mCameraSize.getWidth() : this.open.mCameraSize.getHeight();
            float f = this.displayMetrics.density * (float)cameraWidth / (float)screenWidth;
            return f;
        }
        finally {
            this.open.mLock.unlock();
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    static class CameraOpen {
        ReentrantLock mLock = new ReentrantLock();
        CameraState state = CameraState.CLOSED;
        CameraDevice mCameraDevice;
        List<Surface> surfaces;
        Size mCameraSize;
        String cameraId;
        int mSensorOrientation;
        CameraCharacteristics mCameraCharacterstics;
        private ImageReader mPreviewReader;
        private CaptureRequest.Builder mPreviewRequestBuilder;

        CameraOpen() {
        }

        public void closeCamera() {
            this.state = CameraState.CLOSED;
            this.mCameraDevice.close();
            this.mPreviewReader.close();
            this.clearCamera();
        }

        public void clearCamera() {
            if (!this.mLock.isLocked()) {
                throw new RuntimeException("Calling clearCamera() when not locked!");
            }
            this.mCameraCharacterstics = null;
            this.mCameraDevice = null;
            this.mCameraSize = null;
            this.cameraId = null;
            this.mSensorOrientation = 0;
            this.mPreviewReader = null;
            this.mPreviewRequestBuilder = null;
        }
    }

    protected static enum CameraState {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }
}

