/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android.camera2;

import android.app.ActionBar;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.media.Image;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Size;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import boofcv.alg.color.ColorFormat;
import boofcv.android.ConvertBitmap;
import boofcv.android.ConvertCameraImage;
import boofcv.android.camera2.SimpleCamera2Activity;
import boofcv.misc.MovingAverage;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.util.ArrayDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.ddogleg.struct.DogArray_I8;
import pabeles.concurrency.GrowArray;

public abstract class VisualizeCamera2Activity
extends SimpleCamera2Activity {
    private static final String TAG = "VisualizeCamera2";
    protected TextureView textureView;
    protected DisplayView displayView;
    private final BoofImage boofImage = new BoofImage();
    protected final ReentrantLock bitmapLock = new ReentrantLock();
    protected BitmapMode bitmapMode = BitmapMode.DOUBLE_BUFFER;
    protected Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    protected Bitmap bitmapWork = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    protected DogArray_I8 bitmapTmp = new DogArray_I8();
    protected LinkedBlockingQueue threadQueue = new LinkedBlockingQueue();
    protected ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 1, 50L, TimeUnit.MILLISECONDS, this.threadQueue);
    protected Matrix imageToView = new Matrix();
    protected Matrix viewToImage = new Matrix();
    protected int targetResolution = 307200;
    protected boolean stretchToFill = false;
    protected boolean visualizeOnlyMostRecent = true;
    protected volatile long timeOfLastUpdated;
    protected static final int TIMING_WARM_UP = 3;
    protected final Object lockTiming = new Object();
    protected int totalConverted;
    protected final MovingAverage periodConvert = new MovingAverage(0.8);

    protected VisualizeCamera2Activity() {
    }

    protected VisualizeCamera2Activity(BitmapMode bitmapMode) {
        this.bitmapMode = bitmapMode;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        ActionBar actionBar;
        super.onCreate(savedInstanceState);
        if (this.verbose) {
            Log.i((String)TAG, (String)"onCreate()");
        }
        if ((actionBar = this.getActionBar()) != null) {
            actionBar.hide();
        }
    }

    public void setThreadPoolSize(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Number of threads must be greater than 0");
        }
        if (this.verbose) {
            Log.i((String)TAG, (String)("setThreadPoolSize(" + threads + ")"));
        }
        this.threadPool.setCorePoolSize(threads);
        this.threadPool.setMaximumPoolSize(threads);
    }

    protected void startCamera(@NonNull ViewGroup layout, @Nullable TextureView view) {
        if (this.verbose) {
            Log.i((String)TAG, (String)("startCamera(layout , view=" + (view != null) + ")"));
        }
        this.displayView = new DisplayView((Context)this);
        layout.addView((View)this.displayView, layout.getChildCount(), new ViewGroup.LayoutParams(-1, -1));
        if (view == null) {
            super.startCameraView((View)this.displayView);
        } else {
            this.textureView = view;
            super.startCameraTexture(this.textureView);
        }
    }

    @Override
    protected void startCameraTexture(@Nullable TextureView view) {
        throw new RuntimeException("Call the other start camera function");
    }

    @Override
    protected void startCameraView(@Nullable View view) {
        throw new RuntimeException("Call the other start camera function");
    }

    @Override
    protected void startCamera() {
        throw new RuntimeException("Call the other start camera function");
    }

    @Override
    protected int selectResolution(int widthTexture, int heightTexture, Size[] resolutions) {
        this.timeOfLastUpdated = 0L;
        int bestIndex = -1;
        double bestAspect = Double.MAX_VALUE;
        double bestArea = 0.0;
        for (int i = 0; i < resolutions.length; ++i) {
            int height;
            Size s = resolutions[i];
            int width = s.getWidth();
            double aspectScore = Math.abs(width * (height = s.getHeight()) - this.targetResolution);
            if (aspectScore < bestAspect) {
                bestIndex = i;
                bestAspect = aspectScore;
                bestArea = width * height;
                continue;
            }
            if (!(Math.abs(aspectScore - bestArea) <= 1.0E-8)) continue;
            bestIndex = i;
            double area = width * height;
            if (!(area > bestArea)) continue;
            bestArea = area;
        }
        return bestIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCameraResolutionChange(int cameraWidth, int cameraHeight, int sensorOrientation) {
        if (this.bitmapMode != BitmapMode.NONE) {
            this.bitmapLock.lock();
            try {
                if (this.bitmap.getWidth() != cameraWidth || this.bitmap.getHeight() != cameraHeight) {
                    this.bitmap = Bitmap.createBitmap((int)cameraWidth, (int)cameraHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    if (this.bitmapMode == BitmapMode.DOUBLE_BUFFER) {
                        this.bitmapWork = Bitmap.createBitmap((int)cameraWidth, (int)cameraHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    }
                }
            }
            finally {
                this.bitmapLock.unlock();
            }
        }
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        if (this.verbose) {
            Log.i((String)TAG, (String)("camera rotation = " + sensorOrientation + " display rotation = " + rotation));
        }
        VisualizeCamera2Activity.videoToDisplayMatrix(cameraWidth, cameraHeight, sensorOrientation, this.viewWidth, this.viewHeight, rotation * 90, this.stretchToFill, this.imageToView);
        if (!this.imageToView.invert(this.viewToImage)) {
            throw new RuntimeException("WTF can't invert the matrix?");
        }
    }

    protected static void videoToDisplayMatrix(int cameraWidth, int cameraHeight, int cameraRotation, int displayWidth, int displayHeight, int displayRotation, boolean stretchToFill, Matrix imageToView) {
        boolean needToRotateView;
        int rotatedWidth = cameraWidth;
        int rotatedHeight = cameraHeight;
        int offsetX = 0;
        int offsetY = 0;
        boolean bl = needToRotateView = (0 == displayRotation || 180 == displayRotation) != (cameraRotation == 0 || cameraRotation == 180);
        if (needToRotateView) {
            rotatedWidth = cameraHeight;
            rotatedHeight = cameraWidth;
            offsetX = (rotatedWidth - rotatedHeight) / 2;
            offsetY = (rotatedHeight - rotatedWidth) / 2;
        }
        imageToView.reset();
        float scale = Math.min((float)displayWidth / (float)rotatedWidth, (float)displayHeight / (float)rotatedHeight);
        if (scale == 0.0f) {
            Log.e((String)TAG, (String)"displayView has zero width and height");
            return;
        }
        imageToView.postRotate((float)(-displayRotation + cameraRotation), (float)(cameraWidth / 2), (float)(cameraHeight / 2));
        imageToView.postTranslate((float)offsetX, (float)offsetY);
        imageToView.postScale(scale, scale);
        if (stretchToFill) {
            imageToView.postScale((float)displayWidth / ((float)rotatedWidth * scale), (float)displayHeight / ((float)rotatedHeight * scale));
        } else {
            imageToView.postTranslate(((float)displayWidth - (float)rotatedWidth * scale) / 2.0f, ((float)displayHeight - (float)rotatedHeight * scale) / 2.0f);
        }
    }

    protected void setImageType(ImageType type) {
        this.setImageType(type, ColorFormat.RGB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImageType(ImageType type, ColorFormat colorFormat) {
        Object object = this.boofImage.imageLock;
        synchronized (object) {
            this.boofImage.colorFormat = colorFormat;
            if (!this.boofImage.imageType.isSameType(type)) {
                this.boofImage.imageType = type;
                this.boofImage.stackImages.clear();
            }
            Object object2 = this.lockTiming;
            synchronized (object2) {
                this.totalConverted = 0;
                this.periodConvert.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFrame(Image image) {
        ImageBase converted;
        if (this.threadQueue.size() > 0) {
            return;
        }
        Object object = this.boofImage.imageLock;
        synchronized (object) {
            converted = this.boofImage.stackImages.isEmpty() ? this.boofImage.imageType.createImage(1, 1) : this.boofImage.stackImages.pop();
        }
        long before = System.nanoTime();
        ConvertCameraImage.imageToBoof(image, this.boofImage.colorFormat, converted, this.boofImage.convertWork);
        long after = System.nanoTime();
        Object object2 = this.lockTiming;
        synchronized (object2) {
            ++this.totalConverted;
            if (this.totalConverted >= 3) {
                this.periodConvert.update((double)(after - before) * 1.0E-6);
            }
        }
        this.threadPool.execute(() -> this.processImageOuter(converted));
    }

    protected abstract void processImage(ImageBase var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImageOuter(ImageBase image) {
        long startTime = System.currentTimeMillis();
        this.processImage(image);
        if (!this.visualizeOnlyMostRecent || startTime > this.timeOfLastUpdated) {
            this.timeOfLastUpdated = startTime;
            this.renderBitmapImage(this.bitmapMode, image);
            this.runOnUiThread(() -> this.displayView.invalidate());
        }
        Object object = this.boofImage.imageLock;
        synchronized (object) {
            if (this.boofImage.imageType.isSameType(image.getImageType())) {
                this.boofImage.stackImages.add(image);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderBitmapImage(BitmapMode mode, ImageBase image) {
        switch (mode) {
            case UNSAFE: {
                if (image.getWidth() != this.bitmap.getWidth() || image.getHeight() != this.bitmap.getHeight()) break;
                ConvertBitmap.boofToBitmap(image, this.bitmap, this.bitmapTmp);
                break;
            }
            case DOUBLE_BUFFER: {
                if (image.getWidth() == this.bitmapWork.getWidth() && image.getHeight() == this.bitmapWork.getHeight()) {
                    ConvertBitmap.boofToBitmap(image, this.bitmapWork, this.bitmapTmp);
                }
                if (!this.bitmapLock.tryLock()) break;
                try {
                    Bitmap tmp = this.bitmapWork;
                    this.bitmapWork = this.bitmap;
                    this.bitmap = tmp;
                    break;
                }
                finally {
                    this.bitmapLock.unlock();
                }
            }
        }
    }

    protected void onDrawFrame(SurfaceView view, Canvas canvas) {
        switch (this.bitmapMode) {
            case UNSAFE: {
                canvas.drawBitmap(this.bitmap, this.imageToView, null);
                break;
            }
            case DOUBLE_BUFFER: {
                this.bitmapLock.lock();
                try {
                    canvas.drawBitmap(this.bitmap, this.imageToView, null);
                    break;
                }
                finally {
                    this.bitmapLock.unlock();
                }
            }
        }
    }

    protected static class BoofImage {
        protected final Object imageLock = new Object();
        protected ImageType imageType = ImageType.SB_U8;
        protected ColorFormat colorFormat = ColorFormat.RGB;
        protected ArrayDeque<ImageBase> stackImages = new ArrayDeque();
        protected GrowArray<DogArray_I8> convertWork = new GrowArray(DogArray_I8::new);

        protected BoofImage() {
        }
    }

    public static enum BitmapMode {
        NONE,
        UNSAFE,
        DOUBLE_BUFFER;

    }

    public class DisplayView
    extends SurfaceView
    implements SurfaceHolder.Callback {
        SurfaceHolder mHolder;

        public DisplayView(Context context) {
            super(context);
            this.mHolder = this.getHolder();
            this.setZOrderOnTop(true);
            this.mHolder.setFormat(-2);
            this.setWillNotDraw(false);
        }

        public void onDraw(Canvas canvas) {
            VisualizeCamera2Activity.this.onDrawFrame(this, canvas);
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        }
    }
}

