/*
 * Decompiled with CFR 0.152.
 */
package boofcv.pdf;

import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PdfFiducialEngine
extends FiducialRenderEngine {
    public PDDocument document;
    public PDPageContentStream pcs;
    public double offsetX;
    public double offsetY;
    public double markerWidth;

    public PdfFiducialEngine(PDDocument document, PDPageContentStream pcs, double markerWidth) {
        this.document = document;
        this.pcs = pcs;
        this.markerWidth = markerWidth;
    }

    public void init() {
    }

    public void circle(double cx, double cy, double r) {
        try {
            this.pcs.setNonStrokingColor(Color.BLACK);
            float k = 0.5522848f;
            this.pcs.moveTo(this.adjustX(cx - r), this.adjustY(cy));
            this.pcs.curveTo(this.adjustX(cx - r), this.adjustY(cy + 0.5522847771644592 * r), this.adjustX(cx - 0.5522847771644592 * r), this.adjustY(cy + r), this.adjustX(cx), this.adjustY(cy + r));
            this.pcs.curveTo(this.adjustX(cx + 0.5522847771644592 * r), this.adjustY(cy + r), this.adjustX(cx + r), this.adjustY(cy + 0.5522847771644592 * r), this.adjustX(cx + r), this.adjustY(cy));
            this.pcs.curveTo(this.adjustX(cx + r), this.adjustY(cy - 0.5522847771644592 * r), this.adjustX(cx + 0.5522847771644592 * r), this.adjustY(cy - r), this.adjustX(cx), this.adjustY(cy - r));
            this.pcs.curveTo(this.adjustX(cx - 0.5522847771644592 * r), this.adjustY(cy - r), this.adjustX(cx - r), this.adjustY(cy - 0.5522847771644592 * r), this.adjustX(cx - r), this.adjustY(cy));
            this.pcs.fill();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void square(double x0, double y0, double width0, double thickness) {
        try {
            this.pcs.setNonStrokingColor(Color.BLACK);
            this.pcs.moveTo(this.adjustX(x0), this.adjustY(y0));
            this.pcs.lineTo(this.adjustX(x0), this.adjustY(y0 + width0));
            this.pcs.lineTo(this.adjustX(x0 + width0), this.adjustY(y0 + width0));
            this.pcs.lineTo(this.adjustX(x0 + width0), this.adjustY(y0));
            this.pcs.lineTo(this.adjustX(x0), this.adjustY(y0));
            float x = (float)(x0 + thickness);
            float y = (float)(y0 + thickness);
            float w = (float)(width0 - thickness * 2.0);
            this.pcs.moveTo(this.adjustX(x), this.adjustY(y));
            this.pcs.lineTo(this.adjustX(x), this.adjustY(y + w));
            this.pcs.lineTo(this.adjustX(x + w), this.adjustY(y + w));
            this.pcs.lineTo(this.adjustX(x + w), this.adjustY(y));
            this.pcs.lineTo(this.adjustX(x), this.adjustY(y));
            this.pcs.fillEvenOdd();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void rectangle(double x0, double y0, double x1, double y1) {
        try {
            double width = x1 - x0;
            double height = y1 - y0;
            this.pcs.setNonStrokingColor(Color.BLACK);
            this.pcs.addRect(this.adjustX(x0), this.adjustY(y0) - (float)height, (float)width, (float)height);
            this.pcs.fill();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void draw(GrayU8 image, double x0, double y0, double x1, double y1) {
        BufferedImage buffered = new BufferedImage(image.width, image.height, 10);
        ConvertBufferedImage.convertTo((ImageBase)image, (BufferedImage)buffered, (boolean)true);
        try {
            PDImageXObject pdImage = JPEGFactory.createFromImage((PDDocument)this.document, (BufferedImage)buffered);
            this.pcs.drawImage(pdImage, this.adjustX(x0), (float)(this.offsetY + y0), (float)(x1 - x0), (float)(y1 - y0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void inputToDocument(double x, double y, Point2D_F64 document) {
        document.x = this.adjustX(x);
        document.y = this.adjustY(y);
    }

    public float adjustX(double x) {
        return (float)(this.offsetX + x);
    }

    public float adjustY(double y) {
        return (float)(this.offsetY + this.markerWidth - y);
    }
}

