/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.similar;

import boofcv.abst.feature.associate.AssociateDescriptionHashSets;
import boofcv.abst.feature.describe.DescribePoint;
import boofcv.abst.scene.FeatureSceneRecognition;
import boofcv.abst.scene.SceneRecognition;
import boofcv.abst.tracker.PointTrack;
import boofcv.alg.similar.ImageSimilarityAssociatedRatio;
import boofcv.alg.similar.SimilarImagesFromTracks;
import boofcv.alg.similar.SimilarImagesSceneRecognition;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class SimilarImagesTrackThenMatch<Image extends ImageBase<Image>, TD extends TupleDesc<TD>>
extends SimilarImagesFromTracks<PointTrack>
implements VerbosePrint {
    public int minimumRecognizeDistance = 30;
    public int limitQuery = 5;
    DescribePoint<Image, TD> describer;
    AssociateDescriptionHashSets<TD> associator;
    FeatureSceneRecognition<TD> recognizer;
    boolean learnModel = true;
    SimilarImagesSceneRecognition.SimilarityTest similarityTest = new ImageSimilarityAssociatedRatio();
    PackedArray<TD> descriptions;
    DogArray_I32 frameStartIndexes = new DogArray_I32();
    final DogArray<SceneRecognition.Match> queryMatches = new DogArray(SceneRecognition.Match::new);
    final TD tempDescription;
    final TD nullDescription;
    final DogArray<TD> sourceDescriptions;
    final DogArray<Point2D_F64> sourcePixels;
    final DogArray<TD> destinationDescriptions;
    final DogArray<Point2D_F64> destinationPixels;
    final DogArray<PairInfo> pairInfo = new DogArray(PairInfo::new, PairInfo::reset);
    final Map<String, PairInfo> viewId_to_pairs = new HashMap<String, PairInfo>();
    PrintStream verbose;

    public SimilarImagesTrackThenMatch(DescribePoint<Image, TD> describer, AssociateDescriptionHashSets<TD> featureAssociator, FeatureSceneRecognition<TD> recognizer, BoofLambdas.Factory<PackedArray<TD>> factoryPackedDesc) {
        super(t -> t.featureId, (t, pixel) -> pixel.setTo(t.pixel));
        this.describer = describer;
        this.associator = featureAssociator;
        this.recognizer = recognizer;
        this.descriptions = (PackedArray)factoryPackedDesc.newInstance();
        this.tempDescription = describer.createDescription();
        this.nullDescription = describer.createDescription();
        this.sourceDescriptions = new DogArray(() -> describer.createDescription());
        this.destinationDescriptions = new DogArray(() -> describer.createDescription());
        this.sourcePixels = new DogArray(Point2D_F64::new);
        this.destinationPixels = new DogArray(Point2D_F64::new);
        featureAssociator.createNewSetsFromSource = true;
        featureAssociator.createNewSetsFromDestination = false;
    }

    public void processFrame(Image image, List<PointTrack> tracks, long frameID) {
        super.processFrame(tracks, frameID);
        SimilarImagesFromTracks.Frame frame = (SimilarImagesFromTracks.Frame)this.frames.getTail();
        this.describer.setImage(image);
        this.frameStartIndexes.add(this.descriptions.size());
        Point2D_F64 pixel = new Point2D_F64();
        int numFeatures = frame.featureCount();
        for (int featIdx = 0; featIdx < numFeatures; ++featIdx) {
            frame.getPixel(featIdx, pixel);
            if (!this.describer.process(pixel.x, pixel.y, this.tempDescription)) {
                this.descriptions.append(this.nullDescription);
                continue;
            }
            this.descriptions.append(this.tempDescription);
        }
    }

    public void finishedTracking() {
        if (this.learnModel) {
            this.recognizer.learnModel(new Iterator<FeatureSceneRecognition.Features<TD>>(){
                int frameIdx = 0;

                @Override
                public boolean hasNext() {
                    return this.frameIdx < SimilarImagesTrackThenMatch.this.frameStartIndexes.size();
                }

                @Override
                public FeatureSceneRecognition.Features<TD> next() {
                    return SimilarImagesTrackThenMatch.this.wrapFeatures(this.frameIdx++);
                }
            });
        }
        this.recognizer.clearDatabase();
        for (int frameIdx = 0; frameIdx < this.frameStartIndexes.size; ++frameIdx) {
            this.recognizer.addImage(frameIdx + "", this.wrapFeatures(frameIdx));
        }
    }

    @Override
    public void findSimilar(String target, @Nullable BoofLambdas.Filter<String> filter, List<String> similarImages) {
        this.viewId_to_pairs.clear();
        this.pairInfo.reset();
        int frameIdx = this.frameToIndex(target);
        if (frameIdx < 0 || frameIdx >= this.frames.size) {
            throw new IllegalArgumentException("Unknown target=" + target);
        }
        super.findSimilar(target, filter, similarImages);
        SimilarImagesFromTracks.Frame frameTarget = (SimilarImagesFromTracks.Frame)this.frames.get(frameIdx);
        BoofLambdas.Filter<String> queryFilter = this.filterQuery(filter, frameIdx, frameTarget);
        this.recognizer.query(this.wrapFeatures(frameIdx), queryFilter, this.limitQuery, this.queryMatches);
        this.associator.initialize(this.recognizer.getTotalWords());
        this.loadFrameIntoSource(frameIdx);
        for (int queryIdx = 0; queryIdx < this.queryMatches.size; ++queryIdx) {
            int matchedFrameIdx = Integer.parseInt(((SceneRecognition.Match)this.queryMatches.get((int)queryIdx)).id);
            this.checkSimilarConnection(frameIdx, matchedFrameIdx, similarImages);
        }
        if (this.verbose != null) {
            this.verbose.printf("query[%d] match.size=%d similar.size=%d\n", frameIdx, this.queryMatches.size, similarImages.size());
        }
    }

    @Override
    public boolean lookupAssociated(String viewB, DogArray<AssociatedIndex> pairs) {
        pairs.reset();
        PairInfo info = this.viewId_to_pairs.get(viewB);
        if (info != null) {
            pairs.copyAll(info.associated.toList(), (original, copy) -> copy.setTo(original));
            return true;
        }
        return super.lookupAssociated(viewB, pairs);
    }

    private BoofLambdas.Filter<String> filterQuery(@Nullable BoofLambdas.Filter<String> filter, int frameIdx, SimilarImagesFromTracks.Frame frameTarget) {
        return id -> {
            int matchedFrameIdx = Integer.parseInt(id);
            if (matchedFrameIdx == frameIdx) {
                return false;
            }
            SimilarImagesFromTracks.Frame frameCandidate = (SimilarImagesFromTracks.Frame)this.frames.get(matchedFrameIdx);
            if (frameTarget.isMatched(frameCandidate)) {
                return false;
            }
            if (filter != null && !filter.keep(id)) {
                return false;
            }
            boolean checkConnection = false;
            if (Math.abs(matchedFrameIdx - frameIdx) < this.searchRadius) {
                checkConnection = true;
            } else if (Math.abs(matchedFrameIdx - frameIdx) >= this.minimumRecognizeDistance) {
                checkConnection = true;
            }
            return checkConnection;
        };
    }

    protected void checkSimilarConnection(int frameIdx, int matchedFrameIdx, List<String> similarImages) {
        this.loadFrameIntoDestination(matchedFrameIdx);
        this.associator.associate();
        FastAccess matches = this.associator.getMatches();
        boolean similar = this.similarityTest.isSimilar((FastAccess<Point2D_F64>)this.sourcePixels, (FastAccess<Point2D_F64>)this.destinationPixels, (FastAccess<AssociatedIndex>)matches);
        if (!similar) {
            return;
        }
        if (this.verbose != null) {
            this.verbose.printf("connecting %3d to %3d. matches.size=%d\n", frameIdx, matchedFrameIdx, matches.size);
        }
        String id = ((SimilarImagesFromTracks.Frame)this.frames.get((int)matchedFrameIdx)).frameID;
        similarImages.add(id);
        PairInfo info = (PairInfo)this.pairInfo.grow();
        info.associated.copyAll(this.associator.getMatches().toList(), (original, copy) -> copy.setTo(original));
        this.viewId_to_pairs.put(id, info);
    }

    private void loadFrameIntoSource(int frameIdx) {
        SimilarImagesFromTracks.Frame frame = (SimilarImagesFromTracks.Frame)this.frames.get(frameIdx);
        int featureOffset = this.frameStartIndexes.get(frameIdx);
        int numberOfFeatures = frame.featureCount();
        this.sourceDescriptions.reset();
        this.sourcePixels.reset();
        for (int i = 0; i < numberOfFeatures; ++i) {
            TupleDesc desc = (TupleDesc)this.sourceDescriptions.grow();
            this.descriptions.getCopy(featureOffset + i, (Object)desc);
            frame.getPixel(i, (Point2D_F64)this.sourcePixels.grow());
            this.associator.addSource((Object)desc, this.recognizer.lookupWord(desc));
        }
    }

    private void loadFrameIntoDestination(int frameIdx) {
        SimilarImagesFromTracks.Frame frame = (SimilarImagesFromTracks.Frame)this.frames.get(frameIdx);
        int featureOffset = this.frameStartIndexes.get(frameIdx);
        int numberOfFeatures = frame.featureCount();
        this.destinationDescriptions.reset();
        this.destinationPixels.reset();
        this.associator.clearDestination();
        for (int i = 0; i < numberOfFeatures; ++i) {
            TupleDesc desc = (TupleDesc)this.destinationDescriptions.grow();
            this.descriptions.getCopy(featureOffset + i, (Object)desc);
            frame.getPixel(i, (Point2D_F64)this.destinationPixels.grow());
            this.associator.addDestination((Object)desc, this.recognizer.lookupWord(desc));
        }
    }

    private FeatureSceneRecognition.Features<TD> wrapFeatures(final int frameIdx) {
        final int offset = this.frameStartIndexes.get(frameIdx);
        return new FeatureSceneRecognition.Features<TD>(){
            final Point2D_F64 pixel = new Point2D_F64();
            final SimilarImagesFromTracks.Frame frame;
            {
                this.frame = (SimilarImagesFromTracks.Frame)SimilarImagesTrackThenMatch.this.frames.get(frameIdx);
            }

            public Point2D_F64 getPixel(int index) {
                this.frame.getPixel(index, this.pixel);
                return this.pixel;
            }

            public TD getDescription(int index) {
                return (TupleDesc)SimilarImagesTrackThenMatch.this.descriptions.getTemp(offset + index);
            }

            public int size() {
                return this.frame.featureCount();
            }
        };
    }

    private int frameToIndex(String id) {
        return Integer.parseInt(id);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> options) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, options, (VerbosePrint[])new VerbosePrint[]{this.recognizer});
    }

    public int getMinimumRecognizeDistance() {
        return this.minimumRecognizeDistance;
    }

    public void setMinimumRecognizeDistance(int minimumRecognizeDistance) {
        this.minimumRecognizeDistance = minimumRecognizeDistance;
    }

    public int getLimitQuery() {
        return this.limitQuery;
    }

    public void setLimitQuery(int limitQuery) {
        this.limitQuery = limitQuery;
    }

    public DescribePoint<Image, TD> getDescriber() {
        return this.describer;
    }

    public void setDescriber(DescribePoint<Image, TD> describer) {
        this.describer = describer;
    }

    public AssociateDescriptionHashSets<TD> getAssociator() {
        return this.associator;
    }

    public FeatureSceneRecognition<TD> getRecognizer() {
        return this.recognizer;
    }

    public boolean isLearnModel() {
        return this.learnModel;
    }

    public void setLearnModel(boolean learnModel) {
        this.learnModel = learnModel;
    }

    public SimilarImagesSceneRecognition.SimilarityTest getSimilarityTest() {
        return this.similarityTest;
    }

    public void setSimilarityTest(SimilarImagesSceneRecognition.SimilarityTest similarityTest) {
        this.similarityTest = similarityTest;
    }

    protected static class PairInfo {
        public DogArray<AssociatedIndex> associated = new DogArray(AssociatedIndex::new);

        protected PairInfo() {
        }

        public void reset() {
            this.associated.reset();
        }
    }
}

