/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.alg.structure.EpipolarScore3D;
import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class GeneratePairwiseImageGraph
implements VerbosePrint {
    public final PairwiseImageGraph graph = new PairwiseImageGraph();
    private List<String> imageIds;
    public final EpipolarScore3D epipolarScore;
    private PrintStream verbose;
    CameraPinholeBrown priorA = new CameraPinholeBrown(2);
    CameraPinholeBrown priorB = new CameraPinholeBrown(2);
    DogArray<AssociatedIndex> matches = new DogArray(AssociatedIndex::new);
    DogArray<AssociatedPair> pairs = new DogArray(AssociatedPair::new);
    DogArray<Point2D_F64> srcFeats = new DogArray(Point2D_F64::new);
    DogArray<Point2D_F64> dstFeats = new DogArray(Point2D_F64::new);

    public GeneratePairwiseImageGraph(EpipolarScore3D epipolarScore) {
        this.epipolarScore = epipolarScore;
    }

    public void process(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams) {
        int idxTgt;
        this.imageIds = dbSimilar.getImageIDs();
        this.graph.reset();
        ArrayList<String> similar = new ArrayList<String>();
        this.matches.reset();
        this.pairs.reset();
        this.srcFeats.reset();
        this.dstFeats.reset();
        HashMap<String, Integer> imageToIndex = new HashMap<String, Integer>();
        for (idxTgt = 0; idxTgt < this.imageIds.size(); ++idxTgt) {
            imageToIndex.put(this.imageIds.get(idxTgt), idxTgt);
            this.graph.createNode(this.imageIds.get(idxTgt));
        }
        if (this.verbose != null) {
            this.verbose.println("total images = " + this.imageIds.size());
        }
        for (idxTgt = 0; idxTgt < this.imageIds.size(); ++idxTgt) {
            String src = this.imageIds.get(idxTgt);
            if (this.verbose != null) {
                this.verbose.println("Target view='" + src + "'");
            }
            int _idxTgt = idxTgt;
            dbSimilar.findSimilar(src, (BoofLambdas.Filter<String>)((BoofLambdas.Filter)id -> (Integer)imageToIndex.get(id) > _idxTgt), similar);
            dbSimilar.lookupPixelFeats(src, this.srcFeats);
            if (this.verbose != null) {
                this.verbose.println("similar.size=" + similar.size() + " feats.size=" + this.srcFeats.size);
            }
            ((PairwiseImageGraph.View)this.graph.nodes.get((int)idxTgt)).totalObservations = this.srcFeats.size;
            for (int idxSimilar = 0; idxSimilar < similar.size(); ++idxSimilar) {
                String dst = (String)similar.get(idxSimilar);
                int dstIdx = (Integer)imageToIndex.get(dst);
                if (dstIdx <= idxTgt) {
                    throw new RuntimeException("BUG! should have been filtered by find similar");
                }
                dbSimilar.lookupPixelFeats(dst, this.dstFeats);
                dbSimilar.lookupAssociated(dst, this.matches);
                this.pairs.reset();
                for (int i = 0; i < this.matches.size; ++i) {
                    AssociatedIndex m = (AssociatedIndex)this.matches.get(i);
                    ((AssociatedPair)this.pairs.grow()).setTo((Point2D_F64)this.srcFeats.get(m.src), (Point2D_F64)this.dstFeats.get(m.dst));
                }
                this.createEdge(dbCams, src, dst, this.pairs, this.matches);
            }
        }
    }

    protected void createEdge(LookUpCameraInfo dbCams, String src, String dst, DogArray<AssociatedPair> pairs, DogArray<AssociatedIndex> matches) {
        boolean sameCamera;
        DMatrixRMaj fundamental = new DMatrixRMaj(3, 3);
        DogArray_I32 inlierIdx = new DogArray_I32();
        dbCams.lookupCalibration(src, this.priorA);
        dbCams.lookupCalibration(dst, this.priorB);
        boolean bl = sameCamera = dbCams.viewToCamera(src) == dbCams.viewToCamera(dst);
        if (this.verbose != null) {
            this.verbose.printf("_ createEdge['%s'] -> '%s', prior: src={fx=%.1f cx=%.1f cy=%.1f}  dst={fx=%.1f cx=%.1f cy=%.1f} \n", src, dst, this.priorA.fx, this.priorA.cx, this.priorA.cy, this.priorB.fx, this.priorB.cx, this.priorB.cy);
        }
        this.epipolarScore.process(this.priorA, sameCamera ? null : this.priorB, this.srcFeats.size, this.dstFeats.size, pairs.toList(), fundamental, inlierIdx);
        PairwiseImageGraph.Motion edge = (PairwiseImageGraph.Motion)this.graph.edges.grow();
        edge.is3D = this.epipolarScore.is3D();
        edge.score3D = this.epipolarScore.getScore();
        edge.index = this.graph.edges.size - 1;
        edge.src = this.graph.lookupNode(src);
        edge.dst = this.graph.lookupNode(dst);
        edge.src.connections.add((Object)edge);
        edge.dst.connections.add((Object)edge);
        edge.inliers.resize(inlierIdx.size);
        for (int i = 0; i < inlierIdx.size; ++i) {
            ((AssociatedIndex)edge.inliers.get(i)).setTo((AssociatedIndex)matches.get(inlierIdx.get(i)));
        }
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.epipolarScore});
    }

    public PairwiseImageGraph getGraph() {
        return this.graph;
    }

    public EpipolarScore3D getEpipolarScore() {
        return this.epipolarScore;
    }
}

