/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.ScaleSceneStructure;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.pose.PoseFromPairLinear6;
import boofcv.alg.structure.ConfigProjectiveReconstruction;
import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.ConfigTrifocalError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class PairwiseGraphUtils {
    public LookUpSimilarImages dbSimilar;
    public LookUpCameraInfo dbCams;
    public DogArray_B visibleAll = new DogArray_B();
    public DogArray_B visibleMotion = new DogArray_B();
    public ConfigConverge configConvergeSBA = new ConfigConverge(1.0E-8, 1.0E-8, 50);
    public boolean configScaleSBA = false;
    protected final SceneStructureProjective structure = new SceneStructureProjective(true);
    protected final SceneObservations observations = new SceneObservations();
    protected ModelMatcher<TrifocalTensor, AssociatedTriple> ransac;
    protected TriangulateNViewsProjective triangulator;
    protected PoseFromPairLinear6 poseEstimator = new PoseFromPairLinear6();
    protected BundleAdjustment<SceneStructureProjective> sba;
    protected ScaleSceneStructure scaler = new ScaleSceneStructure();
    public PairwiseImageGraph.View seed;
    public PairwiseImageGraph.View viewB;
    public PairwiseImageGraph.View viewC;
    public CameraPinholeBrown priorCamA = new CameraPinholeBrown(2);
    public CameraPinholeBrown priorCamB = new CameraPinholeBrown(2);
    public CameraPinholeBrown priorCamC = new CameraPinholeBrown(2);
    public final DogArray<AssociatedTriple> matchesTriple = new DogArray(AssociatedTriple::new);
    public final FastArray<AssociatedTriple> inliersThreeView = new FastArray(AssociatedTriple.class);
    public final DogArray_I32 inlierIdx = new DogArray_I32();
    public final DMatrixRMaj P1 = new DMatrixRMaj(3, 4);
    public final DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
    public final DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
    public final DogArray<Point2D_F64> featsA = new DogArray(Point2D_F64::new);
    public final DogArray<Point2D_F64> featsB = new DogArray(Point2D_F64::new);
    public final DogArray<Point2D_F64> featsC = new DogArray(Point2D_F64::new);
    public final DogArray_I32 table_A_to_B = new DogArray_I32();
    public final DogArray_I32 table_A_to_C = new DogArray_I32();
    public final DogArray_I32 table_B_to_C = new DogArray_I32();
    public final DogArray_I32 table_C_to_A = new DogArray_I32();
    public final DogArray_I32 commonIdx = new DogArray_I32();

    public PairwiseGraphUtils(TriangulateNViewsProjective triangulator, ModelMatcher<TrifocalTensor, AssociatedTriple> ransac, BundleAdjustment<SceneStructureProjective> sba) {
        this.triangulator = triangulator;
        this.ransac = ransac;
        this.sba = sba;
    }

    public PairwiseGraphUtils(ConfigProjectiveReconstruction config) {
        config.checkValidity();
        this.triangulator = FactoryMultiView.triangulateNViewProj((ConfigTriangulation)ConfigTriangulation.GEOMETRIC());
        this.ransac = FactoryMultiViewRobust.trifocalRansac((ConfigTrifocal)config.ransacTrifocal, (ConfigTrifocalError)config.ransacError, (ConfigRansac)config.ransac);
        this.sba = FactoryMultiView.bundleSparseProjective((ConfigBundleAdjustment)config.sba);
        this.configConvergeSBA.setTo(config.sbaConverge);
        this.configScaleSBA = config.sbaScale;
    }

    public PairwiseGraphUtils() {
    }

    public void findAllConnectedSeed(PairwiseImageGraph.View seed, DogArray_I32 connectIdx, DogArray_I32 commonIdx) {
        if (connectIdx.size < 1) {
            throw new RuntimeException("Called when there are no connections");
        }
        this.visibleAll.resetResize(seed.totalObservations, true);
        this.visibleMotion.resize(seed.totalObservations);
        for (int idxMotion = 0; idxMotion < connectIdx.size; ++idxMotion) {
            int i;
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)seed.connections.get(connectIdx.get(idxMotion));
            boolean seedIsSrc = m.src == seed;
            this.visibleMotion.fill(false);
            for (i = 0; i < m.inliers.size; ++i) {
                AssociatedIndex a = (AssociatedIndex)m.inliers.get(i);
                this.visibleMotion.data[seedIsSrc ? a.src : a.dst] = true;
            }
            for (i = 0; i < seed.totalObservations; ++i) {
                int n = i;
                this.visibleAll.data[n] = this.visibleAll.data[n] & this.visibleMotion.data[i];
            }
        }
        commonIdx.reset();
        for (int i = 0; i < seed.totalObservations; ++i) {
            if (!this.visibleAll.data[i]) continue;
            commonIdx.add(i);
        }
    }

    public void createThreeViewLookUpTables() {
        PairwiseImageGraph.Motion connAB = this.seed.findMotion(this.viewB);
        PairwiseImageGraph.Motion connAC = this.seed.findMotion(this.viewC);
        PairwiseImageGraph.Motion connBC = this.viewB.findMotion(this.viewC);
        PairwiseGraphUtils.createTableViewAtoB(this.seed, connAB, this.table_A_to_B);
        PairwiseGraphUtils.createTableViewAtoB(this.seed, connAC, this.table_A_to_C);
        PairwiseGraphUtils.createTableViewAtoB(this.viewB, connBC, this.table_B_to_C);
        PairwiseGraphUtils.createTableViewAtoB(this.viewC, connAC, this.table_C_to_A);
    }

    public void findFullyConnectedTriple() {
        int N = this.seed.totalObservations;
        this.commonIdx.reset();
        for (int featureIdxA = 0; featureIdxA < N; ++featureIdxA) {
            int featureIdxB;
            int featureIdxC;
            if (this.table_A_to_B.data[featureIdxA] < 0 || this.table_A_to_C.data[featureIdxA] < 0 || (featureIdxC = this.table_B_to_C.data[featureIdxB = this.table_A_to_B.data[featureIdxA]]) < 0 || this.table_C_to_A.data[featureIdxC] != featureIdxA) continue;
            this.commonIdx.add(featureIdxA);
        }
    }

    public void findFullyConnectedTriple(DogArray_I32 selectedIdxA) {
        this.commonIdx.reset();
        for (int selectedIdx = 0; selectedIdx < selectedIdxA.size; ++selectedIdx) {
            int featureIdxA = selectedIdxA.get(selectedIdx);
            int featureIdxB = this.table_A_to_B.data[featureIdxA];
            int featureIdxC = this.table_B_to_C.data[featureIdxB];
            if (featureIdxC < 0 || this.table_C_to_A.data[featureIdxC] != featureIdxA) continue;
            this.commonIdx.add(featureIdxA);
        }
    }

    public void createTripleFromCommon(@Nullable PrintStream verbose) {
        this.dbCams.lookupCalibration(this.dbCams.viewToCamera(this.seed.id), this.priorCamA);
        this.dbCams.lookupCalibration(this.dbCams.viewToCamera(this.viewB.id), this.priorCamB);
        this.dbCams.lookupCalibration(this.dbCams.viewToCamera(this.viewC.id), this.priorCamC);
        if (verbose != null) {
            verbose.printf("prior: A={fx=%.1f cx=%.1f %.1f} B={fx=%.1f cx=%.1f %.1f} C={fx=%.1f cx=%.1f %.1f}\n", this.priorCamA.fx, this.priorCamA.cx, this.priorCamA.cy, this.priorCamB.fx, this.priorCamB.cx, this.priorCamB.cy, this.priorCamC.fx, this.priorCamC.cx, this.priorCamC.cy);
        }
        this.dbSimilar.lookupPixelFeats(this.seed.id, this.featsA);
        this.dbSimilar.lookupPixelFeats(this.viewB.id, this.featsB);
        this.dbSimilar.lookupPixelFeats(this.viewC.id, this.featsC);
        BoofMiscOps.offsetPixels((List)this.featsA.toList(), (double)(-this.priorCamA.cx), (double)(-this.priorCamA.cy));
        BoofMiscOps.offsetPixels((List)this.featsB.toList(), (double)(-this.priorCamB.cx), (double)(-this.priorCamB.cy));
        BoofMiscOps.offsetPixels((List)this.featsC.toList(), (double)(-this.priorCamC.cx), (double)(-this.priorCamC.cy));
        this.matchesTriple.reset();
        this.matchesTriple.resize(this.commonIdx.size);
        for (int i = 0; i < this.commonIdx.size; ++i) {
            int indexA = this.commonIdx.get(i);
            int indexB = this.table_A_to_B.data[indexA];
            int indexC = this.table_A_to_C.data[indexA];
            ((AssociatedTriple)this.matchesTriple.get(i)).setTo((Point2D_F64)this.featsA.get(indexA), (Point2D_F64)this.featsB.get(indexB), (Point2D_F64)this.featsC.get(indexC));
        }
    }

    public boolean estimateProjectiveCamerasRobustly() {
        if (!this.ransac.process(this.matchesTriple.toList())) {
            return false;
        }
        TrifocalTensor model = (TrifocalTensor)this.ransac.getModelParameters();
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.P1);
        MultiViewOps.trifocalToCameraMatrices((TrifocalTensor)model, (DMatrixRMaj)this.P2, (DMatrixRMaj)this.P3);
        this.inliersThreeView.reset();
        this.inliersThreeView.addAll(this.ransac.getMatchSet());
        this.inlierIdx.reset();
        this.inlierIdx.resize(this.inliersThreeView.size);
        for (int i = 0; i < this.inliersThreeView.size; ++i) {
            this.inlierIdx.data[i] = this.ransac.getInputIndex(i);
        }
        return true;
    }

    public SceneWorkingGraph.InlierInfo saveRansacInliers(SceneWorkingGraph.View view, DogArray_I32 inlierIdx) {
        int[] nArray;
        int viewIdx = this.seed == view.pview ? 0 : (this.viewB == view.pview ? 1 : (this.viewC == view.pview ? 2 : -1));
        switch (viewIdx) {
            case 0: {
                int[] nArray2 = new int[3];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray = nArray2;
                nArray2[2] = 2;
                break;
            }
            case 1: {
                int[] nArray3 = new int[3];
                nArray3[0] = 1;
                nArray3[1] = 0;
                nArray = nArray3;
                nArray3[2] = 2;
                break;
            }
            case 2: {
                int[] nArray4 = new int[3];
                nArray4[0] = 2;
                nArray4[1] = 1;
                nArray = nArray4;
                nArray4[2] = 0;
                break;
            }
            default: {
                throw new RuntimeException("Passed in view is not any of the three expected");
            }
        }
        int[] order = nArray;
        int numInliers = inlierIdx.size();
        BoofMiscOps.checkTrue((view.inliers.size == 0 ? 1 : 0) != 0, (String)"Inliers should not have already been set for this view");
        SceneWorkingGraph.InlierInfo info = (SceneWorkingGraph.InlierInfo)view.inliers.grow();
        info.observations.reset();
        info.observations.resize(3);
        DogArray_I32 indexesA = (DogArray_I32)info.observations.get(order[0]);
        DogArray_I32 indexesB = (DogArray_I32)info.observations.get(order[1]);
        DogArray_I32 indexesC = (DogArray_I32)info.observations.get(order[2]);
        for (int inlierCnt = 0; inlierCnt < numInliers; ++inlierCnt) {
            int indexA = this.commonIdx.get(inlierIdx.get(inlierCnt));
            indexesA.add(indexA);
            indexesB.add(this.table_A_to_B.data[indexA]);
            indexesC.add(this.table_A_to_C.data[indexA]);
        }
        info.views.resize(3);
        for (int i = 0; i < 3; ++i) {
            PairwiseImageGraph.View view2;
            switch (i) {
                case 0: {
                    view2 = this.seed;
                    break;
                }
                case 1: {
                    view2 = this.viewB;
                    break;
                }
                case 2: {
                    view2 = this.viewC;
                    break;
                }
                default: {
                    throw new RuntimeException("BUG");
                }
            }
            PairwiseImageGraph.View v = view2;
            info.views.set(order[i], (Object)v);
        }
        return info;
    }

    public void initializeSbaSceneThreeView(boolean fixedSeed) {
        this.structure.initialize(3, this.inliersThreeView.size());
        this.dbCams.lookupCalibration(this.dbCams.viewToCamera(this.seed.id), this.priorCamA);
        this.dbCams.lookupCalibration(this.dbCams.viewToCamera(this.viewB.id), this.priorCamB);
        this.dbCams.lookupCalibration(this.dbCams.viewToCamera(this.viewC.id), this.priorCamC);
        this.structure.setView(0, fixedSeed, this.P1, this.priorCamA.width, this.priorCamA.height);
        this.structure.setView(1, !fixedSeed, this.P2, this.priorCamB.width, this.priorCamB.height);
        this.structure.setView(2, !fixedSeed, this.P3, this.priorCamC.width, this.priorCamC.height);
        this.triangulateFeatures();
    }

    protected void triangulateFeatures() {
        BoofMiscOps.checkTrue((this.structure.views.size > 0 ? 1 : 0) != 0, (String)"Must initialize the structure first");
        BoofMiscOps.checkTrue((this.structure.points.size == this.inliersThreeView.size() ? 1 : 0) != 0, (String)"Number of inliers must match the number of points in the scene");
        ArrayList<DMatrixRMaj> cameraMatrices = new ArrayList<DMatrixRMaj>();
        cameraMatrices.add(this.P1);
        cameraMatrices.add(this.P2);
        cameraMatrices.add(this.P3);
        ArrayList<Point2D_F64> triangObs = new ArrayList<Point2D_F64>();
        triangObs.add(null);
        triangObs.add(null);
        triangObs.add(null);
        Point4D_F64 X = new Point4D_F64();
        for (int i = 0; i < this.inliersThreeView.size(); ++i) {
            AssociatedTriple t = (AssociatedTriple)this.inliersThreeView.get(i);
            triangObs.set(0, t.p1);
            triangObs.set(1, t.p2);
            triangObs.set(2, t.p3);
            if (!this.triangulator.triangulate(triangObs, cameraMatrices, X)) {
                throw new RuntimeException("Failed to triangulate a point in the inlier set?! Handle if this is common");
            }
            ((SceneStructureCommon.Point[])this.structure.points.data)[i].set(X.x, X.y, X.z, X.w);
        }
    }

    public void initializeSbaObservationsThreeView() {
        this.observations.initialize(3);
        SceneObservations.View view1 = this.observations.getView(0);
        SceneObservations.View view2 = this.observations.getView(1);
        SceneObservations.View view3 = this.observations.getView(2);
        for (int i = 0; i < this.inliersThreeView.size(); ++i) {
            AssociatedTriple t = (AssociatedTriple)this.inliersThreeView.get(i);
            view1.add(i, (float)t.p1.x, (float)t.p1.y);
            view2.add(i, (float)t.p2.x, (float)t.p2.y);
            view3.add(i, (float)t.p3.x, (float)t.p3.y);
        }
    }

    public boolean refineWithBundleAdjustment() {
        if (this.configConvergeSBA.maxIterations <= 0) {
            return true;
        }
        if (this.configScaleSBA) {
            this.scaler.applyScale(this.structure, this.observations);
        }
        this.sba.setParameters((SceneStructure)this.structure, this.observations);
        this.sba.configure(this.configConvergeSBA.ftol, this.configConvergeSBA.gtol, this.configConvergeSBA.maxIterations);
        if (!this.sba.optimize((SceneStructure)this.structure)) {
            return false;
        }
        if (this.configScaleSBA) {
            this.scaler.undoScale(this.structure, this.observations);
        }
        return true;
    }

    public static void createTableViewAtoB(PairwiseImageGraph.View viewA, PairwiseImageGraph.Motion edge, DogArray_I32 table_a_to_b) {
        table_a_to_b.resetResize(viewA.totalObservations, -1);
        boolean src_is_A = edge.src == viewA;
        for (int i = 0; i < edge.inliers.size; ++i) {
            AssociatedIndex assoc = (AssociatedIndex)edge.inliers.get(i);
            table_a_to_b.data[src_is_A ? assoc.src : assoc.dst] = src_is_A ? assoc.dst : assoc.src;
        }
    }

    public SceneStructureProjective getStructure() {
        return this.structure;
    }

    public SceneObservations getObservations() {
        return this.observations;
    }

    public ModelMatcher<TrifocalTensor, AssociatedTriple> getRansac() {
        return this.ransac;
    }

    public TriangulateNViewsProjective getTriangulator() {
        return this.triangulator;
    }

    public PoseFromPairLinear6 getPoseEstimator() {
        return this.poseEstimator;
    }

    public BundleAdjustment<SceneStructureProjective> getSba() {
        return this.sba;
    }

    public ScaleSceneStructure getScaler() {
        return this.scaler;
    }
}

