/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.similar;

import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.misc.BoofLambdas;
import boofcv.struct.feature.AssociatedIndex;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class SimilarImagesData
implements LookUpSimilarImages {
    public final List<String> listImages = new ArrayList<String>();
    public final Map<String, Info> imageMap = new HashMap<String, Info>();
    @Nullable
    Info targetInfo;

    public void reset() {
        this.listImages.clear();
        this.imageMap.clear();
        this.targetInfo = null;
    }

    public void add(String id, List<Point2D_F64> features) {
        Info info = new Info();
        info.index = this.listImages.size();
        info.features.copyAll(features, (src, dst) -> dst.setTo(src));
        this.listImages.add(id);
        this.imageMap.put(id, info);
    }

    public void setRelationship(String viewA, String viewB, List<AssociatedIndex> matches) {
        Info infoA = Objects.requireNonNull(this.imageMap.get(viewA));
        Info infoB = Objects.requireNonNull(this.imageMap.get(viewB));
        infoA.similarViews.add(viewB);
        infoB.similarViews.add(viewA);
        boolean swapped = false;
        if (infoA.index > infoB.index) {
            Info tmp = infoA;
            infoA = infoB;
            infoB = tmp;
            swapped = true;
        }
        Relationship related = new Relationship(this.listImages.get(infoB.index));
        infoA.relationships.add(related);
        related.pairs.resize(matches.size());
        for (int i = 0; i < matches.size(); ++i) {
            AssociatedIndex a = (AssociatedIndex)related.pairs.get(i);
            AssociatedIndex b = matches.get(i);
            if (swapped) {
                a.setTo(b.dst, b.src);
                continue;
            }
            a.setTo(b);
        }
    }

    @Override
    public List<String> getImageIDs() {
        return this.listImages;
    }

    @Override
    public void findSimilar(String target, @Nullable BoofLambdas.Filter<String> filter, List<String> similarImages) {
        similarImages.clear();
        Info info = Objects.requireNonNull(this.imageMap.get(target));
        for (int i = 0; i < info.similarViews.size(); ++i) {
            if (filter != null && !filter.keep((Object)info.similarViews.get(i))) continue;
            similarImages.add(info.similarViews.get(i));
        }
        this.targetInfo = info;
    }

    @Override
    public void lookupPixelFeats(String target, DogArray<Point2D_F64> features) {
        Info similarInfo = Objects.requireNonNull(this.imageMap.get(target));
        features.reset();
        features.copyAll(similarInfo.features.toList(), (src, dst) -> dst.setTo(src));
    }

    @Override
    public boolean lookupAssociated(String similarD, DogArray<AssociatedIndex> pairs) {
        boolean swapped;
        Objects.requireNonNull(this.targetInfo, "Must call findSimilar first");
        Info similarInfo = Objects.requireNonNull(this.imageMap.get(similarD));
        boolean bl = swapped = this.targetInfo.index > similarInfo.index;
        if (swapped) {
            String targetID = this.listImages.get(this.targetInfo.index);
            Relationship related = Objects.requireNonNull(similarInfo.findRelated(targetID));
            pairs.reset().resize(related.pairs.size);
            for (int i = 0; i < pairs.size; ++i) {
                AssociatedIndex b = (AssociatedIndex)related.pairs.get(i);
                ((AssociatedIndex)pairs.get(i)).setTo(b.dst, b.src);
            }
        } else {
            Relationship related = Objects.requireNonNull(this.targetInfo.findRelated(similarD));
            pairs.reset().resize(related.pairs.size);
            for (int i = 0; i < pairs.size; ++i) {
                ((AssociatedIndex)pairs.get(i)).setTo((AssociatedIndex)related.pairs.get(i));
            }
        }
        return true;
    }

    public static class Info {
        public int index;
        public final List<String> similarViews = new ArrayList<String>();
        public final List<Relationship> relationships = new ArrayList<Relationship>();
        public final DogArray<Point2D_F64> features = new DogArray(Point2D_F64::new);

        @Nullable
        public Relationship findRelated(String id) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                if (!this.relationships.get((int)i).id.equals(id)) continue;
                return this.relationships.get(i);
            }
            return null;
        }
    }

    public static class Relationship {
        public String id;
        DogArray<AssociatedIndex> pairs = new DogArray(AssociatedIndex::new);

        public Relationship(String id) {
            this.id = id;
        }
    }
}

