/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.expand;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.geo.selfcalib.TwoViewToCalibratingHomography;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.alg.structure.expand.EstimateViewUtils;
import boofcv.alg.structure.expand.MetricExpandByOneView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class EstimateViewSelfCalibrate
implements VerbosePrint {
    public double fractionBadFeaturesRecover = 0.05;
    protected TwoViewToCalibratingHomography projectiveHomography = new TwoViewToCalibratingHomography();
    public final EstimateViewUtils estimateUtils = new EstimateViewUtils();
    PairwiseGraphUtils pairwiseUtils;
    SceneWorkingGraph workGraph;
    DMatrixRMaj F21 = new DMatrixRMaj(3, 3);
    DMatrixRMaj K1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj K2 = new DMatrixRMaj(3, 3);
    DogArray<AssociatedPair> pairs = new DogArray(AssociatedPair::new);
    Se3_F64 view1_to_view2H = new Se3_F64();
    DMatrixRMaj K_target = new DMatrixRMaj(3, 3);
    BundlePinholeSimplified intrinsicTarget = new BundlePinholeSimplified();
    @Nullable
    PrintStream verbose;

    public boolean process(PairwiseGraphUtils pairwiseUtils, SceneWorkingGraph workGraph, MetricExpandByOneView.Solution solution) {
        this.pairwiseUtils = pairwiseUtils;
        this.workGraph = workGraph;
        solution.reset();
        this.estimateUtils.initialize(false, workGraph, pairwiseUtils);
        if (!this.computeCalibratingHomography()) {
            return false;
        }
        if (!this.upgradeToMetric(this.projectiveHomography.getCalibrationHomography())) {
            return false;
        }
        this.estimateUtils.usedThreeViewInliers.reset();
        this.estimateUtils.usedThreeViewInliers.resize(pairwiseUtils.inliersThreeView.size, idx -> idx);
        if (!this.refineWithBundleAdjustment()) {
            return false;
        }
        if (!this.removedBadFeatures()) {
            return false;
        }
        this.estimateUtils.copyToSolution(pairwiseUtils, solution);
        if (this.verbose != null) {
            Se3_F64 view1_to_target = this.estimateUtils.view1_to_target;
            this.verbose.printf("Rescaled Local T=(%.2f %.2f %.2f)\n", view1_to_target.T.x, view1_to_target.T.y, view1_to_target.T.z);
            this.verbose.printf("Final Global   T=(%.2f %.2f %.2f)\n", solution.world_to_target.T.x, solution.world_to_target.T.y, solution.world_to_target.T.z);
        }
        return true;
    }

    boolean computeCalibratingHomography() {
        MultiViewOps.projectiveToFundamental((DMatrixRMaj)this.pairwiseUtils.P2, (DMatrixRMaj)this.F21);
        this.projectiveHomography.initialize(this.F21, this.pairwiseUtils.P2);
        BundlePinholeSimplified camera1 = this.workGraph.getViewCamera((SceneWorkingGraph.View)this.workGraph.lookupView((String)this.pairwiseUtils.seed.id)).intrinsic;
        BundlePinholeSimplified camera2 = this.workGraph.getViewCamera((SceneWorkingGraph.View)this.workGraph.lookupView((String)this.pairwiseUtils.viewB.id)).intrinsic;
        BundleAdjustmentOps.convert((BundlePinholeSimplified)camera1, (DMatrixRMaj)this.K1);
        BundleAdjustmentOps.convert((BundlePinholeSimplified)camera2, (DMatrixRMaj)this.K2);
        DogArray<AssociatedTriple> triples = this.pairwiseUtils.matchesTriple;
        this.pairs.resize(triples.size());
        for (int idx = 0; idx < triples.size(); ++idx) {
            AssociatedTriple a = (AssociatedTriple)triples.get(idx);
            ((AssociatedPair)this.pairs.get(idx)).setTo(a.p1, a.p2);
        }
        return this.projectiveHomography.process(this.K1, this.K2, this.pairs.toList());
    }

    private boolean upgradeToMetric(DMatrixRMaj H_cal) {
        boolean negate;
        if (!MultiViewOps.projectiveToMetric((DMatrixRMaj)this.pairwiseUtils.P2, (DMatrixRMaj)H_cal, (Se3_F64)this.view1_to_view2H, (DMatrixRMaj)this.K_target)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED projectiveToMetric P2");
            }
            return false;
        }
        if (!MultiViewOps.projectiveToMetric((DMatrixRMaj)this.pairwiseUtils.P3, (DMatrixRMaj)H_cal, (Se3_F64)this.estimateUtils.view1_to_target, (DMatrixRMaj)this.K_target)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED projectiveToMetric P3");
            }
            return false;
        }
        BundleAdjustmentOps.convert((DMatrixRMaj)this.K_target, (BundlePinholeSimplified)this.intrinsicTarget);
        this.estimateUtils.setCamera3(this.intrinsicTarget);
        double norm = this.view1_to_view2H.T.norm();
        this.estimateUtils.view1_to_target.T.divide(norm);
        this.view1_to_view2H.T.divide(norm);
        boolean bl = negate = MultiViewOps.findScale((GeoTuple3D_F64)this.view1_to_view2H.T, (GeoTuple3D_F64)this.estimateUtils.view1_to_view2.T) < 0.0;
        if (negate) {
            this.estimateUtils.view1_to_target.T.scale(-1.0);
            this.view1_to_view2H.T.scale(-1.0);
        }
        if (this.verbose != null) {
            this.verbose.printf("L  View 1 to 2     T=(%.1f %.1f %.1f) scale=%f\n", this.estimateUtils.view1_to_view2.T.x, this.estimateUtils.view1_to_view2.T.y, this.estimateUtils.view1_to_view2.T.z, this.estimateUtils.local_to_global);
            this.verbose.printf("H  View 1 to 2     T=(%.1f %.1f %.1f)\n", this.view1_to_view2H.T.x, this.view1_to_view2H.T.y, this.view1_to_view2H.T.z);
            SceneWorkingGraph.Camera camera1 = this.workGraph.getViewCamera(this.estimateUtils.wview1);
            SceneWorkingGraph.Camera camera2 = this.workGraph.getViewCamera(this.estimateUtils.wview2);
            Se3_F64 view1_to_target = this.estimateUtils.view1_to_target;
            this.verbose.printf("view1.f=%.2f view2.f=%.2f\n", camera1.intrinsic.f, camera2.intrinsic.f);
            this.verbose.printf("Initial T=(%.1f %.1f %.1f) f=%.1f k1=%.3f k2=%.3f\n", view1_to_target.T.x, view1_to_target.T.y, view1_to_target.T.z, this.estimateUtils.camera3.f, this.estimateUtils.camera3.k1, this.estimateUtils.camera3.k2);
        }
        return true;
    }

    boolean refineWithBundleAdjustment() {
        this.estimateUtils.configureSbaStructure(this.pairwiseUtils.inliersThreeView.toList());
        ((SceneStructureCommon.Camera)this.estimateUtils.metricSba.structure.cameras.get((int)2)).known = false;
        ((SceneStructureMetric.Motion)this.estimateUtils.metricSba.structure.motions.get((int)2)).known = false;
        return this.estimateUtils.performBundleAdjustment(this.verbose);
    }

    boolean removedBadFeatures() {
        EstimateViewUtils.RemoveResults results = this.estimateUtils.removedBadFeatures(this.pairwiseUtils, this.fractionBadFeaturesRecover, this.verbose);
        if (results == EstimateViewUtils.RemoveResults.FAILED) {
            return false;
        }
        if (results == EstimateViewUtils.RemoveResults.GOOD) {
            return true;
        }
        if (this.verbose != null) {
            this.verbose.println("Removed bad features. Optimizing again.");
        }
        if (!this.refineWithBundleAdjustment()) {
            return false;
        }
        return this.estimateUtils.verifyPhysicalConstraints(0.0, this.verbose);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.estimateUtils.checks});
    }
}

