/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.meshing;

import boofcv.alg.geo.rectify.DisparityParameters;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.mesh.VertexMesh;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.struct.DogArray;

public class DepthImageToMeshGridSample {
    public ConfigLength samplePeriod = ConfigLength.fixed((double)4.0);
    VertexMesh mesh = new VertexMesh();
    DogArray<Point2D_F64> vertexPixels = new DogArray(Point2D_F64::new, GeoTuple2D_F64::zero);
    GrayS32 indexImage = new GrayS32(1, 1);
    Point3D_F64 p0 = new Point3D_F64();
    Point3D_F64 p1 = new Point3D_F64();
    Point3D_F64 p2 = new Point3D_F64();
    Point3D_F64 p3 = new Point3D_F64();
    Point2D_F64 norm = new Point2D_F64();

    public void processDisparity(DisparityParameters parameters, GrayF32 disparity, float maxDisparityJump) {
        this.mesh.reset();
        this.vertexPixels.reset();
        this.indexImage.reshape((ImageBase)disparity);
        ImageMiscOps.fill((GrayS32)this.indexImage, (int)-1);
        int skip = this.samplePeriod.computeI((double)((disparity.width + disparity.height) / 2));
        for (int y = 0; y < disparity.height - skip; y += skip) {
            int y1 = y + skip;
            for (int x = 0; x < disparity.width - skip; x += skip) {
                int x1 = x + skip;
                float d0 = disparity.get(x, y);
                float d1 = disparity.get(x1, y);
                float d2 = disparity.get(x1, y1);
                float d3 = disparity.get(x, y1);
                if (Math.abs(d0 - d2) > maxDisparityJump || Math.abs(d0 - d1) > maxDisparityJump || Math.abs(d0 - d3) > maxDisparityJump || !this.checkAddIndexForIDisparity(x, y, d0, parameters) || !this.checkAddIndexForIDisparity(x, y1, d1, parameters) || !this.checkAddIndexForIDisparity(x1, y1, d2, parameters) || !this.checkAddIndexForIDisparity(x1, y, d3, parameters)) continue;
                this.mesh.offsets.add(this.mesh.indexes.size);
            }
        }
    }

    private boolean checkAddIndexForIDisparity(int x, int y, float disparity, DisparityParameters parameters) {
        int index = this.indexImage.get(x, y);
        if (index == -1) {
            index = this.mesh.vertexes.size();
            this.indexImage.set(x, y, index);
            if (!parameters.pixelToLeft3D((double)x, (double)y, (double)disparity, this.p0)) {
                return false;
            }
            this.mesh.vertexes.append(this.p0);
            ((Point2D_F64)this.vertexPixels.grow()).setTo((double)x, (double)y);
        }
        this.mesh.indexes.add(index);
        return true;
    }

    public void processInvDepth(GrayF32 inverseDepth, PixelTransform<Point2D_F64> pixelToNorm, float maxInverseJump) {
        this.mesh.reset();
        this.vertexPixels.reset();
        this.indexImage.reshape((ImageBase)inverseDepth);
        ImageMiscOps.fill((GrayS32)this.indexImage, (int)-1);
        int skip = this.samplePeriod.computeI((double)((inverseDepth.width + inverseDepth.height) / 2));
        for (int y = 0; y < inverseDepth.height - skip; y += skip) {
            int y1 = y + skip;
            for (int x = 0; x < inverseDepth.width - skip; x += skip) {
                int x1 = x + skip;
                float d0 = inverseDepth.get(x, y);
                float d1 = inverseDepth.get(x1, y);
                float d2 = inverseDepth.get(x1, y1);
                float d3 = inverseDepth.get(x, y1);
                if (d0 <= 0.0f || d1 <= 0.0f || d2 <= 0.0f || d3 <= 0.0f || Math.abs(d0 - d2) > maxInverseJump || Math.abs(d0 - d1) > maxInverseJump || Math.abs(d0 - d3) > maxInverseJump) continue;
                this.checkAddIndexForInverseDepth(x, y, d0, pixelToNorm);
                this.checkAddIndexForInverseDepth(x, y1, d1, pixelToNorm);
                this.checkAddIndexForInverseDepth(x1, y1, d2, pixelToNorm);
                this.checkAddIndexForInverseDepth(x1, y, d3, pixelToNorm);
                this.mesh.offsets.add(this.mesh.indexes.size);
            }
        }
    }

    private void checkAddIndexForInverseDepth(int x, int y, float invDepth, PixelTransform<Point2D_F64> pixelToNorm) {
        int index = this.indexImage.get(x, y);
        if (index == -1) {
            index = this.mesh.vertexes.size();
            this.indexImage.set(x, y, index);
            pixelToNorm.compute(x, y, (Object)this.norm);
            this.p0.setTo(this.norm.x / (double)invDepth, this.norm.y / (double)invDepth, 1.0 / (double)invDepth);
            this.mesh.vertexes.append(this.p0);
            ((Point2D_F64)this.vertexPixels.grow()).setTo((double)x, (double)y);
        }
        this.mesh.indexes.add(index);
    }

    public VertexMesh getMesh() {
        return this.mesh;
    }

    public DogArray<Point2D_F64> getVertexPixels() {
        return this.vertexPixels;
    }
}

