/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.expand;

import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.alg.structure.expand.EstimateViewKnownCalibration;
import boofcv.alg.structure.expand.EstimateViewSelfCalibrate;
import boofcv.alg.structure.expand.ExpandByOneView;
import boofcv.misc.BoofMiscOps;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class MetricExpandByOneView
extends ExpandByOneView {
    public boolean onlyConsiderCalibrated = false;
    public EstimateViewKnownCalibration expandCalibrated = new EstimateViewKnownCalibration();
    public EstimateViewSelfCalibrate expandUnknown = new EstimateViewSelfCalibrate();
    Solution solutionCalibrated = new Solution();
    Solution solutionUnknown = new Solution();
    public double overfitHandyCap = 0.5;
    List<PairwiseImageGraph.Motion> connections = new ArrayList<PairwiseImageGraph.Motion>();

    public boolean process(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCam, SceneWorkingGraph workGraph, PairwiseImageGraph.View target) {
        BoofMiscOps.checkTrue((!workGraph.isKnown(target) ? 1 : 0) != 0, (String)"Target shouldn't already be in the workGraph");
        this.workGraph = workGraph;
        this.utils.dbSimilar = dbSimilar;
        this.utils.dbCams = dbCam;
        if (!this.selectTwoConnections(target, this.connections)) {
            if (this.verbose != null) {
                this.verbose.println("Failed to expand because two connections couldn't be found. valid.size=" + this.validCandidates.size());
                for (int i = 0; i < this.validCandidates.size(); ++i) {
                    this.verbose.println("valid view.id='" + ((PairwiseImageGraph.Motion)this.validCandidates.get((int)i)).other((PairwiseImageGraph.View)target).id + "'");
                }
            }
            return false;
        }
        this.utils.seed = this.connections.get(0).other(target);
        this.utils.viewB = this.connections.get(1).other(target);
        this.utils.viewC = target;
        this.utils.createThreeViewLookUpTables();
        this.utils.findFullyConnectedTriple();
        if (this.verbose != null) {
            this.verbose.println("Expanding to view='" + target.id + "' using views ( '" + this.utils.seed.id + "' , '" + this.utils.viewB.id + "') common=" + this.utils.commonIdx.size + " valid.size=" + this.validCandidates.size());
        }
        this.utils.createTripleFromCommon(this.verbose);
        if (!this.utils.estimateProjectiveCamerasRobustly()) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Trifocal RANSAC inliers.size=" + this.utils.inliersThreeView.size());
        }
        int tripleInliers = this.utils.inliersThreeView.size;
        int cameraIndexDB = dbCam.viewToCamera(target.id);
        boolean cameraIsKnown = workGraph.cameras.containsKey(cameraIndexDB);
        boolean success = false;
        if (cameraIsKnown && this.onlyConsiderCalibrated) {
            this.solutionUnknown.reset();
            if (this.verbose != null) {
                this.verbose.println("Skipping uncalibrated case");
            }
        } else if (this.expandUnknown.process(this.utils, workGraph, this.solutionUnknown)) {
            BoofMiscOps.checkEq((int)tripleInliers, (int)this.utils.inliersThreeView.size, (String)"BUG! Don't modify inliers.");
            success = true;
        } else if (this.verbose != null) {
            this.verbose.println("FAILED to estimate view using an unknown camera");
        }
        if (workGraph.cameras.containsKey(cameraIndexDB)) {
            if (this.expandCalibrated.process(this.utils, workGraph, this.solutionCalibrated)) {
                BoofMiscOps.checkEq((int)tripleInliers, (int)this.utils.inliersThreeView.size, (String)"BUG! Don't modify inliers.");
                success = true;
            } else if (this.verbose != null) {
                this.verbose.println("FAILED to estimate view using a known calibrated camera");
            }
        } else {
            this.solutionCalibrated.reset();
        }
        if (!success) {
            if (this.verbose != null) {
                this.verbose.println("FAILED no valid solution to expand with");
            }
            return false;
        }
        if (this.verbose != null) {
            this.printSolutionSummary();
        }
        Solution solutionBest = this.selectBestSolution();
        this.addNewViewToWorkGraph(dbCam, workGraph, target, cameraIndexDB, solutionBest);
        return true;
    }

    private void printSolutionSummary() {
        PrintStream verbose = Objects.requireNonNull(this.verbose);
        Se3_F64 calibrated = this.solutionCalibrated.world_to_target;
        Se3_F64 unknown = this.solutionUnknown.world_to_target;
        verbose.printf("calibrated.size=%d unknown.size=%d : triples.size=%d\n", this.solutionCalibrated.commonFeatureIndexes.size, this.solutionUnknown.commonFeatureIndexes.size, this.utils.inliersThreeView.size);
        verbose.printf("calibrated: T=(%.2f %.2f %.2f) f=%.1f\n", calibrated.T.x, calibrated.T.y, calibrated.T.z, this.solutionCalibrated.intrinsic.f);
        verbose.printf("unknown:    T=(%.2f %.2f %.2f) f=%.1f\n", unknown.T.x, unknown.T.y, unknown.T.z, this.solutionUnknown.intrinsic.f);
    }

    private void addNewViewToWorkGraph(LookUpCameraInfo dbCam, SceneWorkingGraph workGraph, PairwiseImageGraph.View target, int cameraIndexDB, Solution solution) {
        SceneWorkingGraph.Camera camera = (SceneWorkingGraph.Camera)workGraph.cameras.get(cameraIndexDB);
        if (camera == null) {
            camera = workGraph.addCamera(cameraIndexDB);
            camera.intrinsic.setTo(solution.intrinsic);
            dbCam.lookupCalibration(cameraIndexDB, camera.prior);
        }
        SceneWorkingGraph.View wtarget = workGraph.addView(target, camera);
        wtarget.world_to_view.setTo(solution.world_to_target);
        this.utils.saveRansacInliers(wtarget, solution.commonFeatureIndexes);
    }

    private Solution selectBestSolution() {
        Solution solutionBest;
        if ((double)this.solutionCalibrated.commonFeatureIndexes.size >= (double)this.solutionUnknown.commonFeatureIndexes.size * this.overfitHandyCap) {
            solutionBest = this.solutionCalibrated;
            if (this.verbose != null) {
                this.verbose.println("Selected calibrated");
            }
        } else {
            solutionBest = this.solutionUnknown;
            if (this.verbose != null) {
                this.verbose.println("Selected unknown");
            }
        }
        return solutionBest;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        super.setVerbose(out, configuration);
        BoofMiscOps.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.expandCalibrated, this.expandUnknown});
    }

    public static class Solution {
        public Se3_F64 world_to_target = new Se3_F64();
        public BundlePinholeSimplified intrinsic = new BundlePinholeSimplified();
        public DogArray_I32 commonFeatureIndexes = new DogArray_I32();

        public void reset() {
            this.world_to_target.reset();
            this.intrinsic.reset();
            this.commonFeatureIndexes.reset();
        }
    }
}

