/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.mvs.ColorizeMultiViewStereoResults;
import boofcv.alg.mvs.MultiViewStereoFromKnownSceneStructure;
import boofcv.alg.structure.GenerateStereoPairGraphFromScene;
import boofcv.core.image.LookUpColorRgb;
import boofcv.core.image.LookUpColorRgbFormats;
import boofcv.misc.LookUpImages;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point3D_F64;
import gnu.trove.map.TIntObjectMap;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class SparseSceneToDenseCloud<T extends ImageGray<T>> {
    private final MultiViewStereoFromKnownSceneStructure<T> mvs;
    private final GenerateStereoPairGraphFromScene generateGraph = new GenerateStereoPairGraphFromScene();
    private final DogArray_I32 colorRgb = new DogArray_I32();
    double timeCreateGraphMS;
    double timeMultiViewStereoMS;
    double timeColorizeMS;
    Class<T> grayType;

    public SparseSceneToDenseCloud(Class<T> imageType) {
        this.mvs = new MultiViewStereoFromKnownSceneStructure(ImageType.single(imageType));
    }

    public boolean process(SceneStructureMetric scene, @Nullable SceneObservations observations, TIntObjectMap<String> viewIdx_to_ImageID, LookUpImages lookUpImages) {
        this.timeCreateGraphMS = 0.0;
        this.timeMultiViewStereoMS = 0.0;
        this.timeColorizeMS = 0.0;
        long time0 = System.nanoTime();
        this.generateGraph.process(viewIdx_to_ImageID, scene);
        long time1 = System.nanoTime();
        this.timeCreateGraphMS = (double)(time1 - time0) * 1.0E-6;
        this.mvs.setImageLookUp(lookUpImages);
        this.mvs.process(scene, observations, this.generateGraph.getStereoGraph());
        long time2 = System.nanoTime();
        this.timeMultiViewStereoMS = (double)(time2 - time1) * 1.0E-6;
        this.colorRgb.resize(this.mvs.getCloud().size());
        ColorizeMultiViewStereoResults colorizeMvs = new ColorizeMultiViewStereoResults((LookUpColorRgb)new LookUpColorRgbFormats.PL_U8(), lookUpImages);
        colorizeMvs.processMvsCloud(scene, observations, this.mvs, (idx, r, g, b) -> this.colorRgb.set(idx, r << 16 | g << 8 | b));
        long time3 = System.nanoTime();
        this.timeColorizeMS = (double)(time3 - time2) * 1.0E-6;
        return true;
    }

    public List<Point3D_F64> getCloud() {
        return this.mvs.getCloud();
    }

    public MultiViewStereoFromKnownSceneStructure<T> getMultiViewStereo() {
        return this.mvs;
    }

    public GenerateStereoPairGraphFromScene getGenerateGraph() {
        return this.generateGraph;
    }

    public DogArray_I32 getColorRgb() {
        return this.colorRgb;
    }

    public double getTimeCreateGraphMS() {
        return this.timeCreateGraphMS;
    }

    public double getTimeMultiViewStereoMS() {
        return this.timeMultiViewStereoMS;
    }

    public double getTimeColorizeMS() {
        return this.timeColorizeMS;
    }

    public Class<T> getGrayType() {
        return this.grayType;
    }
}

