/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.alg.structure.ConfigProjectiveReconstruction;
import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.MetricMergeScenes;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.ReconstructionFromPairwiseGraph;
import boofcv.alg.structure.RefineMetricWorkingGraph;
import boofcv.alg.structure.SceneMergingOperations;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.alg.structure.expand.MetricExpandByOneView;
import boofcv.alg.structure.spawn.MetricSpawnSceneFromView;
import boofcv.misc.BoofMiscOps;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class MetricFromUncalibratedPairwiseGraph
extends ReconstructionFromPairwiseGraph {
    public int refineSceneWhileExpandingMaxViews = 6;
    private final MetricExpandByOneView expandMetric = new MetricExpandByOneView();
    private final RefineMetricWorkingGraph refineWorking = new RefineMetricWorkingGraph();
    private final RefineMetricWorkingGraph refineBeforeMerge = new RefineMetricWorkingGraph();
    private final MetricSpawnSceneFromView spawnScene;
    private final MetricMergeScenes mergeScenes = new MetricMergeScenes();
    final DogArray<SceneWorkingGraph> scenes = new DogArray(SceneWorkingGraph::new, SceneWorkingGraph::reset);
    SceneMergingOperations mergeOps = new SceneMergingOperations();
    PairwiseViewScenes scenesInEachView = new PairwiseViewScenes();

    public MetricFromUncalibratedPairwiseGraph(PairwiseGraphUtils utils) {
        super(utils);
        this.refineWorking.metricSba.keepFraction = 0.95;
        this.expandMetric.utils = utils;
        this.spawnScene = new MetricSpawnSceneFromView(this.refineWorking, utils);
    }

    public MetricFromUncalibratedPairwiseGraph(ConfigProjectiveReconstruction config) {
        this(new PairwiseGraphUtils(config));
    }

    public MetricFromUncalibratedPairwiseGraph() {
        this(new ConfigProjectiveReconstruction());
    }

    public boolean process(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams, PairwiseImageGraph pairwise) {
        this.scenes.reset();
        this.scenesInEachView.initialize(pairwise);
        Map<String, ReconstructionFromPairwiseGraph.SeedInfo> mapScores = this.scoreNodesAsSeeds(pairwise, 2);
        if (this.seedScores.isEmpty() && this.verbose != null) {
            this.verbose.println("No seeds found. pairwise.size=" + pairwise.nodes.size);
        }
        this.selectAndSpawnSeeds(dbSimilar, dbCams, pairwise, (DogArray<ReconstructionFromPairwiseGraph.SeedInfo>)this.seedScores, mapScores);
        if (this.scenes.isEmpty()) {
            if (this.verbose != null) {
                this.verbose.println("Failed to upgrade any of the seeds to a metric scene.");
            }
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Total Scenes: " + this.scenes.size);
        }
        this.expandScenes(dbSimilar, dbCams);
        this.refineScenes(dbSimilar);
        this.mergeScenes(dbSimilar);
        this.removeMergedScenes();
        if (this.verbose != null) {
            this.verbose.println("Done.");
        }
        return true;
    }

    @Override
    protected boolean spawnSceneFromSeed(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams, PairwiseImageGraph pairwise, ReconstructionFromPairwiseGraph.SeedInfo info) {
        if (!this.spawnScene.process(dbSimilar, dbCams, pairwise, info.seed, info.motions)) {
            return false;
        }
        SceneWorkingGraph scene = (SceneWorkingGraph)this.scenes.grow();
        scene.setTo(this.spawnScene.getScene());
        scene.index = this.scenes.size - 1;
        double scoreGeometric = this.computeGeometricScore(scene, (SceneWorkingGraph.InlierInfo)scene.listViews.get((int)0).inliers.get(0));
        for (int viewIdx = 0; viewIdx < scene.listViews.size(); ++viewIdx) {
            ((SceneWorkingGraph.InlierInfo)scene.listViews.get((int)viewIdx).inliers.get((int)0)).scoreGeometric = scoreGeometric;
            this.scenesInEachView.getView((PairwiseImageGraph.View)scene.listViews.get((int)viewIdx).pview).viewedBy.add(scene.index);
        }
        return true;
    }

    void expandScenes(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCam) {
        if (this.verbose != null) {
            this.verbose.println("Expand Scenes: Finding open views in each scene");
        }
        for (int sceneIdx = 0; sceneIdx < this.scenes.size; ++sceneIdx) {
            SceneWorkingGraph scene = (SceneWorkingGraph)this.scenes.get(sceneIdx);
            scene.listViews.forEach(wv -> scene.exploredViews.add(wv.pview.id));
            this.findAllOpenViews(scene);
            if (this.verbose == null) continue;
            this.verbose.println("scene[" + sceneIdx + "].open.size=" + scene.open.size);
        }
        ReconstructionFromPairwiseGraph.Expansion best = new ReconstructionFromPairwiseGraph.Expansion();
        ReconstructionFromPairwiseGraph.Expansion candidate = new ReconstructionFromPairwiseGraph.Expansion();
        while (true) {
            if (this.verbose != null) {
                this.verbose.println("Selecting next scene/view to expand.");
            }
            best.reset();
            for (int sceneIdx = 0; sceneIdx < this.scenes.size; ++sceneIdx) {
                SceneWorkingGraph scene = (SceneWorkingGraph)this.scenes.get(sceneIdx);
                if (scene.open.isEmpty()) continue;
                if (!this.selectNextToProcess(scene, candidate)) {
                    if (this.verbose == null) continue;
                    this.verbose.println("_ No valid views left. open.size=" + scene.open.size);
                    continue;
                }
                if (!(candidate.score > best.score)) continue;
                ReconstructionFromPairwiseGraph.Expansion tmp = best;
                best = candidate;
                candidate = tmp;
            }
            if (best.score <= 0.0) break;
            PairwiseImageGraph.View view = (PairwiseImageGraph.View)best.scene.open.removeSwap(best.openIdx);
            if (this.verbose != null) {
                this.verbose.printf("Expanding scene[%d].view='%s' score=%.2f\n", best.scene.index, view.id, best.score);
            }
            best.scene.listViews.forEach(v -> BoofMiscOps.checkTrue((!v.inliers.isEmpty() ? 1 : 0) != 0));
            if (!this.expandIntoView(dbSimilar, dbCam, best.scene, view)) {
                best.scene.listViews.forEach(v -> BoofMiscOps.checkTrue((!v.inliers.isEmpty() ? 1 : 0) != 0));
                continue;
            }
            best.scene.listViews.forEach(v -> BoofMiscOps.checkTrue((!v.inliers.isEmpty() ? 1 : 0) != 0));
            if (best.scene.listViews.size() > this.refineSceneWhileExpandingMaxViews) continue;
            this.refineWorking.process(dbSimilar, best.scene);
        }
    }

    boolean canSpawnFromView(SceneWorkingGraph scene, PairwiseImageGraph.View pview) {
        if (this.scenesInEachView.getView((PairwiseImageGraph.View)pview).viewedBy.size == 0) {
            return true;
        }
        ViewScenes views = this.scenesInEachView.getView(pview);
        boolean usable = true;
        for (int idxA = 0; idxA < views.viewedBy.size; ++idxA) {
            SceneWorkingGraph viewsByScene = (SceneWorkingGraph)this.scenes.get(views.viewedBy.get(idxA));
            BoofMiscOps.checkTrue((viewsByScene != scene ? 1 : 0) != 0, (String)"Scene should not already have this view");
            if (viewsByScene.isSeedSet(pview.id)) continue;
            usable = false;
            break;
        }
        return usable;
    }

    void refineScenes(LookUpSimilarImages dbSimilar) {
        if (this.verbose != null) {
            this.verbose.println("Refining all scenes before merging");
        }
        for (int sceneIdx = 0; sceneIdx < this.scenes.size; ++sceneIdx) {
            this.refineBeforeMerge.process(dbSimilar, (SceneWorkingGraph)this.scenes.get(sceneIdx));
        }
    }

    void mergeScenes(LookUpSimilarImages dbSimilar) {
        if (this.verbose != null) {
            this.verbose.println("Merging Scenes. scenes.size=" + this.scenes.size);
        }
        SceneMergingOperations.SelectedScenes selected = new SceneMergingOperations.SelectedScenes();
        this.mergeOps.initializeViewCounts(this.scenesInEachView, this.scenes.size);
        while (this.mergeOps.selectScenesToMerge(selected)) {
            SceneWorkingGraph dst;
            SceneWorkingGraph src = (SceneWorkingGraph)this.scenes.get(selected.sceneA);
            if (!this.mergeOps.decideFirstIntoSecond(src, dst = (SceneWorkingGraph)this.scenes.get(selected.sceneB))) {
                SceneWorkingGraph tmp = dst;
                dst = src;
                src = tmp;
            }
            if (this.isSubset(src, dst)) {
                if (this.verbose != null) {
                    this.verbose.println("Merge results: src=" + src.index + " dst=" + dst.index + " sizes=(" + src.listViews.size() + " " + dst.listViews.size() + "), Removing: src is a subset.");
                }
                this.mergeOps.toggleViewEnabled(src, this.scenesInEachView);
                BoofMiscOps.checkTrue((!this.mergeOps.enabledScenes.get(src.index) ? 1 : 0) != 0, (String)"Should be disabled now");
                BoofMiscOps.checkTrue((boolean)this.mergeOps.enabledScenes.get(dst.index), (String)"Should be enabled now");
                continue;
            }
            if (this.verbose != null) {
                this.verbose.println("Attempt merge: src=" + src.index + " dst=" + dst.index + " sizes=(" + src.listViews.size() + " " + dst.listViews.size() + ")");
            }
            int sizeBefore = dst.listViews.size();
            if (!this.mergeScenes.merge(dbSimilar, src, dst)) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED: Merged blocked until scenes modified. src=" + src.index + " dst=" + dst.index);
                }
                this.mergeOps.markAsFailed(src, dst);
                continue;
            }
            if (this.verbose != null) {
                this.verbose.println("Success merging. dst.size=" + dst.listViews.size());
            }
            this.mergeOps.toggleViewEnabled(src, this.scenesInEachView);
            this.mergeOps.toggleViewEnabled(dst, this.scenesInEachView);
            for (int i = sizeBefore; i < dst.listViews.size(); ++i) {
                SceneWorkingGraph.View wview = dst.listViews.get(i);
                this.scenesInEachView.getView((PairwiseImageGraph.View)wview.pview).viewedBy.add(dst.index);
                this.scenesInEachView.getView((PairwiseImageGraph.View)wview.pview).viewedBy.sort();
            }
            this.mergeOps.toggleViewEnabled(dst, this.scenesInEachView);
            BoofMiscOps.checkTrue((!this.mergeOps.enabledScenes.get(src.index) ? 1 : 0) != 0, (String)"Should be disabled now");
            BoofMiscOps.checkTrue((boolean)this.mergeOps.enabledScenes.get(dst.index), (String)"Should be enabled now");
        }
    }

    private boolean isSubset(SceneWorkingGraph src, SceneWorkingGraph dst) {
        boolean subset = true;
        for (int i = 0; i < src.listViews.size(); ++i) {
            if (dst.views.containsKey(src.listViews.get((int)i).pview.id)) continue;
            subset = false;
            break;
        }
        return subset;
    }

    private void removeMergedScenes() {
        int i;
        for (i = this.scenes.size - 1; i >= 0; --i) {
            if (this.mergeOps.enabledScenes.get(((SceneWorkingGraph)this.scenes.get((int)i)).index)) continue;
            this.scenes.removeSwap(i);
        }
        if (this.verbose != null) {
            this.verbose.println("scenes.size=" + this.scenes.size);
            for (i = 0; i < this.scenes.size; ++i) {
                this.verbose.println("_ scene[" + i + "].size = " + ((SceneWorkingGraph)this.scenes.get((int)i)).listViews.size());
            }
        }
    }

    boolean expandIntoView(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCam, SceneWorkingGraph scene, PairwiseImageGraph.View selected) {
        if (!this.expandMetric.process(dbSimilar, dbCam, scene, selected)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Expand/add scene=" + scene.index + " view='" + selected.id + "'. Discarding.");
            }
            return false;
        }
        SceneWorkingGraph.View wview = scene.lookupView(selected.id);
        SceneWorkingGraph.InlierInfo inlier = (SceneWorkingGraph.InlierInfo)wview.inliers.getTail();
        inlier.scoreGeometric = this.computeGeometricScore(scene, inlier);
        int openSizePrior = scene.open.size;
        if (this.canSpawnFromView(scene, wview.pview)) {
            this.addOpenForView(scene, wview.pview);
        }
        if (this.verbose != null) {
            this.verbose.println("_ Expanded scene=" + scene.index + " view='" + selected.id + "'  inliers=" + this.utils.inliersThreeView.size() + "/" + this.utils.matchesTriple.size + " Open added.size=" + (scene.open.size - openSizePrior));
        }
        this.scenesInEachView.getView((PairwiseImageGraph.View)selected).viewedBy.add(scene.index);
        return true;
    }

    protected void sanityCheckScenesInEachView() {
        ArrayList expected = new ArrayList();
        for (int viewIdx = 0; viewIdx < this.scenesInEachView.views.size; ++viewIdx) {
            int _viewIdx = viewIdx;
            expected.clear();
            this.scenes.forEach(scene -> {
                for (int i = 0; i < scene.listViews.size(); ++i) {
                    if (scene.listViews.get((int)i).pview.index != _viewIdx) continue;
                    expected.add(scene);
                    break;
                }
            });
            ViewScenes found = (ViewScenes)this.scenesInEachView.views.get(viewIdx);
            BoofMiscOps.checkEq((int)expected.size(), (int)found.viewedBy.size, (String)("Number of scenes do not match. view=" + viewIdx));
            for (int i = 0; i < expected.size(); ++i) {
                if (found.viewedBy.contains(((SceneWorkingGraph)expected.get((int)i)).index)) continue;
                throw new RuntimeException("Scene is missing from nodeViews. scene.index=" + ((SceneWorkingGraph)expected.get((int)i)).index);
            }
        }
    }

    public double computeGeometricScore(SceneWorkingGraph scene, SceneWorkingGraph.InlierInfo inlier) {
        return inlier.getInlierCount();
    }

    public SceneWorkingGraph getLargestScene() {
        if (this.scenes.isEmpty()) {
            throw new IllegalArgumentException("There are no valid scenes");
        }
        SceneWorkingGraph best = (SceneWorkingGraph)this.scenes.get(0);
        for (int i = 1; i < this.scenes.size; ++i) {
            SceneWorkingGraph scene = (SceneWorkingGraph)this.scenes.get(i);
            if (scene.listViews.size() <= best.listViews.size()) continue;
            best = scene;
        }
        return best;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        VerboseUtils.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.spawnScene, this.expandMetric, this.refineWorking, this.mergeOps, this.mergeScenes});
    }

    public int getRefineSceneWhileExpandingMaxViews() {
        return this.refineSceneWhileExpandingMaxViews;
    }

    public void setRefineSceneWhileExpandingMaxViews(int refineSceneWhileExpandingMaxViews) {
        this.refineSceneWhileExpandingMaxViews = refineSceneWhileExpandingMaxViews;
    }

    public MetricExpandByOneView getExpandMetric() {
        return this.expandMetric;
    }

    public RefineMetricWorkingGraph getRefineWorking() {
        return this.refineWorking;
    }

    public RefineMetricWorkingGraph getRefineBeforeMerge() {
        return this.refineBeforeMerge;
    }

    public MetricSpawnSceneFromView getSpawnScene() {
        return this.spawnScene;
    }

    public MetricMergeScenes getMergeScenes() {
        return this.mergeScenes;
    }

    public DogArray<SceneWorkingGraph> getScenes() {
        return this.scenes;
    }

    public static class PairwiseViewScenes {
        public final DogArray<ViewScenes> views = new DogArray(ViewScenes::new, ViewScenes::reset);

        public void initialize(PairwiseImageGraph pairwise) {
            this.views.reset();
            this.views.resize(pairwise.nodes.size, (idx, o) -> {
                o.id = ((PairwiseImageGraph.View)pairwise.nodes.get((int)idx)).id;
            });
        }

        public ViewScenes getView(PairwiseImageGraph.View view) {
            return (ViewScenes)this.views.get(view.index);
        }
    }

    public static class ViewScenes {
        public String id;
        public DogArray_I32 viewedBy = new DogArray_I32();

        public void reset() {
            this.id = null;
            this.viewedBy.reset();
        }
    }
}

