/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.MetricSanityChecks;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.RefineMetricWorkingGraph;
import boofcv.alg.structure.ScaleSe3_F64;
import boofcv.alg.structure.SceneMergingOperations;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class MetricMergeScenes
implements VerbosePrint {
    public final MetricSanityChecks checks = new MetricSanityChecks();
    public final SceneMergingOperations mergingOps = new SceneMergingOperations();
    public double fractionBadFeaturesRecover = 0.05;
    RefineMetricWorkingGraph refiner = new RefineMetricWorkingGraph();
    DogArray<CommonView> commonViews = new DogArray(CommonView::new);
    ScaleSe3_F64 src_to_dst = new ScaleSe3_F64();
    SceneWorkingGraph workScene = new SceneWorkingGraph();
    DogArray_B knownViews = new DogArray_B();
    DogArray_B knownCameras = new DogArray_B();
    Se3_F64 src_to_view = new Se3_F64();
    Se3_F64 transform_dst_to_src = new Se3_F64();
    @Nullable
    PrintStream verbose;

    public MetricMergeScenes() {
        this.refiner.verboseViewInfo = false;
    }

    public boolean merge(LookUpSimilarImages dbSimilar, SceneWorkingGraph src, SceneWorkingGraph dst) {
        MetricMergeScenes.findCommonViews(src, dst, this.commonViews, this.verbose);
        if (this.commonViews.isEmpty()) {
            return false;
        }
        Collections.sort(this.commonViews.toList(), (a, b) -> Double.compare(a.score, b.score));
        CommonView best = (CommonView)this.commonViews.getTail();
        if (!this.mergingOps.computeSceneTransform(dbSimilar, src, dst, best.src, best.dst, this.src_to_dst)) {
            return false;
        }
        this.src_to_dst.transform.invert(this.transform_dst_to_src);
        this.createWorkScene(src, dst);
        if (!this.refiner.process(dbSimilar, this.workScene, utils -> {
            int i;
            for (i = 0; i < this.knownCameras.size; ++i) {
                ((SceneStructureCommon.Camera)utils.structure.cameras.get((int)i)).known = this.knownCameras.get(i);
            }
            for (i = 0; i < this.knownViews.size; ++i) {
                ((SceneStructureMetric.Motion)utils.structure.motions.get((int)i)).known = this.knownViews.get(i);
            }
        })) {
            if (this.verbose != null) {
                this.verbose.println("FAiLED: Refiner return false");
            }
            return false;
        }
        if (!this.verifyAndFixConstraints(dbSimilar)) {
            return false;
        }
        if (this.verbose != null) {
            for (int i = 0; i < this.workScene.listViews.size(); ++i) {
                SceneWorkingGraph.View wview = this.workScene.listViews.get(i);
                if (dst.views.get(wview.pview.id) != null) continue;
                BundlePinholeSimplified intrinsic = this.workScene.getViewCamera((SceneWorkingGraph.View)wview).intrinsic;
                this.verbose.printf("After id='%s' src={ f=%.1f k1=%.1e k2=%.1e }\n", wview.pview.id, intrinsic.f, intrinsic.k1, intrinsic.k2);
            }
        }
        this.mergeWorkIntoDst(dst);
        return true;
    }

    private boolean verifyAndFixConstraints(LookUpSimilarImages db) {
        for (int i = 0; i < this.commonViews.size; ++i) {
            SceneWorkingGraph.View viewSrc = ((CommonView)this.commonViews.get((int)i)).src;
            SceneWorkingGraph.View wview = this.workScene.lookupView(viewSrc.pview.id);
            int numInliersSrc = viewSrc.inliers.size;
            for (int inlierIdx = 0; inlierIdx < numInliersSrc; ++inlierIdx) {
                if (this.verbose != null && this.checks.verbose == null) {
                    this.verbose.printf("Constraints: view.id='%s' inlierIdx=%d\n", wview.pview.id, inlierIdx);
                }
                if (!this.checks.checkPhysicalConstraints(db, this.workScene, wview, inlierIdx)) {
                    if (this.verbose != null) {
                        this.verbose.println("FAILED: constraints had a fatal error.");
                    }
                    return false;
                }
                if (this.removeBadFeatures((SceneWorkingGraph.InlierInfo)wview.inliers.get(inlierIdx))) continue;
                return false;
            }
        }
        return true;
    }

    boolean removeBadFeatures(SceneWorkingGraph.InlierInfo info) {
        int numInliers = info.getInlierCount();
        BoofMiscOps.checkEq((int)numInliers, (int)this.checks.badFeatures.size);
        int countBadFeatures = this.checks.badFeatures.count(true);
        if ((double)countBadFeatures > this.fractionBadFeaturesRecover * (double)this.checks.badFeatures.size) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Inlier set had too many bad features. bad=" + countBadFeatures + "/" + numInliers);
            }
            return false;
        }
        if (countBadFeatures == 0) {
            return true;
        }
        if (this.verbose != null) {
            this.verbose.println("Removing bad features to try to fix. bad=" + countBadFeatures + "/" + numInliers);
        }
        for (int obsIdx = numInliers - 1; obsIdx >= 0; --obsIdx) {
            if (!this.checks.badFeatures.get(obsIdx)) continue;
            for (int viewIdx = 0; viewIdx < info.observations.size; ++viewIdx) {
                ((DogArray_I32)info.observations.get(viewIdx)).removeSwap(obsIdx);
            }
        }
        return true;
    }

    void createWorkScene(SceneWorkingGraph src, SceneWorkingGraph dst) {
        int i;
        BoofMiscOps.checkTrue((!this.commonViews.isEmpty() ? 1 : 0) != 0);
        this.workScene.setTo(src);
        this.knownViews.reset().resize(this.workScene.listViews.size(), false);
        this.knownCameras.reset().resize(this.workScene.listCameras.size(), false);
        this.copyDstCamerasIntoWork(dst);
        for (i = 0; i < this.workScene.listViews.size(); ++i) {
            this.convertNewViewCoordinateSystem(this.workScene.listViews.get(i));
        }
        for (i = 0; i < this.commonViews.size; ++i) {
            SceneWorkingGraph.View viewDst = ((CommonView)this.commonViews.get((int)i)).dst;
            SceneWorkingGraph.View wview = this.workScene.lookupView(viewDst.pview.id);
            wview.world_to_view.setTo(viewDst.world_to_view);
            DogArray<SceneWorkingGraph.InlierInfo> inliersDst = ((CommonView)this.commonViews.get((int)i)).dst.inliers;
            for (int infoIdx = 0; infoIdx < inliersDst.size; ++infoIdx) {
                SceneWorkingGraph.InlierInfo orig = (SceneWorkingGraph.InlierInfo)inliersDst.get(infoIdx);
                SceneWorkingGraph.InlierInfo copy = (SceneWorkingGraph.InlierInfo)wview.inliers.grow();
                copy.setTo(orig);
                this.addViewsButNoInliers(dst, orig.views, true);
            }
        }
    }

    void copyDstCamerasIntoWork(SceneWorkingGraph dst) {
        for (int srcCameraIdx = 0; srcCameraIdx < this.workScene.listCameras.size; ++srcCameraIdx) {
            SceneWorkingGraph.Camera wrkCamera = (SceneWorkingGraph.Camera)this.workScene.listCameras.get(srcCameraIdx);
            SceneWorkingGraph.Camera dstCamera = (SceneWorkingGraph.Camera)dst.cameras.get(wrkCamera.indexDB);
            if (dstCamera == null) continue;
            wrkCamera.intrinsic.setTo(dstCamera.intrinsic);
            wrkCamera.prior.setTo(dstCamera.prior);
            this.knownCameras.set(srcCameraIdx, true);
        }
    }

    void mergeWorkIntoDst(SceneWorkingGraph dst) {
        for (int viewIdx = 0; viewIdx < this.workScene.listViews.size(); ++viewIdx) {
            SceneWorkingGraph.View viewSrc = this.workScene.listViews.get(viewIdx);
            SceneWorkingGraph.View viewDst = dst.views.get(viewSrc.pview.id);
            SceneWorkingGraph.Camera cameraSrc = this.workScene.getViewCamera(viewSrc);
            SceneWorkingGraph.Camera cameraDst = (SceneWorkingGraph.Camera)dst.cameras.get(cameraSrc.indexDB);
            if (cameraDst == null) {
                cameraDst = dst.addCameraCopy(cameraSrc);
            }
            if (viewDst != null) {
                int end = viewSrc.inliers.size - viewDst.inliers.size;
                for (int inlierIdx = 0; inlierIdx < end; ++inlierIdx) {
                    ((SceneWorkingGraph.InlierInfo)viewDst.inliers.grow()).setTo((SceneWorkingGraph.InlierInfo)viewSrc.inliers.get(inlierIdx));
                }
            } else {
                viewDst = dst.addView(viewSrc.pview, cameraDst);
                viewDst.setTo(viewSrc);
                viewDst.index = dst.listViews.size() - 1;
            }
            BoofMiscOps.checkTrue((!viewDst.inliers.isEmpty() ? 1 : 0) != 0);
        }
    }

    void convertNewViewCoordinateSystem(SceneWorkingGraph.View wview) {
        this.src_to_view.setTo(wview.world_to_view);
        this.src_to_view.T.scale(this.src_to_dst.scale);
        this.transform_dst_to_src.concat(this.src_to_view, wview.world_to_view);
    }

    private void addViewsButNoInliers(SceneWorkingGraph origScene, FastArray<PairwiseImageGraph.View> viewsToCopy, boolean markAsKnown) {
        for (int viewIdx = 0; viewIdx < viewsToCopy.size; ++viewIdx) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)viewsToCopy.get(viewIdx);
            if (this.workScene.views.containsKey(pview.id)) continue;
            this.copyIntoSceneJustState(origScene, markAsKnown, pview);
            if (this.verbose == null) continue;
            this.verbose.println("Adding view-no-inliers id='" + pview.id + "' known=" + markAsKnown);
        }
    }

    private void copyIntoSceneJustState(SceneWorkingGraph origScene, boolean markAsKnown, PairwiseImageGraph.View pview) {
        SceneWorkingGraph.View origView = Objects.requireNonNull(origScene.views.get(pview.id));
        SceneWorkingGraph.Camera origCamera = origScene.getViewCamera(origView);
        SceneWorkingGraph.Camera copyCamera = (SceneWorkingGraph.Camera)this.workScene.cameras.get(origCamera.indexDB);
        if (copyCamera == null) {
            copyCamera = this.workScene.addCameraCopy(origCamera);
            this.knownCameras.add(markAsKnown);
        }
        SceneWorkingGraph.View copyView = this.workScene.addView(pview, copyCamera);
        copyView.world_to_view.setTo(origView.world_to_view);
        this.knownViews.add(markAsKnown);
    }

    static void findCommonViews(SceneWorkingGraph src, SceneWorkingGraph dst, DogArray<CommonView> commonViews, @Nullable PrintStream verbose) {
        commonViews.reset();
        for (int srcViewIdx = 0; srcViewIdx < src.listViews.size(); ++srcViewIdx) {
            SceneWorkingGraph.View srcView = src.listViews.get(srcViewIdx);
            SceneWorkingGraph.View dstView = dst.views.get(srcView.pview.id);
            if (dstView == null) {
                if (verbose == null) continue;
                BundlePinholeSimplified intrinsic = src.getViewCamera((SceneWorkingGraph.View)srcView).intrinsic;
                verbose.printf("id='%s' src={ f=%.1f k1=%.1e k2=%.1e }\n", srcView.pview.id, intrinsic.f, intrinsic.k1, intrinsic.k2);
                continue;
            }
            double score = Math.min(srcView.getBestInlierScore(), dstView.getBestInlierScore());
            ((CommonView)commonViews.grow()).setTo(srcView, dstView, score);
            if (verbose == null) continue;
            BundlePinholeSimplified srcIntrinsic = src.getViewCamera((SceneWorkingGraph.View)srcView).intrinsic;
            BundlePinholeSimplified dstIntrinsic = dst.getViewCamera((SceneWorkingGraph.View)dstView).intrinsic;
            verbose.printf("id='%s' src={ f=%.1f k1=%.1e k2=%.1e } dst={ f=%.1f k1=%.1e k2=%.1e }\n", srcView.pview.id, srcIntrinsic.f, srcIntrinsic.k1, srcIntrinsic.k2, dstIntrinsic.f, dstIntrinsic.k1, dstIntrinsic.k2);
        }
        if (verbose != null) {
            verbose.print("Common: size=" + commonViews.size + "/" + src.listViews.size() + " views={ ");
            for (int i = 0; i < commonViews.size; ++i) {
                verbose.print("'" + ((CommonView)commonViews.get((int)i)).src.pview.id + "' ");
            }
            verbose.println("}");
        }
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        VerboseUtils.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.checks, this.refiner});
    }

    public MetricSanityChecks getChecks() {
        return this.checks;
    }

    public SceneMergingOperations getMergingOps() {
        return this.mergingOps;
    }

    public RefineMetricWorkingGraph getRefiner() {
        return this.refiner;
    }

    public static class CommonView {
        public SceneWorkingGraph.View src;
        public SceneWorkingGraph.View dst;
        public double score;

        public void setTo(SceneWorkingGraph.View src, SceneWorkingGraph.View dst, double score) {
            this.src = src;
            this.dst = dst;
            this.score = score;
        }

        public String toString() {
            return "{id='" + this.src.pview.id + "' src.index=" + this.src.index + " dst.index=" + this.dst.index + "}";
        }
    }
}

