/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.score3d;

import boofcv.alg.structure.EpipolarScore3D;
import boofcv.struct.ConfigLength;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.homography.Homography2D_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.ops.DConvertMatrixStruct;
import org.jetbrains.annotations.Nullable;

public class ScoreRatioFundamentalHomography
implements EpipolarScore3D {
    ModelMatcher<DMatrixRMaj, AssociatedPair> ransac3D;
    ModelMatcher<Homography2D_F64, AssociatedPair> ransacH;
    public final ConfigLength minimumInliers = ConfigLength.fixed((double)30.0);
    public double ratio3D = 1.5;
    public double maxRatioScore = 5.0;
    private boolean is3D;
    int countF;
    int countH;
    @Nullable
    private PrintStream verbose;

    public ScoreRatioFundamentalHomography(ModelMatcher<DMatrixRMaj, AssociatedPair> ransac3D, ModelMatcher<Homography2D_F64, AssociatedPair> ransacH) {
        this.ransac3D = ransac3D;
        this.ransacH = ransacH;
    }

    protected ScoreRatioFundamentalHomography() {
    }

    @Override
    public void process(CameraPinholeBrown cameraA, @Nullable CameraPinholeBrown cameraB, int featuresA, int featuresB, List<AssociatedPair> pairs, DMatrixRMaj fundamental, DogArray_I32 inliersIdx) {
        inliersIdx.reset();
        fundamental.fill(0.0);
        int minimumAllowed = this.minimumInliers.computeI((double)pairs.size());
        if (pairs.size() < minimumAllowed) {
            if (this.verbose != null) {
                this.verbose.printf("pairs.size=%d is too small. minimum=%d\n", pairs.size(), minimumAllowed);
            }
            return;
        }
        this.countF = 0;
        if (this.ransac3D.process(pairs)) {
            this.countF = this.ransac3D.getMatchSet().size();
        }
        this.countH = 0;
        if (this.ransacH.process(pairs)) {
            this.countH = this.ransacH.getMatchSet().size();
        }
        this.is3D = (double)this.countF > (double)this.countH * this.ratio3D;
        boolean accepted = false;
        if (this.countF >= minimumAllowed) {
            this.saveInlierMatches(this.ransac3D, inliersIdx);
            fundamental.setTo((DMatrixD1)this.ransac3D.getModelParameters());
            accepted = true;
        } else if (this.countH >= minimumAllowed) {
            this.saveInlierMatches(this.ransacH, inliersIdx);
            Homography2D_F64 H = (Homography2D_F64)this.ransacH.getModelParameters();
            DConvertMatrixStruct.convert((DMatrix3x3)H, (DMatrixRMaj)fundamental);
            accepted = true;
        }
        if (this.verbose != null) {
            this.verbose.println("ransac F=" + this.countF + " H=" + this.countH + " pairs=" + pairs.size() + " 3d=" + this.is3D + " accepted=" + accepted);
        }
    }

    @Override
    public double getScore() {
        double score = Math.min(this.maxRatioScore, (double)this.countF / (double)(this.countH + 1));
        return score *= (double)this.countF;
    }

    @Override
    public boolean is3D() {
        return this.is3D;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> options) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    private void saveInlierMatches(ModelMatcher<?, ?> ransac, DogArray_I32 inliers) {
        int N = ransac.getMatchSet().size();
        inliers.resize(N);
        for (int i = 0; i < N; ++i) {
            inliers.set(i, ransac.getInputIndex(i));
        }
    }

    public ModelMatcher<DMatrixRMaj, AssociatedPair> getRansac3D() {
        return this.ransac3D;
    }

    public ModelMatcher<Homography2D_F64, AssociatedPair> getRansacH() {
        return this.ransacH;
    }

    public ConfigLength getMinimumInliers() {
        return this.minimumInliers;
    }

    public double getRatio3D() {
        return this.ratio3D;
    }

    public void setRatio3D(double ratio3D) {
        this.ratio3D = ratio3D;
    }

    public double getMaxRatioScore() {
        return this.maxRatioScore;
    }

    public void setMaxRatioScore(double maxRatioScore) {
        this.maxRatioScore = maxRatioScore;
    }

    public int getCountF() {
        return this.countF;
    }

    public int getCountH() {
        return this.countH;
    }
}

