/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.robust.RansacProjective;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.alg.structure.ConfigProjectiveReconstruction;
import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.ThreeViewEstimateMetricScene;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class InitializeCommonMetric
implements VerbosePrint {
    public PairwiseGraphUtils utils;
    protected final ThreeViewEstimateMetricScene pixelToMetric3 = new ThreeViewEstimateMetricScene();
    protected final DogArray<DogArray_I32> inlierIndexes = new DogArray(DogArray_I32::new, DogArray_I32::reset);
    protected final FastArray<PairwiseImageGraph.View> viewsByStructureIndex = new FastArray(PairwiseImageGraph.View.class);
    private final DogArray_I32 selectedTriple = new DogArray_I32(2);
    protected final DogArray_I32 seedToStructure = new DogArray_I32();
    DogArray_I32 seedFeatsIdx = new DogArray_I32();
    @Nullable
    private PrintStream verbose;

    public InitializeCommonMetric(ConfigProjectiveReconstruction configProjective) {
        this.utils = new PairwiseGraphUtils(configProjective);
    }

    public InitializeCommonMetric() {
        this(new ConfigProjectiveReconstruction());
    }

    public boolean metricScene(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams, PairwiseImageGraph.View seed, DogArray_I32 seedConnIdx, MetricCameras results) {
        results.reset();
        BoofMiscOps.checkTrue((seed.connections.size >= seedConnIdx.size ? 1 : 0) != 0, (String)"Can't have more seed connection indexes than actual connections");
        if (this.verbose != null) {
            this.verbose.println("ENTER projectiveSceneN: seed='" + seed.id + "' common.size=" + this.seedFeatsIdx.size + " conn.size=" + seedConnIdx.size);
        }
        if (seedConnIdx.size < 2) {
            if (this.verbose != null) {
                this.verbose.println("2-views, a.k.a. stereo, is a special case and requires different logic and isn't yet supported");
            }
            return false;
        }
        if (seedConnIdx.size >= 3) {
            if (this.verbose != null) {
                this.verbose.println("Can only handle the 3-view case for right now");
            }
            return false;
        }
        this.utils.dbSimilar = dbSimilar;
        this.utils.dbCams = dbCams;
        this.viewsByStructureIndex.reset();
        this.inlierIndexes.reset().resize(1 + seedConnIdx.size);
        if (!this.selectInitialTriplet(seed, seedConnIdx, this.selectedTriple)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Select initial triplet");
            }
            return false;
        }
        this.utils.findAllConnectedSeed(seed, this.selectedTriple, this.seedFeatsIdx);
        this.utils.seed = seed;
        this.utils.viewB = ((PairwiseImageGraph.Motion)this.utils.seed.connections.get(this.selectedTriple.data[0])).other(seed);
        this.utils.viewC = ((PairwiseImageGraph.Motion)this.utils.seed.connections.get(this.selectedTriple.data[1])).other(seed);
        this.utils.createThreeViewLookUpTables();
        this.utils.findFullyConnectedTriple(this.seedFeatsIdx);
        if (this.verbose != null) {
            this.verbose.println("Selected Triplet: seed='" + this.utils.seed.id + "' viewB='" + this.utils.viewB.id + "' viewC='" + this.utils.viewC.id + "' common.size=" + this.utils.commonIdx.size + " connections.size=" + seedConnIdx.size);
        }
        if (this.utils.commonIdx.isEmpty()) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: No common features found");
            }
            return false;
        }
        this.utils.createTripleFromCommon(this.verbose);
        if (!this.estimateMetricCamerasRobustly()) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Create metric views from initial triplet");
            }
            return false;
        }
        this.createStructureLookUpTables(seed);
        this.saveInlierObservationsConnectedViews();
        this.viewsByStructureIndex.resize(3);
        this.viewsByStructureIndex.set(0, (Object)this.utils.seed);
        this.viewsByStructureIndex.set(1, (Object)this.utils.viewB);
        this.viewsByStructureIndex.set(2, (Object)this.utils.viewC);
        this.viewsByStructureIndex.forIdx((i, o) -> BoofMiscOps.checkTrue((o != null ? 1 : 0) != 0));
        for (int camIdx = 0; camIdx < this.pixelToMetric3.listPinhole.size; ++camIdx) {
            ((CameraPinhole)results.intrinsics.grow()).setTo((CameraPinhole)this.pixelToMetric3.listPinhole.get(camIdx));
        }
        for (int viewIdx = 1; viewIdx < this.pixelToMetric3.listWorldToView.size; ++viewIdx) {
            ((Se3_F64)results.motion_1_to_k.grow()).setTo((Se3_F64)this.pixelToMetric3.listWorldToView.get(viewIdx));
        }
        return true;
    }

    private boolean isSingleCamera() {
        int camA = this.utils.dbCams.viewToCamera(this.utils.seed.id);
        int camB = this.utils.dbCams.viewToCamera(this.utils.viewB.id);
        int camC = this.utils.dbCams.viewToCamera(this.utils.viewC.id);
        return camA == camB && camA == camC;
    }

    public boolean estimateMetricCamerasRobustly() {
        int[] nArray;
        if (this.isSingleCamera()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray = nArray2;
            nArray2[2] = 0;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        this.pixelToMetric3.viewToCamera = nArray;
        this.pixelToMetric3.initialize(this.utils.priorCamA.width, this.utils.priorCamA.height);
        if (!this.pixelToMetric3.process(this.utils.matchesTriple.toList())) {
            return false;
        }
        this.utils.inliersThreeView.reset();
        this.utils.inliersThreeView.addAll(this.pixelToMetric3.ransac.getMatchSet());
        this.utils.inlierIdx.reset();
        this.utils.inlierIdx.resize(this.utils.inliersThreeView.size);
        for (int i = 0; i < this.utils.inliersThreeView.size; ++i) {
            this.utils.inlierIdx.data[i] = this.pixelToMetric3.ransac.getInputIndex(i);
        }
        return true;
    }

    void createStructureLookUpTables(PairwiseImageGraph.View viewA) {
        RansacProjective<MetricCameraTriple, AssociatedTriple> ransac = this.pixelToMetric3.ransac;
        int numInliers = ransac.getMatchSet().size();
        this.seedToStructure.resize(viewA.totalObservations);
        this.seedToStructure.fill(-1);
        DogArray_I32 inlierToSeed = (DogArray_I32)this.inlierIndexes.get(0);
        inlierToSeed.resize(numInliers);
        for (int i = 0; i < numInliers; ++i) {
            int inputIdx = ransac.getInputIndex(i);
            inlierToSeed.data[i] = this.utils.commonIdx.get(inputIdx);
            BoofMiscOps.checkTrue((this.seedToStructure.data[inlierToSeed.data[i]] == -1 ? 1 : 0) != 0);
            this.seedToStructure.data[inlierToSeed.data[i]] = i;
        }
    }

    boolean selectInitialTriplet(PairwiseImageGraph.View seed, DogArray_I32 edgeIdxs, DogArray_I32 selected) {
        selected.resize(2);
        double bestScore = 0.0;
        for (int i = 0; i < edgeIdxs.size; ++i) {
            int edgeI = edgeIdxs.get(i);
            PairwiseImageGraph.View viewB = ((PairwiseImageGraph.Motion)seed.connections.get(edgeI)).other(seed);
            for (int j = i + 1; j < edgeIdxs.size; ++j) {
                int edgeJ = edgeIdxs.get(j);
                PairwiseImageGraph.View viewC = ((PairwiseImageGraph.Motion)seed.connections.get(edgeJ)).other(seed);
                double s = this.scoreTripleView(seed, viewB, viewC);
                if (s <= bestScore) continue;
                bestScore = s;
                selected.data[0] = edgeI;
                selected.data[1] = edgeJ;
            }
        }
        return bestScore != 0.0;
    }

    double scoreTripleView(PairwiseImageGraph.View seedA, PairwiseImageGraph.View viewB, PairwiseImageGraph.View viewC) {
        PairwiseImageGraph.Motion motionAB = Objects.requireNonNull(seedA.findMotion(viewB));
        PairwiseImageGraph.Motion motionAC = Objects.requireNonNull(seedA.findMotion(viewC));
        PairwiseImageGraph.Motion motionBC = viewB.findMotion(viewC);
        if (motionBC == null) {
            return 0.0;
        }
        double score = 0.0;
        score += motionAB.score3D;
        score += motionAC.score3D;
        return score += motionBC.score3D;
    }

    private void saveInlierObservationsConnectedViews() {
        DogArray_I32 inlierToSeed = (DogArray_I32)this.inlierIndexes.get(0);
        for (int motionIdx = 0; motionIdx < this.selectedTriple.size(); ++motionIdx) {
            SceneObservations.View obsView = this.utils.observations.getView(motionIdx + 1);
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)this.utils.seed.connections.get(this.selectedTriple.get(motionIdx));
            PairwiseImageGraph.View v = m.other(this.utils.seed);
            boolean seedIsSrc = m.src == this.utils.seed;
            this.utils.dbCams.lookupCalibration(this.utils.dbCams.viewToCamera(v.id), this.utils.priorCamB);
            this.utils.dbSimilar.lookupPixelFeats(v.id, this.utils.featsB);
            BoofMiscOps.offsetPixels((List)this.utils.featsB.toList(), (double)(-this.utils.priorCamB.cx), (double)(-this.utils.priorCamB.cy));
            DogArray_I32 connInlierIndexes = (DogArray_I32)this.inlierIndexes.get(motionIdx + 1);
            connInlierIndexes.resize(inlierToSeed.size);
            for (int epipolarInlierIdx = 0; epipolarInlierIdx < m.inliers.size; ++epipolarInlierIdx) {
                AssociatedIndex a = (AssociatedIndex)m.inliers.get(epipolarInlierIdx);
                int structId = this.seedToStructure.data[seedIsSrc ? a.src : a.dst];
                if (structId < 0) continue;
                connInlierIndexes.set(structId, seedIsSrc ? a.dst : a.src);
                Point2D_F64 o = (Point2D_F64)this.utils.featsB.get(seedIsSrc ? a.dst : a.src);
                obsView.add(structId, (float)o.x, (float)o.y);
            }
        }
    }

    public PairwiseImageGraph.View getPairwiseGraphViewByStructureIndex(int index) {
        return (PairwiseImageGraph.View)this.viewsByStructureIndex.get(index);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        VerboseUtils.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.pixelToMetric3});
    }

    public SceneStructureMetric getStructure() {
        return this.pixelToMetric3.getStructure();
    }

    public PairwiseGraphUtils getUtils() {
        return this.utils;
    }

    public void setUtils(PairwiseGraphUtils utils) {
        this.utils = utils;
    }

    public ThreeViewEstimateMetricScene getPixelToMetric3() {
        return this.pixelToMetric3;
    }

    public DogArray<DogArray_I32> getInlierIndexes() {
        return this.inlierIndexes;
    }

    public FastArray<PairwiseImageGraph.View> getViewsByStructureIndex() {
        return this.viewsByStructureIndex;
    }
}

