/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.spawn;

import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.InitializeCommonMetric;
import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.MetricSanityChecks;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.RefineMetricWorkingGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class MetricSpawnSceneFromView
implements VerbosePrint {
    private final InitializeCommonMetric initialize;
    private final RefineMetricWorkingGraph refineWorking;
    public double fractionBadFeaturesRecover = 0.05;
    protected PairwiseGraphUtils utils;
    private final SceneWorkingGraph scene = new SceneWorkingGraph();
    @Nullable
    PrintStream verbose;
    List<String> viewIds = new ArrayList<String>();
    MetricCameras elevationResults = new MetricCameras();
    List<CameraPinholeBrown> listPriorCameras = new ArrayList<CameraPinholeBrown>();
    MetricSanityChecks checks = new MetricSanityChecks();

    public MetricSpawnSceneFromView(RefineMetricWorkingGraph refineWorking, PairwiseGraphUtils utils) {
        this.refineWorking = refineWorking;
        this.initialize = new InitializeCommonMetric();
        this.initialize.utils = utils;
        this.utils = utils;
    }

    public MetricSpawnSceneFromView() {
        this(new RefineMetricWorkingGraph(), new PairwiseGraphUtils());
    }

    public boolean process(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams, PairwiseImageGraph pairwise, PairwiseImageGraph.View seed, DogArray_I32 motions) {
        this.scene.reset();
        if (!this.initialize.metricScene(dbSimilar, dbCams, seed, motions, this.elevationResults)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Initialize projective scene");
            }
            return false;
        }
        this.viewIds.clear();
        for (int i = 0; i < this.initialize.getViewsByStructureIndex().size; ++i) {
            this.viewIds.add(((PairwiseImageGraph.View)this.initialize.getViewsByStructureIndex().get((int)i)).id);
        }
        this.saveMetricSeed(pairwise, this.viewIds, (FastAccess<DogArray_I32>)this.initialize.getInlierIndexes(), this.elevationResults, this.scene);
        return this.refineAndRemoveBadFeatures(dbSimilar, seed);
    }

    private boolean refineAndRemoveBadFeatures(LookUpSimilarImages dbSimilar, PairwiseImageGraph.View seed) {
        this.listPriorCameras.clear();
        for (int i = 0; i < this.scene.listViews.size(); ++i) {
            SceneWorkingGraph.Camera camera = this.scene.getViewCamera(this.scene.listViews.get(i));
            this.listPriorCameras.add(camera.prior);
        }
        for (int loop = 0; loop < 2; ++loop) {
            if (!this.refineWorking.process(dbSimilar, this.scene)) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED: Refine metric. seed.id='" + seed.id + "'");
                }
                return false;
            }
            if (!this.checks.checkPhysicalConstraints(this.refineWorking.metricSba, this.listPriorCameras)) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED: Unrecoverable physical constraint");
                }
                return false;
            }
            int numInliers = ((SceneWorkingGraph.InlierInfo)this.scene.listViews.get((int)0).inliers.get(0)).getInlierCount();
            BoofMiscOps.checkTrue((numInliers == this.checks.badFeatures.size ? 1 : 0) != 0);
            int countBadFeatures = this.checks.badFeatures.count(true);
            if ((double)countBadFeatures > this.fractionBadFeaturesRecover * (double)this.checks.badFeatures.size) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED: Too many bad features. bad=" + countBadFeatures + "/" + numInliers);
                }
                return false;
            }
            if (countBadFeatures == 0) {
                return true;
            }
            if (loop != 0) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED: Couldn't fix the upgrade. bad=" + countBadFeatures + "/" + numInliers);
                }
                return false;
            }
            if (this.verbose != null) {
                this.verbose.println("Removed bad features. Optimizing again. bad=" + countBadFeatures + "/" + numInliers);
            }
            for (int inlierIdx = this.checks.badFeatures.size - 1; inlierIdx >= 0; --inlierIdx) {
                if (!this.checks.badFeatures.get(inlierIdx)) continue;
                for (int listIdx = 0; listIdx < this.scene.listViews.size(); ++listIdx) {
                    SceneWorkingGraph.InlierInfo info = (SceneWorkingGraph.InlierInfo)this.scene.listViews.get((int)listIdx).inliers.get(0);
                    for (int viewIdx = 0; viewIdx < info.observations.size; ++viewIdx) {
                        ((DogArray_I32)info.observations.get(viewIdx)).removeSwap(inlierIdx);
                    }
                }
            }
            for (int cameraIdx = 0; cameraIdx < this.scene.listCameras.size(); ++cameraIdx) {
                SceneWorkingGraph.Camera c = (SceneWorkingGraph.Camera)this.scene.listCameras.get(cameraIdx);
                c.intrinsic.k1 = 0.0;
                c.intrinsic.k2 = 0.0;
            }
        }
        throw new RuntimeException("BUG! Should have already returned");
    }

    void saveMetricSeed(PairwiseImageGraph graph, List<String> viewIds, FastAccess<DogArray_I32> viewInlierIndexes, MetricCameras results, SceneWorkingGraph scene) {
        BoofMiscOps.checkEq((int)viewIds.size(), (int)(results.motion_1_to_k.size + 1), (String)"view count and motion count do not match");
        BoofMiscOps.checkEq((int)viewIds.size(), (int)viewInlierIndexes.size());
        scene.numSeedViews = viewIds.size();
        for (int i = 0; i < viewIds.size(); ++i) {
            PairwiseImageGraph.View pview = graph.lookupNode(viewIds.get(i));
            int cameraDbIdx = this.utils.dbCams.viewToCamera(pview.id);
            SceneWorkingGraph.Camera camera = (SceneWorkingGraph.Camera)scene.cameras.get(cameraDbIdx);
            if (camera == null) {
                camera = scene.addCamera(cameraDbIdx);
                this.utils.dbCams.lookupCalibration(cameraDbIdx, camera.prior);
                BundleAdjustmentOps.convert((CameraPinhole)((CameraPinhole)results.intrinsics.get(i)), (BundlePinholeSimplified)camera.intrinsic);
            }
            SceneWorkingGraph.View wview = scene.addView(pview, camera);
            if (i <= 0) continue;
            wview.world_to_view.setTo((Se3_F64)results.motion_1_to_k.get(i - 1));
        }
        for (int constructIdx = 0; constructIdx < viewIds.size(); ++constructIdx) {
            SceneWorkingGraph.View wtarget = scene.lookupView(viewIds.get(constructIdx));
            SceneWorkingGraph.InlierInfo inlier = (SceneWorkingGraph.InlierInfo)wtarget.inliers.grow();
            inlier.views.resize(viewIds.size());
            inlier.observations.reset().resize(viewIds.size());
            for (int offset = 0; offset < viewIds.size(); ++offset) {
                int viewIdx = (constructIdx + offset) % viewIds.size();
                inlier.views.set(offset, (Object)graph.lookupNode(viewIds.get(viewIdx)));
                ((DogArray_I32)inlier.observations.get(offset)).setTo((DogArray_I32)viewInlierIndexes.get(viewIdx));
                BoofMiscOps.checkEq((int)((DogArray_I32)inlier.observations.get((int)offset)).size, (int)((DogArray_I32)inlier.observations.get((int)0)).size, (String)"Each view should have the same number of observations");
            }
        }
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        VerboseUtils.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.initialize, this.checks});
    }

    public InitializeCommonMetric getInitialize() {
        return this.initialize;
    }

    public RefineMetricWorkingGraph getRefineWorking() {
        return this.refineWorking;
    }

    public SceneWorkingGraph getScene() {
        return this.scene;
    }
}

