/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.overhead;

import boofcv.alg.distort.LensDistortionOps;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import org.ejml.data.DMatrixRMaj;

public class CameraPlaneProjection {
    private Se3_F64 planeToCamera;
    private Se3_F64 cameraToPlane = new Se3_F64();
    private Point2Transform2_F64 pixelToNorm;
    private Point2Transform2_F64 normToPixel;
    private Point3D_F64 plain3D = new Point3D_F64();
    private Point3D_F64 camera3D = new Point3D_F64();
    private Point2D_F64 norm = new Point2D_F64();
    private Vector3D_F64 pointing = new Vector3D_F64();

    public void setConfiguration(Se3_F64 planeToCamera, CameraPinholeRadial intrinsic) {
        this.planeToCamera = planeToCamera;
        this.normToPixel = LensDistortionOps.narrow((CameraModel)intrinsic).distort_F64(false, true);
        this.pixelToNorm = LensDistortionOps.narrow((CameraModel)intrinsic).undistort_F64(true, false);
        planeToCamera.invert(this.cameraToPlane);
    }

    public void setIntrinsic(CameraPinholeRadial intrinsic) {
        this.normToPixel = LensDistortionOps.narrow((CameraModel)intrinsic).distort_F64(false, true);
        this.pixelToNorm = LensDistortionOps.narrow((CameraModel)intrinsic).undistort_F64(true, false);
    }

    public void setPlaneToCamera(Se3_F64 planeToCamera, boolean computeInverse) {
        this.planeToCamera = planeToCamera;
        if (computeInverse) {
            planeToCamera.invert(this.cameraToPlane);
        }
    }

    public boolean planeToPixel(double pointX, double pointY, Point2D_F64 pixel) {
        this.plain3D.set(-pointY, 0.0, pointX);
        SePointOps_F64.transform((Se3_F64)this.planeToCamera, (Point3D_F64)this.plain3D, (Point3D_F64)this.camera3D);
        if (this.camera3D.z <= 0.0) {
            return false;
        }
        double normX = this.camera3D.x / this.camera3D.z;
        double normY = this.camera3D.y / this.camera3D.z;
        this.normToPixel.compute(normX, normY, pixel);
        return true;
    }

    public boolean planeToNormalized(double pointX, double pointY, Point2D_F64 normalized) {
        this.plain3D.set(-pointY, 0.0, pointX);
        SePointOps_F64.transform((Se3_F64)this.planeToCamera, (Point3D_F64)this.plain3D, (Point3D_F64)this.camera3D);
        if (this.camera3D.z <= 0.0) {
            return false;
        }
        normalized.x = this.camera3D.x / this.camera3D.z;
        normalized.y = this.camera3D.y / this.camera3D.z;
        return true;
    }

    public boolean pixelToPlane(double pixelX, double pixelY, Point2D_F64 plane) {
        this.pixelToNorm.compute(pixelX, pixelY, this.norm);
        this.pointing.set(this.norm.x, this.norm.y, 1.0);
        GeometryMath_F64.mult((DMatrixRMaj)this.cameraToPlane.getR(), (GeoTuple3D_F64)this.pointing, (GeoTuple3D_F64)this.pointing);
        double height = this.cameraToPlane.getY();
        if (this.pointing.y * height >= 0.0) {
            return false;
        }
        double t = -height / this.pointing.y;
        plane.x = this.pointing.z * t;
        plane.y = -this.pointing.x * t;
        return true;
    }

    public boolean normalToPlane(double normX, double normY, Point2D_F64 plane) {
        this.pointing.set(normX, normY, 1.0);
        GeometryMath_F64.mult((DMatrixRMaj)this.cameraToPlane.getR(), (GeoTuple3D_F64)this.pointing, (GeoTuple3D_F64)this.pointing);
        double height = this.cameraToPlane.getY();
        if (this.pointing.y * height >= 0.0) {
            return false;
        }
        double t = -height / this.pointing.y;
        plane.x = this.pointing.z * t;
        plane.y = -this.pointing.x * t;
        return true;
    }
}

