/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.AccessPointTracks;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.alg.sfm.d3.VisOdomMonoOverheadMotion2D;
import boofcv.alg.sfm.overhead.OverheadView;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class MonoOverhead_to_MonocularPlaneVisualOdometry<T extends ImageBase<T>>
implements MonocularPlaneVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomMonoOverheadMotion2D<T> alg;
    ImageType<T> imageType;
    boolean fault;
    Se3_F64 cameraToWorld = new Se3_F64();
    boolean computed;
    FastQueue<Point2D_F64> pixels = new FastQueue(Point2D_F64.class, true);
    FastQueue<Point3D_F64> points3D = new FastQueue(Point3D_F64.class, true);
    Se3_F64 planeToCamera;
    Point2Transform2_F64 normToPixel;

    public MonoOverhead_to_MonocularPlaneVisualOdometry(VisOdomMonoOverheadMotion2D<T> alg, ImageType<T> imageType) {
        this.alg = alg;
        this.imageType = imageType;
    }

    @Override
    public void setCalibration(MonoPlaneParameters param) {
        this.planeToCamera = param.planeToCamera;
        this.alg.configureCamera(param.intrinsic, param.planeToCamera);
        this.normToPixel = LensDistortionFactory.narrow((CameraModel)param.intrinsic).distort_F64(false, true);
    }

    @Override
    public boolean process(T input) {
        this.computed = false;
        this.fault = this.alg.process(input);
        return this.fault;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return this.fault;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        Se3_F64 worldToCamera = this.alg.getWorldToCurr3D();
        worldToCamera.invert(this.cameraToWorld);
        return this.cameraToWorld;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        this.computeTracks();
        return (Point3D_F64)this.points3D.get(index);
    }

    @Override
    public long getTrackId(int index) {
        AccessPointTracks accessPlane = (AccessPointTracks)((Object)this.alg.getMotion2D());
        return accessPlane.getTrackId(index);
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        this.computeTracks();
        return this.pixels.toList();
    }

    @Override
    public boolean isInlier(int index) {
        AccessPointTracks accessPlane = (AccessPointTracks)((Object)this.alg.getMotion2D());
        return accessPlane.isInlier(index);
    }

    @Override
    public boolean isNew(int index) {
        AccessPointTracks accessPlane = (AccessPointTracks)((Object)this.alg.getMotion2D());
        return accessPlane.isNew(index);
    }

    private void computeTracks() {
        if (this.computed) {
            return;
        }
        if (!(this.alg.getMotion2D() instanceof AccessPointTracks)) {
            return;
        }
        AccessPointTracks accessPlane = (AccessPointTracks)((Object)this.alg.getMotion2D());
        List<Point2D_F64> tracksPlane = accessPlane.getAllTracks();
        OverheadView<T> map = this.alg.getOverhead();
        this.points3D.reset();
        this.pixels.reset();
        for (Point2D_F64 worldPt : tracksPlane) {
            Point3D_F64 p = (Point3D_F64)this.points3D.grow();
            p.z = worldPt.x * map.cellSize - map.centerX;
            p.x = -(worldPt.y * map.cellSize - map.centerY);
            p.y = 0.0;
            SePointOps_F64.transform((Se3_F64)this.planeToCamera, (Point3D_F64)p, (Point3D_F64)p);
            this.normToPixel.compute(p.x / p.z, p.y / p.z, (Point2D_F64)this.pixels.grow());
        }
        this.computed = true;
    }
}

