/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.depth;

import boofcv.alg.distort.radtan.RemoveRadialPtoN_F64;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.FastQueueArray_I32;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.struct.FastQueue;

public class VisualDepthOps {
    public static void depthTo3D(CameraPinholeRadial param, GrayU16 depth, FastQueue<Point3D_F64> cloud) {
        cloud.reset();
        Point2Transform2_F64 p2n = LensDistortionFactory.narrow((CameraModel)param).undistort_F64(true, false);
        Point2D_F64 n = new Point2D_F64();
        for (int y = 0; y < depth.height; ++y) {
            int index = depth.startIndex + y * depth.stride;
            for (int x = 0; x < depth.width; ++x) {
                int mm;
                if ((mm = depth.data[index++] & 0xFFFF) == 0) continue;
                p2n.compute((double)x, (double)y, n);
                Point3D_F64 p = (Point3D_F64)cloud.grow();
                p.z = mm;
                p.x = n.x * p.z;
                p.y = n.y * p.z;
            }
        }
    }

    public static void depthTo3D(CameraPinholeRadial param, Planar<GrayU8> rgb, GrayU16 depth, FastQueue<Point3D_F64> cloud, FastQueueArray_I32 cloudColor) {
        cloud.reset();
        cloudColor.reset();
        RemoveRadialPtoN_F64 p2n = new RemoveRadialPtoN_F64();
        p2n.setK(param.fx, param.fy, param.skew, param.cx, param.cy).setDistortion(param.radial, param.t1, param.t2);
        Point2D_F64 n = new Point2D_F64();
        GrayU8 colorR = (GrayU8)rgb.getBand(0);
        GrayU8 colorG = (GrayU8)rgb.getBand(1);
        GrayU8 colorB = (GrayU8)rgb.getBand(2);
        for (int y = 0; y < depth.height; ++y) {
            int index = depth.startIndex + y * depth.stride;
            for (int x = 0; x < depth.width; ++x) {
                int mm;
                if ((mm = depth.data[index++] & 0xFFFF) == 0) continue;
                p2n.compute((double)x, (double)y, n);
                Point3D_F64 p = (Point3D_F64)cloud.grow();
                p.z = mm;
                p.x = n.x * p.z;
                p.y = n.y * p.z;
                int[] color = (int[])cloudColor.grow();
                color[0] = colorR.unsafe_get(x, y);
                color[1] = colorG.unsafe_get(x, y);
                color[2] = colorB.unsafe_get(x, y);
            }
        }
    }
}

