/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d2;

import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.PixelTransformHomography_F32;
import boofcv.struct.distort.PixelTransform2_F32;
import georegression.struct.ConvertFloatType;
import georegression.struct.InvertibleTransform;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.affine.UtilAffine;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.homography.Homography2D_F64;

public class UtilImageMotion {
    public static PixelTransform2_F32 createPixelTransform(InvertibleTransform transform) {
        PixelTransformHomography_F32 pixelTran;
        if (transform instanceof Homography2D_F64) {
            Homography2D_F32 t = ConvertFloatType.convert((Homography2D_F64)((Homography2D_F64)transform), null);
            pixelTran = new PixelTransformHomography_F32(t);
        } else if (transform instanceof Homography2D_F32) {
            pixelTran = new PixelTransformHomography_F32((Homography2D_F32)transform);
        } else if (transform instanceof Affine2D_F64) {
            Affine2D_F32 t = UtilAffine.convert((Affine2D_F64)((Affine2D_F64)transform), null);
            pixelTran = new PixelTransformAffine_F32(t);
        } else if (transform instanceof Affine2D_F32) {
            pixelTran = new PixelTransformAffine_F32((Affine2D_F32)transform);
        } else {
            throw new RuntimeException("Unknown model type");
        }
        return pixelTran;
    }
}

