/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.sfm.ScaleTranslateRotate2D;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceScaleTranslateRotate2DSq
implements DistanceFromModel<ScaleTranslateRotate2D, AssociatedPair> {
    ScaleTranslateRotate2D model;
    double c;
    double s;

    public void setModel(ScaleTranslateRotate2D model) {
        this.model = model;
        this.c = Math.cos(model.theta);
        this.s = Math.sin(model.theta);
    }

    public double computeDistance(AssociatedPair pt) {
        double dx = pt.p2.x - (pt.p1.x * this.c - pt.p1.y * this.s) * this.model.scale - this.model.transX;
        double dy = pt.p2.y - (pt.p1.x * this.s + pt.p1.y * this.c) * this.model.scale - this.model.transY;
        return dx * dx + dy * dy;
    }

    public void computeDistance(List<AssociatedPair> obs, double[] distance) {
        int N = obs.size();
        for (int i = 0; i < N; ++i) {
            distance[i] = this.computeDistance(obs.get(i));
        }
    }

    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    public Class<ScaleTranslateRotate2D> getModelType() {
        return ScaleTranslateRotate2D.class;
    }
}

