/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.sfm.StereoSparse3D;
import boofcv.alg.sfm.d3.VisOdomPixelDepthPnP;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.sfm.Point2D3DTrack;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;

public class WrapVisOdomPixelDepthPnP<T extends ImageGray<T>>
implements StereoVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomPixelDepthPnP<T> alg;
    StereoSparse3D<T> stereo;
    DistanceFromModelMultiView<Se3_F64, Point2D3D> distance;
    Class<T> imageType;
    boolean success;
    List<PointTrack> active = new ArrayList<PointTrack>();

    public WrapVisOdomPixelDepthPnP(VisOdomPixelDepthPnP<T> alg, StereoSparse3D<T> stereo, DistanceFromModelMultiView<Se3_F64, Point2D3D> distance, Class<T> imageType) {
        this.alg = alg;
        this.stereo = stereo;
        this.distance = distance;
        this.imageType = imageType;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        PointTrack t = (PointTrack)this.alg.getTracker().getActiveTracks(null).get(index);
        return ((Point2D3D)t.getCookie()).getLocation();
    }

    @Override
    public long getTrackId(int index) {
        return this.active.get((int)index).featureId;
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        return this.active;
    }

    @Override
    public boolean isInlier(int index) {
        Point2D3DTrack t = (Point2D3DTrack)((Object)this.active.get(index).getCookie());
        return t.lastInlier == this.alg.getTick();
    }

    @Override
    public boolean isNew(int index) {
        PointTrack t = (PointTrack)this.alg.getTracker().getActiveTracks(null).get(index);
        return this.alg.getTracker().getNewTracks(null).contains(t);
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        this.stereo.setCalibration(parameters);
        CameraPinholeBrown l = parameters.left;
        Point2Transform2_F64 leftPixelToNorm = LensDistortionFactory.narrow((CameraModel)l).undistort_F64(true, false);
        Point2Transform2_F64 leftNormToPixel = LensDistortionFactory.narrow((CameraModel)l).distort_F64(false, true);
        this.alg.setPixelToNorm(leftPixelToNorm);
        this.alg.setNormToPixel(leftNormToPixel);
        this.distance.setIntrinsic(0, (CameraPinhole)l);
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        this.stereo.setImages(leftImage, rightImage);
        this.success = this.alg.process(leftImage);
        this.active.clear();
        this.alg.getTracker().getActiveTracks(this.active);
        return this.success;
    }

    @Override
    public ImageType<T> getImageType() {
        return ImageType.single(this.imageType);
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return !this.success;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getCurrToWorld();
    }
}

