/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure2;

import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.ScaleSceneStructure;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.alg.geo.pose.PoseFromPairLinear6;
import boofcv.alg.sfm.structure2.DoStuffFromPairwiseGraph;
import boofcv.alg.sfm.structure2.LookupSimilarImages;
import boofcv.alg.sfm.structure2.PairwiseImageGraph2;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.ConfigTrifocalError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.misc.ConfigConverge;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.AssociatedTripleIndex;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ProjectiveInitializeAllCommon {
    public ConfigRansac configRansac = new ConfigRansac();
    public ConfigTrifocal configTriRansac = new ConfigTrifocal();
    public ConfigTrifocalError configError = new ConfigTrifocalError();
    public ConfigLevenbergMarquardt configLM = new ConfigLevenbergMarquardt();
    public ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
    public ConfigConverge converge = new ConfigConverge(1.0E-8, 1.0E-8, 200);
    public boolean scaleSBA = true;
    public SceneStructureProjective structure = new SceneStructureProjective(true);
    public Ransac<TrifocalTensor, AssociatedTriple> ransac;
    public TriangulateNViewsProjective triangulator;
    public PoseFromPairLinear6 poseEstimator = new PoseFromPairLinear6();
    public BundleAdjustment<SceneStructureProjective> sba;
    public ScaleSceneStructure scaler = new ScaleSceneStructure();
    private LookupSimilarImages db;
    FastQueue<Point2D_F64> featsA = new FastQueue(Point2D_F64.class, true);
    FastQueue<Point2D_F64> featsB = new FastQueue(Point2D_F64.class, true);
    FastQueue<Point2D_F64> featsC = new FastQueue(Point2D_F64.class, true);
    GrowQueue_I32 inlierToSeed = new GrowQueue_I32();
    PrintStream verbose;
    int verboseLevel;
    int[] selectedTriple = new int[2];
    FastQueue<AssociatedTripleIndex> matchesTripleIdx = new FastQueue(AssociatedTripleIndex.class, true);
    FastQueue<AssociatedTriple> matchesTriple = new FastQueue(AssociatedTriple.class, true);
    FastQueue<Point4D_F64> points3D = new FastQueue(Point4D_F64.class, true);
    FastQueue<AssociatedPair> assocPixel = new FastQueue(AssociatedPair.class, true);
    ImageDimension shape = new ImageDimension();
    GrowQueue_I32 seedToStructure = new GrowQueue_I32();

    public ProjectiveInitializeAllCommon() {
        this.configRansac.maxIterations = 500;
        this.configRansac.inlierThreshold = 1.0;
        this.triangulator = FactoryMultiView.triangulateNView((ConfigTriangulation)ConfigTriangulation.GEOMETRIC);
        this.fixate();
    }

    public void fixate() {
        this.ransac = FactoryMultiViewRobust.trifocalRansac((ConfigTrifocal)this.configTriRansac, (ConfigTrifocalError)this.configError, (ConfigRansac)this.configRansac);
        this.sba = FactoryMultiView.bundleSparseProjective((ConfigBundleAdjustment)this.configSBA);
    }

    public boolean process(LookupSimilarImages db, PairwiseImageGraph2.View seed, GrowQueue_I32 common, GrowQueue_I32 motions) {
        this.db = db;
        if (motions.size == 1) {
            throw new IllegalArgumentException("Can't handle the stereo case yet");
        }
        if (!this.selectInitialTriplet(seed, motions, this.selectedTriple)) {
            return false;
        }
        PairwiseImageGraph2.Motion seedB = (PairwiseImageGraph2.Motion)seed.connections.get(this.selectedTriple[0]);
        PairwiseImageGraph2.Motion seedC = (PairwiseImageGraph2.Motion)seed.connections.get(this.selectedTriple[1]);
        PairwiseImageGraph2.View viewB = seedB.other(seed);
        PairwiseImageGraph2.View viewC = seedC.other(seed);
        this.findTripleMatches(seed, seedB, seedC, this.matchesTripleIdx);
        if (this.matchesTripleIdx.size == 0) {
            return false;
        }
        this.convertAssociatedTriple(db, seed, viewB, viewC);
        this.initializeProjective3(this.matchesTriple, this.matchesTripleIdx, motions.size, seed, viewB, viewC, this.selectedTriple[0], this.selectedTriple[1]);
        if (common.size > 2 && !this.findRemainingCameraMatrices(db, seed, motions)) {
            return false;
        }
        SceneObservations observations = this.createObservationsForBundleAdjustment(db, seed, motions);
        return this.refineWithBundleAdjustment(observations);
    }

    boolean selectInitialTriplet(PairwiseImageGraph2.View seed, GrowQueue_I32 motions, int[] selected) {
        double bestScore = 0.0;
        for (int i = 0; i < motions.size; ++i) {
            PairwiseImageGraph2.View viewB = ((PairwiseImageGraph2.Motion)seed.connections.get(i)).other(seed);
            for (int j = i + 1; j < motions.size; ++j) {
                PairwiseImageGraph2.View viewC = ((PairwiseImageGraph2.Motion)seed.connections.get(j)).other(seed);
                double s = this.scoreTripleView(seed, viewB, viewC);
                if (!(s > bestScore)) continue;
                bestScore = s;
                selected[0] = i;
                selected[1] = j;
            }
        }
        return bestScore != 0.0;
    }

    double scoreTripleView(PairwiseImageGraph2.View seedA, PairwiseImageGraph2.View viewB, PairwiseImageGraph2.View viewC) {
        PairwiseImageGraph2.Motion motionAB = seedA.findMotion(viewB);
        PairwiseImageGraph2.Motion motionAC = seedA.findMotion(viewC);
        PairwiseImageGraph2.Motion motionBC = viewB.findMotion(viewC);
        if (motionBC == null) {
            return 0.0;
        }
        double score = 0.0;
        score += DoStuffFromPairwiseGraph.score(motionAB);
        score += DoStuffFromPairwiseGraph.score(motionAC);
        return score += DoStuffFromPairwiseGraph.score(motionBC);
    }

    void findTripleMatches(PairwiseImageGraph2.View seedA, PairwiseImageGraph2.Motion edgeAB, PairwiseImageGraph2.Motion edgeAC, FastQueue<AssociatedTripleIndex> matchesTri) {
        matchesTri.reset();
        boolean srcAB = edgeAB.src == seedA;
        boolean srcAC = edgeAC.src == seedA;
        PairwiseImageGraph2.View viewB = srcAB ? edgeAB.dst : edgeAB.src;
        PairwiseImageGraph2.View viewC = srcAC ? edgeAC.dst : edgeAC.src;
        PairwiseImageGraph2.Motion edgeBC = viewB.findMotion(viewC);
        if (edgeBC == null) {
            return;
        }
        int[] table_B_to_A = this.createFeatureLookup(edgeAB, srcAB, viewB);
        int[] table_C_to_A = this.createFeatureLookup(edgeAC, srcAC, viewC);
        boolean srcIsB = edgeBC.src == viewB;
        for (int i = 0; i < edgeBC.inliers.size; ++i) {
            AssociatedIndex assoc = (AssociatedIndex)edgeBC.inliers.get(i);
            if (!srcIsB || table_B_to_A[assoc.src] == -1) continue;
            AssociatedTripleIndex tri = (AssociatedTripleIndex)matchesTri.grow();
            tri.a = table_B_to_A[assoc.src];
            if (table_C_to_A[assoc.dst] == tri.a) {
                tri.b = assoc.src;
                tri.c = assoc.dst;
                continue;
            }
            matchesTri.removeTail();
        }
    }

    private int[] createFeatureLookup(PairwiseImageGraph2.Motion edgeAC, boolean srcAC, PairwiseImageGraph2.View viewC) {
        int[] table_C_to_A = new int[viewC.totalFeatures];
        Arrays.fill(table_C_to_A, 0, viewC.totalFeatures, -1);
        for (int i = 0; i < edgeAC.inliers.size; ++i) {
            AssociatedIndex assoc = (AssociatedIndex)edgeAC.inliers.get(i);
            if (srcAC) {
                table_C_to_A[assoc.dst] = assoc.src;
                continue;
            }
            table_C_to_A[assoc.src] = assoc.dst;
        }
        return table_C_to_A;
    }

    private void triangulateFeatures(List<AssociatedTriple> inliers, DMatrixRMaj P1, DMatrixRMaj P2, DMatrixRMaj P3) {
        ArrayList<DMatrixRMaj> cameraMatrices = new ArrayList<DMatrixRMaj>();
        cameraMatrices.add(P1);
        cameraMatrices.add(P2);
        cameraMatrices.add(P3);
        ArrayList<Point2D_F64> triangObs = new ArrayList<Point2D_F64>();
        triangObs.add(null);
        triangObs.add(null);
        triangObs.add(null);
        Point4D_F64 X = new Point4D_F64();
        for (int i = 0; i < inliers.size(); ++i) {
            AssociatedTriple t = inliers.get(i);
            triangObs.set(0, t.p1);
            triangObs.set(1, t.p2);
            triangObs.set(2, t.p3);
            if (!this.triangulator.triangulate(triangObs, cameraMatrices, X)) {
                throw new RuntimeException("Failed to triangulate a point in the inlier set?! Handle if this is common");
            }
            this.structure.points[i].set(X.x, X.y, X.z, X.w);
        }
    }

    private void convertAssociatedTriple(LookupSimilarImages db, PairwiseImageGraph2.View seed, PairwiseImageGraph2.View viewB, PairwiseImageGraph2.View viewC) {
        db.lookupPixelFeats(seed.id, this.featsA);
        db.lookupPixelFeats(viewB.id, this.featsB);
        db.lookupPixelFeats(viewC.id, this.featsC);
        this.matchesTriple.reset();
        this.matchesTriple.growArray(this.matchesTripleIdx.size);
        for (int i = 0; i < this.matchesTripleIdx.size; ++i) {
            AssociatedTripleIndex idx = (AssociatedTripleIndex)this.matchesTripleIdx.get(i);
            AssociatedTriple a = (AssociatedTriple)this.matchesTriple.grow();
            a.p1.set((Point2D_F64)this.featsA.get(idx.a));
            a.p2.set((Point2D_F64)this.featsB.get(idx.b));
            a.p3.set((Point2D_F64)this.featsC.get(idx.c));
        }
    }

    private void initializeProjective3(FastQueue<AssociatedTriple> associated, FastQueue<AssociatedTripleIndex> associatedIdx, int totalViews, PairwiseImageGraph2.View viewA, PairwiseImageGraph2.View viewB, PairwiseImageGraph2.View viewC, int idxViewB, int idxViewC) {
        this.ransac.process(associated.toList());
        List inliers = this.ransac.getMatchSet();
        TrifocalTensor model = (TrifocalTensor)this.ransac.getModelParameters();
        if (this.verbose != null) {
            this.verbose.println("Remaining after RANSAC " + inliers.size() + " / " + associated.size());
        }
        DMatrixRMaj P1 = CommonOps_DDRM.identity((int)3, (int)4);
        DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
        DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
        MultiViewOps.extractCameraMatrices((TrifocalTensor)model, (DMatrixRMaj)P2, (DMatrixRMaj)P3);
        this.structure.initialize(totalViews, inliers.size());
        this.db.lookupShape(viewA.id, this.shape);
        this.structure.setView(0, true, P1, this.shape.width, this.shape.height);
        this.db.lookupShape(viewB.id, this.shape);
        this.structure.setView(idxViewB, false, P2, this.shape.width, this.shape.height);
        this.db.lookupShape(viewC.id, this.shape);
        this.structure.setView(idxViewC, false, P3, this.shape.width, this.shape.height);
        this.triangulateFeatures(inliers, P1, P2, P3);
        this.seedToStructure.resize(viewA.totalFeatures);
        this.seedToStructure.fill(-1);
        this.inlierToSeed.resize(inliers.size());
        for (int i = 0; i < inliers.size(); ++i) {
            int inputIdx = this.ransac.getInputIndex(i);
            this.inlierToSeed.data[i] = ((AssociatedTripleIndex)this.matchesTripleIdx.get((int)inputIdx)).a;
            this.seedToStructure.data[this.inlierToSeed.data[i]] = i;
        }
    }

    boolean findRemainingCameraMatrices(LookupSimilarImages db, PairwiseImageGraph2.View seed, GrowQueue_I32 motions) {
        int i;
        this.points3D.reset();
        for (i = 0; i < this.structure.points.length; ++i) {
            this.structure.points[i].get((Point4D_F64)this.points3D.grow());
        }
        this.assocPixel.reset();
        for (i = 0; i < this.inlierToSeed.size; ++i) {
            ((AssociatedPair)this.assocPixel.grow()).p1.set(((AssociatedTriple)this.matchesTriple.get((int)i)).p1);
        }
        DMatrixRMaj cameraMatrix = new DMatrixRMaj(3, 4);
        for (int motionIdx = 0; motionIdx < motions.size; ++motionIdx) {
            if (motionIdx == this.selectedTriple[0] || motionIdx == this.selectedTriple[1]) continue;
            int connectionIdx = motions.get(motionIdx);
            PairwiseImageGraph2.Motion edge = (PairwiseImageGraph2.Motion)seed.connections.get(connectionIdx);
            PairwiseImageGraph2.View viewI = edge.other(seed);
            db.lookupPixelFeats(viewI.id, this.featsB);
            if (!this.computeCameraMatrix(seed, edge, this.featsB, cameraMatrix)) {
                if (this.verbose != null) {
                    this.verbose.println("Pose estimator failed! motionIdx=" + motionIdx);
                }
                return false;
            }
            db.lookupShape(edge.other((PairwiseImageGraph2.View)seed).id, this.shape);
            this.structure.setView(motionIdx, false, cameraMatrix, this.shape.width, this.shape.height);
        }
        return true;
    }

    private boolean computeCameraMatrix(PairwiseImageGraph2.View seed, PairwiseImageGraph2.Motion edge, FastQueue<Point2D_F64> featsB, DMatrixRMaj cameraMatrix) {
        boolean seedSrc = edge.src == seed;
        int matched = 0;
        for (int i = 0; i < edge.inliers.size; ++i) {
            AssociatedIndex a = (AssociatedIndex)edge.inliers.get(i);
            int featId = this.seedToStructure.data[seedSrc ? a.src : a.dst];
            if (featId == -1) continue;
            ((AssociatedPair)this.assocPixel.get((int)featId)).p2.set((Point2D_F64)featsB.get(seedSrc ? a.dst : a.src));
            ++matched;
        }
        if (matched != this.assocPixel.size) {
            throw new RuntimeException("BUG! Didn't find all features in the view");
        }
        if (this.poseEstimator.processHomogenous(this.assocPixel.toList(), this.points3D.toList())) {
            cameraMatrix.set((DMatrixD1)this.poseEstimator.getProjective());
            return true;
        }
        return false;
    }

    private SceneObservations createObservationsForBundleAdjustment(LookupSimilarImages db, PairwiseImageGraph2.View seed, GrowQueue_I32 motions) {
        int i;
        SceneObservations observations = new SceneObservations(motions.size + 1);
        SceneObservations.View obsView = observations.getView(0);
        for (i = 0; i < this.inlierToSeed.size; ++i) {
            int id = this.inlierToSeed.data[i];
            Point2D_F64 o = (Point2D_F64)this.featsA.get(id);
            id = this.seedToStructure.data[id];
            obsView.add(id, (float)o.x, (float)o.y);
        }
        for (i = 0; i < motions.size(); ++i) {
            obsView = observations.getView(i + 1);
            PairwiseImageGraph2.Motion m = (PairwiseImageGraph2.Motion)seed.connections.get(motions.get(i));
            PairwiseImageGraph2.View v = m.other(seed);
            boolean seedIsSrc = m.src == seed;
            db.lookupPixelFeats(v.id, this.featsB);
            for (int j = 0; j < m.inliers.size; ++j) {
                AssociatedIndex a = (AssociatedIndex)m.inliers.get(j);
                int id = this.seedToStructure.data[seedIsSrc ? a.src : a.dst];
                if (id < 0) continue;
                Point2D_F64 o = (Point2D_F64)this.featsB.get(seedIsSrc ? a.dst : a.src);
                obsView.add(id, (float)o.x, (float)o.y);
            }
        }
        return observations;
    }

    private boolean refineWithBundleAdjustment(SceneObservations observations) {
        if (this.scaleSBA) {
            this.scaler.applyScale(this.structure, observations);
        }
        this.sba.setVerbose(this.verbose, this.verboseLevel);
        this.sba.setParameters((SceneStructure)this.structure, observations);
        this.sba.configure(this.converge.ftol, this.converge.gtol, this.converge.maxIterations);
        if (!this.sba.optimize((SceneStructure)this.structure)) {
            return false;
        }
        if (this.scaleSBA) {
            for (int i = 0; i < this.structure.views.length; ++i) {
                DMatrixRMaj P = this.structure.views[i].worldToView;
                ((NormalizationPoint2D)this.scaler.pixelScaling.get(i)).remove(P, P);
            }
            this.scaler.undoScale(this.structure, observations);
        }
        return true;
    }

    public void setVerbose(PrintStream verbose, int level) {
        this.verbose = verbose;
        this.verboseLevel = level;
    }
}

