/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.sfm.d3.VisOdomPixelDepthPnP;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.sfm.Point2D3DTrack;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;

public class VisOdomPixelDepthPnP_to_DepthVisualOdometry<Vis extends ImageBase<Vis>, Depth extends ImageGray<Depth>>
implements DepthVisualOdometry<Vis, Depth>,
AccessPointTracks3D {
    DepthSparse3D<Depth> sparse3D;
    VisOdomPixelDepthPnP<Vis> alg;
    DistanceFromModelMultiView<Se3_F64, Point2D3D> distance;
    ImageType<Vis> visualType;
    Class<Depth> depthType;
    boolean success;
    List<PointTrack> active = new ArrayList<PointTrack>();

    public VisOdomPixelDepthPnP_to_DepthVisualOdometry(DepthSparse3D<Depth> sparse3D, VisOdomPixelDepthPnP<Vis> alg, DistanceFromModelMultiView<Se3_F64, Point2D3D> distance, ImageType<Vis> visualType, Class<Depth> depthType) {
        this.sparse3D = sparse3D;
        this.alg = alg;
        this.distance = distance;
        this.visualType = visualType;
        this.depthType = depthType;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        try {
            PointTrack t = (PointTrack)this.alg.getTracker().getActiveTracks(null).get(index);
            return ((Point2D3D)t.getCookie()).getLocation();
        }
        catch (IndexOutOfBoundsException e) {
            return new Point3D_F64();
        }
    }

    @Override
    public long getTrackId(int index) {
        return this.active.get((int)index).featureId;
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        return this.active;
    }

    @Override
    public boolean isInlier(int index) {
        Point2D3DTrack t = (Point2D3DTrack)((Object)this.active.get(index).getCookie());
        return t.lastInlier == this.alg.getTick();
    }

    @Override
    public boolean isNew(int index) {
        PointTrack t = (PointTrack)this.alg.getTracker().getActiveTracks(null).get(index);
        return this.alg.getTracker().getNewTracks(null).contains(t);
    }

    @Override
    public void setCalibration(CameraPinholeBrown paramVisual, Point2Transform2_F32 visToDepth) {
        PointToPixelTransform_F32 visToDepth_pixel = new PointToPixelTransform_F32(visToDepth);
        this.sparse3D.configure(LensDistortionFactory.narrow((CameraModel)paramVisual), (PixelTransform<Point2D_F32>)visToDepth_pixel);
        Point2Transform2_F64 leftPixelToNorm = LensDistortionFactory.narrow((CameraModel)paramVisual).undistort_F64(true, false);
        Point2Transform2_F64 leftNormToPixel = LensDistortionFactory.narrow((CameraModel)paramVisual).distort_F64(false, true);
        this.alg.setPixelToNorm(leftPixelToNorm);
        this.alg.setNormToPixel(leftNormToPixel);
        this.distance.setIntrinsic(0, (CameraPinhole)paramVisual);
    }

    @Override
    public boolean process(Vis visual, Depth depth) {
        this.sparse3D.setDepthImage(depth);
        this.success = this.alg.process(visual);
        this.active.clear();
        this.alg.getTracker().getActiveTracks(this.active);
        return this.success;
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return !this.success;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getCurrToWorld();
    }

    @Override
    public ImageType<Vis> getVisualType() {
        return this.visualType;
    }

    @Override
    public Class<Depth> getDepthType() {
        return this.depthType;
    }
}

