/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.abst.geo.RefineThreeViewProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.PruneStructureFromSceneMetric;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.GeometricResult;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.geo.selfcalib.EstimatePlaneAtInfinityGivenK;
import boofcv.alg.geo.selfcalib.SelfCalibrationLinearDualQuadratic;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.ConfigTrifocalError;
import boofcv.factory.geo.EnumTrifocal;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ejml.data.DMatrix4x4;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ThreeViewEstimateMetricScene {
    public ConfigRansac configRansac = new ConfigRansac();
    public ConfigTrifocal configTriRansac = new ConfigTrifocal();
    public ConfigTrifocal configTriFit = new ConfigTrifocal();
    public ConfigTrifocalError configError = new ConfigTrifocalError();
    public ConfigLevenbergMarquardt configLM = new ConfigLevenbergMarquardt();
    public ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
    public ConfigConverge convergeSBA = new ConfigConverge(1.0E-6, 1.0E-6, 100);
    public Ransac<TrifocalTensor, AssociatedTriple> ransac;
    public List<AssociatedTriple> inliers;
    public Estimate1ofTrifocalTensor trifocalEstimator;
    private PrintStream verbose;
    private int verboseLevel;
    protected DMatrixRMaj P1 = CommonOps_DDRM.identity((int)3, (int)4);
    protected DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
    protected DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
    protected List<CameraPinhole> listPinhole = new ArrayList<CameraPinhole>();
    public BundleAdjustment<SceneStructureMetric> bundleAdjustment;
    public SceneStructureMetric structure;
    public SceneObservations observations;
    public double manualFocalLength = -1.0;
    public double pruneFraction = 0.7;
    private int width;
    private int height;
    protected List<Se3_F64> worldToView = new ArrayList<Se3_F64>();

    public ThreeViewEstimateMetricScene() {
        this.configRansac.maxIterations = 500;
        this.configRansac.inlierThreshold = 1.0;
        this.configError.model = ConfigTrifocalError.Model.REPROJECTION_REFINE;
        this.configTriFit.which = EnumTrifocal.ALGEBRAIC_7;
        this.configTriFit.converge.maxIterations = 100;
        this.configLM.dampeningInitial = 0.001;
        this.configLM.hessianScaling = false;
        this.configSBA.configOptimizer = this.configLM;
        for (int i = 0; i < 3; ++i) {
            this.worldToView.add(new Se3_F64());
        }
    }

    public boolean process(List<AssociatedTriple> associated, int width, int height) {
        this.init(width, height);
        if (!this.robustFitTrifocal(associated)) {
            return false;
        }
        if (!this.estimateProjectiveScene()) {
            return false;
        }
        if (!this.projectiveToMetric()) {
            return false;
        }
        this.setupMetricBundleAdjustment(this.inliers);
        this.bundleAdjustment = FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)this.configSBA);
        this.findBestValidSolution(this.bundleAdjustment);
        this.pruneOutliers(this.bundleAdjustment);
        return true;
    }

    private void init(int width, int height) {
        this.width = width;
        this.height = height;
        this.ransac = FactoryMultiViewRobust.trifocalRansac((ConfigTrifocal)this.configTriRansac, (ConfigTrifocalError)this.configError, (ConfigRansac)this.configRansac);
        this.trifocalEstimator = FactoryMultiView.trifocal_1((ConfigTrifocal)this.configTriFit);
        this.structure = null;
        this.observations = null;
    }

    private boolean robustFitTrifocal(List<AssociatedTriple> associated) {
        this.ransac.process(associated);
        this.inliers = this.ransac.getMatchSet();
        TrifocalTensor model = (TrifocalTensor)this.ransac.getModelParameters();
        if (this.verbose != null) {
            this.verbose.println("Remaining after RANSAC " + this.inliers.size() + " / " + associated.size());
        }
        if (!this.trifocalEstimator.process(this.inliers, (Object)model)) {
            if (this.verbose != null) {
                this.verbose.println("Trifocal estimator failed");
            }
            return false;
        }
        return true;
    }

    private void pruneOutliers(BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        if (this.pruneFraction == 1.0) {
            return;
        }
        PruneStructureFromSceneMetric pruner = new PruneStructureFromSceneMetric(this.structure, this.observations);
        pruner.pruneObservationsByErrorRank(this.pruneFraction);
        pruner.pruneViews(10);
        pruner.prunePoints(1);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.verbose != null) {
            int i;
            this.verbose.println("\nCamera");
            for (i = 0; i < this.structure.cameras.size; ++i) {
                this.verbose.println(((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel().toString());
            }
            this.verbose.println("\n\nworldToView");
            for (i = 0; i < this.structure.views.size; ++i) {
                this.verbose.println(((SceneStructureMetric.View[])this.structure.views.data)[i].worldToView.toString());
            }
            this.verbose.println("Fit Score: " + bundleAdjustment.getFitScore());
        }
    }

    private void findBestValidSolution(BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        BundlePinholeSimplified c;
        int i;
        if (this.verbose != null && this.verboseLevel > 0) {
            bundleAdjustment.setVerbose(this.verbose, 0);
        }
        bundleAdjustment.configure(this.convergeSBA.ftol, this.convergeSBA.gtol, this.convergeSBA.maxIterations);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.checkBehindCamera(this.structure)) {
            if (this.verbose != null) {
                this.verbose.println("  flipping view");
            }
            ThreeViewEstimateMetricScene.flipAround(this.structure, this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
        }
        double bestScore = bundleAdjustment.getFitScore();
        ArrayList<Se3_F64> bestPose = new ArrayList<Se3_F64>();
        ArrayList<BundlePinholeSimplified> bestCameras = new ArrayList<BundlePinholeSimplified>();
        for (i = 0; i < this.structure.views.size; ++i) {
            c = (BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel();
            bestPose.add(((SceneStructureMetric.View[])this.structure.views.data)[i].worldToView.copy());
            bestCameras.add(c.copy());
        }
        for (i = 0; i < this.structure.cameras.size; ++i) {
            c = (BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel();
            c.f = this.listPinhole.get((int)i).fx;
            c.k2 = 0.0;
            c.k1 = 0.0;
        }
        for (i = 1; i < this.structure.views.size; ++i) {
            CommonOps_DDRM.transpose((DMatrixRMaj)((SceneStructureMetric.View[])this.structure.views.data)[i].worldToView.R);
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.checkBehindCamera(this.structure)) {
            if (this.verbose != null) {
                this.verbose.println("  flipping view");
            }
            ThreeViewEstimateMetricScene.flipAround(this.structure, this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
        }
        if (this.verbose != null) {
            this.verbose.println(" ORIGINAL / NEW = " + bestScore + " / " + bundleAdjustment.getFitScore());
        }
        if (bundleAdjustment.getFitScore() > bestScore) {
            if (this.verbose != null) {
                this.verbose.println("  recomputing old structure");
            }
            for (i = 0; i < this.structure.cameras.size; ++i) {
                c = (BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel();
                c.set((BundlePinholeSimplified)bestCameras.get(i));
                ((SceneStructureMetric.View[])this.structure.views.data)[i].worldToView.set((Se3_F64)bestPose.get(i));
            }
            MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
            if (this.verbose != null) {
                this.verbose.println("  score = " + bundleAdjustment.getFitScore());
            }
        }
    }

    private boolean estimateProjectiveScene() {
        List inliers = this.ransac.getMatchSet();
        TrifocalTensor model = (TrifocalTensor)this.ransac.getModelParameters();
        MultiViewOps.extractCameraMatrices((TrifocalTensor)model, (DMatrixRMaj)this.P2, (DMatrixRMaj)this.P3);
        RefineThreeViewProjective refineP23 = FactoryMultiView.threeViewRefine(null);
        if (!refineP23.process(inliers, this.P2, this.P3, this.P2, this.P3)) {
            if (this.verbose != null) {
                this.verbose.println("Can't refine P2 and P3!");
            }
            return false;
        }
        return true;
    }

    private void setupMetricBundleAdjustment(List<AssociatedTriple> inliers) {
        int i;
        this.structure = new SceneStructureMetric(false);
        this.observations = new SceneObservations(3);
        this.structure.initialize(3, 3, inliers.size());
        for (i = 0; i < this.listPinhole.size(); ++i) {
            CameraPinhole cp = this.listPinhole.get(i);
            BundlePinholeSimplified bp = new BundlePinholeSimplified();
            bp.f = cp.fx;
            this.structure.setCamera(i, false, (BundleAdjustmentCamera)bp);
            this.structure.setView(i, i == 0, this.worldToView.get(i));
            this.structure.connectViewToCamera(i, i);
        }
        for (i = 0; i < inliers.size(); ++i) {
            AssociatedTriple t = inliers.get(i);
            this.observations.getView(0).add(i, (float)t.p1.x, (float)t.p1.y);
            this.observations.getView(1).add(i, (float)t.p2.x, (float)t.p2.y);
            this.observations.getView(2).add(i, (float)t.p3.x, (float)t.p3.y);
            this.structure.connectPointToView(i, 0);
            this.structure.connectPointToView(i, 1);
            this.structure.connectPointToView(i, 2);
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
    }

    boolean projectiveToMetric() {
        DMatrixRMaj H = new DMatrixRMaj(4, 4);
        this.listPinhole.clear();
        if (this.manualFocalLength <= 0.0) {
            int i;
            SelfCalibrationLinearDualQuadratic selfcalib = new SelfCalibrationLinearDualQuadratic(1.0);
            selfcalib.addCameraMatrix(this.P1);
            selfcalib.addCameraMatrix(this.P2);
            selfcalib.addCameraMatrix(this.P3);
            GeometricResult result = selfcalib.solve();
            if (GeometricResult.SOLVE_FAILED != result && selfcalib.getSolutions().size() == 3) {
                for (i = 0; i < 3; ++i) {
                    SelfCalibrationLinearDualQuadratic.Intrinsic c = (SelfCalibrationLinearDualQuadratic.Intrinsic)selfcalib.getSolutions().get(i);
                    CameraPinhole cameraPinhole = new CameraPinhole(c.fx, c.fy, 0.0, 0.0, 0.0, this.width, this.height);
                    this.listPinhole.add(cameraPinhole);
                }
            } else {
                System.out.println("Self calibration failed!");
                for (i = 0; i < 3; ++i) {
                    CameraPinhole p2 = new CameraPinhole((double)(this.width / 2), (double)(this.width / 2), 0.0, 0.0, 0.0, this.width, this.height);
                    this.listPinhole.add(p2);
                }
            }
            if (!MultiViewOps.absoluteQuadraticToH((DMatrix4x4)selfcalib.getQ(), (DMatrixRMaj)H)) {
                if (this.verbose != null) {
                    this.verbose.println("Projective to metric failed");
                }
                return false;
            }
        } else {
            EstimatePlaneAtInfinityGivenK estimateV = new EstimatePlaneAtInfinityGivenK();
            estimateV.setCamera1(this.manualFocalLength, this.manualFocalLength, 0.0, 0.0, 0.0);
            estimateV.setCamera2(this.manualFocalLength, this.manualFocalLength, 0.0, 0.0, 0.0);
            Vector3D_F64 v = new Vector3D_F64();
            if (!estimateV.estimatePlaneAtInfinity(this.P2, v)) {
                throw new RuntimeException("Failed!");
            }
            DMatrixRMaj K = PerspectiveOps.pinholeToMatrix((double)this.manualFocalLength, (double)this.manualFocalLength, (double)0.0, (double)0.0, (double)0.0);
            MultiViewOps.createProjectiveToMetric((DMatrixRMaj)K, (double)v.x, (double)v.y, (double)v.z, (double)1.0, (DMatrixRMaj)H);
            for (int i = 0; i < 3; ++i) {
                CameraPinhole cameraPinhole = new CameraPinhole(this.manualFocalLength, this.manualFocalLength, 0.0, 0.0, 0.0, this.width, this.height);
                this.listPinhole.add(cameraPinhole);
            }
        }
        if (this.verbose != null) {
            for (int i = 0; i < 3; ++i) {
                CameraPinhole r = this.listPinhole.get(i);
                this.verbose.println("fx=" + r.fx + " fy=" + r.fy + " skew=" + r.skew);
            }
            this.verbose.println("Projective to metric");
        }
        DMatrixRMaj K = new DMatrixRMaj(3, 3);
        MultiViewOps.projectiveToMetric((DMatrixRMaj)this.P1, (DMatrixRMaj)H, (Se3_F64)this.worldToView.get(0), (DMatrixRMaj)K);
        MultiViewOps.projectiveToMetric((DMatrixRMaj)this.P2, (DMatrixRMaj)H, (Se3_F64)this.worldToView.get(1), (DMatrixRMaj)K);
        MultiViewOps.projectiveToMetric((DMatrixRMaj)this.P3, (DMatrixRMaj)H, (Se3_F64)this.worldToView.get(2), (DMatrixRMaj)K);
        double maxT = 0.0;
        for (Se3_F64 se3_F64 : this.worldToView) {
            maxT = Math.max(maxT, se3_F64.T.norm());
        }
        for (Se3_F64 se3_F64 : this.worldToView) {
            se3_F64.T.scale(1.0 / maxT);
            if (this.verbose == null) continue;
            this.verbose.println(se3_F64);
        }
        return true;
    }

    private boolean checkBehindCamera(SceneStructureMetric structure) {
        int totalBehind = 0;
        Point3D_F64 X = new Point3D_F64();
        for (int i = 0; i < structure.points.size; ++i) {
            ((SceneStructureCommon.Point[])structure.points.data)[i].get(X);
            if (!(X.z < 0.0)) continue;
            ++totalBehind;
        }
        if (this.verbose != null) {
            this.verbose.println("points behind " + totalBehind + " / " + structure.points.size);
        }
        return totalBehind > structure.points.size / 2;
    }

    private static void flipAround(SceneStructureMetric structure, SceneObservations observations) {
        for (int i = 1; i < structure.views.size; ++i) {
            Se3_F64 w2v = ((SceneStructureMetric.View[])structure.views.data)[i].worldToView;
            w2v.set(w2v.invert(null));
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)structure, (SceneObservations)observations);
    }

    public void setVerbose(PrintStream verbose, int level) {
        this.verbose = verbose;
        this.verboseLevel = level;
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }
}

