/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public abstract class DepthSparse3D<T extends ImageGray<T>> {
    protected T depthImage;
    private Point2Transform2_F64 p2n;
    private Point3D_F64 worldPt = new Point3D_F64();
    private Point2D_F64 norm = new Point2D_F64();
    private PixelTransform<Point2D_F32> visualToDepth;
    private Point2D_F32 distorted = new Point2D_F32();
    private double depthScale;

    public DepthSparse3D(double depthScale) {
        this.depthScale = depthScale;
    }

    public void configure(LensDistortionNarrowFOV model, PixelTransform<Point2D_F32> visualToDepth) {
        this.visualToDepth = visualToDepth;
        this.p2n = model.undistort_F64(true, false);
    }

    public void setDepthImage(T depthImage) {
        this.depthImage = depthImage;
    }

    public boolean process(int x, int y) {
        this.visualToDepth.compute(x, y, (Object)this.distorted);
        int depthX = (int)this.distorted.x;
        int depthY = (int)this.distorted.y;
        if (this.depthImage.isInBounds(depthX, depthY)) {
            double value = this.lookupDepth(depthX, depthY);
            if (value == 0.0) {
                return false;
            }
            this.p2n.compute((double)x, (double)y, this.norm);
            this.worldPt.z = value * this.depthScale;
            this.worldPt.x = this.worldPt.z * this.norm.x;
            this.worldPt.y = this.worldPt.z * this.norm.y;
            return true;
        }
        return false;
    }

    public Point3D_F64 getWorldPt() {
        return this.worldPt;
    }

    protected abstract double lookupDepth(int var1, int var2);

    public static class F32
    extends DepthSparse3D<GrayF32> {
        public F32(double depthScale) {
            super(depthScale);
        }

        @Override
        protected double lookupDepth(int depthX, int depthY) {
            return ((GrayF32)this.depthImage).unsafe_get(depthX, depthY);
        }
    }

    public static class I<T extends GrayI<T>>
    extends DepthSparse3D<T> {
        public I(double depthScale) {
            super(depthScale);
        }

        @Override
        protected double lookupDepth(int depthX, int depthY) {
            return ((GrayI)this.depthImage).unsafe_get(depthX, depthY);
        }
    }
}

