/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ddogleg.struct.VerbosePrint;

public class VisOdomStereoQuadPnP<T extends ImageGray<T>, TD extends TupleDesc>
implements VerbosePrint {
    private final Triangulate2ViewsMetric triangulate;
    private final TriangulateNViewsMetric triangulateN;
    private final ModelMatcher<Se3_F64, Stereo2D3D> matcher;
    private final ModelFitter<Se3_F64, Stereo2D3D> modelRefiner;
    private final FastQueue<Stereo2D3D> modelFitData = new FastQueue(10, Stereo2D3D::new);
    private final BundleAdjustment<SceneStructureMetric> bundleAdjustment;
    private final SceneStructureMetric bundleScene = new SceneStructureMetric(false);
    private final SceneObservations bundleObservations = new SceneObservations();
    private final ConfigConverge bundleConverge = new ConfigConverge(1.0E-5, 1.0E-5, 4);
    private final DetectDescribePoint<T, TD> detector;
    private final AssociateDescription<TD> assocF2F;
    private final AssociateDescription2D<TD> assocL2R;
    private final FastQueue<TrackQuad> trackQuads = new FastQueue(TrackQuad::new, TrackQuad::reset);
    private ImageInfo<TD> featsLeft0;
    private ImageInfo<TD> featsLeft1;
    private ImageInfo<TD> featsRight0;
    private ImageInfo<TD> featsRight1;
    private final SetMatches[] setMatches;
    private final Se3_F64 left_to_right = new Se3_F64();
    private final Se3_F64 right_to_left = new Se3_F64();
    private final StereoParameters stereoParameters = new StereoParameters();
    private Point2Transform2_F64 leftPixelToNorm;
    private Point2Transform2_F64 rightPixelToNorm;
    private final Se3_F64 curr_to_key = new Se3_F64();
    private final Se3_F64 left_to_world = new Se3_F64();
    private long frameID = -1L;
    private long totalTracks;
    private final GrowQueue_I32 keyToTrackIdx = new GrowQueue_I32();
    protected PrintStream profileOut;
    protected PrintStream verbose;
    private final Se3_F64 prevLeft_to_world = new Se3_F64();
    private final Point2D_F64 normLeft = new Point2D_F64();
    private final Point2D_F64 normRight = new Point2D_F64();
    private final Point3D_F64 X = new Point3D_F64();
    private final FastQueue<Point2D_F64> listNorm = new FastQueue(Point2D_F64::new);
    private final FastQueue<Se3_F64> listWorldToView = new FastQueue(Se3_F64::new);
    private final List<TrackQuad> inliers = new ArrayList<TrackQuad>();
    private final List<TrackQuad> consistentTracks = new ArrayList<TrackQuad>();
    private final Se3_F64 found = new Se3_F64();

    public VisOdomStereoQuadPnP(DetectDescribePoint<T, TD> detector, AssociateDescription<TD> assocF2F, AssociateDescription2D<TD> assocL2R, Triangulate2ViewsMetric triangulate, ModelMatcher<Se3_F64, Stereo2D3D> matcher, ModelFitter<Se3_F64, Stereo2D3D> modelRefiner, BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        this.detector = detector;
        this.assocF2F = assocF2F;
        this.assocL2R = assocL2R;
        this.triangulate = triangulate;
        this.matcher = matcher;
        this.modelRefiner = modelRefiner;
        this.bundleAdjustment = bundleAdjustment;
        this.triangulateN = FactoryMultiView.triangulateNViewCalibrated((ConfigTriangulation)ConfigTriangulation.GEOMETRIC());
        this.setMatches = new SetMatches[1];
        for (int i = 0; i < this.setMatches.length; ++i) {
            this.setMatches[i] = new SetMatches();
        }
        this.featsLeft0 = new ImageInfo(detector);
        this.featsLeft1 = new ImageInfo(detector);
        this.featsRight0 = new ImageInfo(detector);
        this.featsRight1 = new ImageInfo(detector);
        this.listNorm.resize(4);
        this.listWorldToView.resize(4);
    }

    public void setCalibration(StereoParameters param) {
        this.stereoParameters.set(param);
        this.right_to_left.set(param.rightToLeft);
        this.right_to_left.invert(this.left_to_right);
        this.leftPixelToNorm = LensDistortionFactory.narrow((CameraModel)param.left).undistort_F64(true, false);
        this.rightPixelToNorm = LensDistortionFactory.narrow((CameraModel)param.right).undistort_F64(true, false);
    }

    public void reset() {
        this.featsLeft0.reset();
        this.featsLeft1.reset();
        this.featsRight0.reset();
        this.featsRight1.reset();
        for (SetMatches m : this.setMatches) {
            m.reset();
        }
        this.curr_to_key.reset();
        this.left_to_world.reset();
        this.frameID = -1L;
        this.totalTracks = 0L;
        this.trackQuads.reset();
    }

    public boolean process(T left, T right) {
        ++this.frameID;
        long time0 = System.nanoTime();
        this.detectFeatures(left, right);
        long time1 = System.nanoTime();
        this.associateL2R();
        if (this.frameID == 0L) {
            if (this.verbose != null) {
                this.verbose.println("first frame");
            }
            this.keyToTrackIdx.resize(this.featsLeft1.location[0].size);
            this.keyToTrackIdx.fill(-1);
        } else {
            long time2 = System.nanoTime();
            this.associateF2F();
            long time3 = System.nanoTime();
            this.cyclicConsistency();
            this.putConsistentTracksIntoList();
            long time4 = System.nanoTime();
            if (!this.robustMotionEstimate()) {
                if (this.verbose != null) {
                    this.verbose.println("Failed to estimate motion");
                }
                this.abortTrackingResetKeyFrame();
                return false;
            }
            Se3_F64 key_to_curr = (Se3_F64)this.matcher.getModelParameters();
            this.refineMotionEstimate(key_to_curr);
            this.triangulateWithFourCameras(key_to_curr);
            long time5 = System.nanoTime();
            this.performBundleAdjustment(key_to_curr);
            long time6 = System.nanoTime();
            this.performTrackMaintenance(key_to_curr);
            key_to_curr.invert(this.curr_to_key);
            this.prevLeft_to_world.set(this.left_to_world);
            this.curr_to_key.concat(this.prevLeft_to_world, this.left_to_world);
            long time7 = System.nanoTime();
            if (this.profileOut != null) {
                double milliDet = (double)(time1 - time0) * 1.0E-6;
                double milliL2R = (double)(time2 - time1) * 1.0E-6;
                double milliF2F = (double)(time3 - time2) * 1.0E-6;
                double milliCyc = (double)(time4 - time3) * 1.0E-6;
                double milliEst = (double)(time5 - time4) * 1.0E-6;
                double milliBun = (double)(time6 - time5) * 1.0E-6;
                double milliMnt = (double)(time7 - time6) * 1.0E-6;
                this.profileOut.printf("TIME: Det %5.1f L2R %5.1f F2F %5.1f Cyc %5.1f Est %5.1f Bun %5.1f Mnt %5.1f Total: %5.1f\n", milliDet, milliL2R, milliF2F, milliCyc, milliEst, milliBun, milliMnt, (double)(time7 - time0) * 1.0E-6);
            }
        }
        if (this.verbose != null) {
            int leftDetections = this.featsLeft1.location[0].size;
            int inliers = this.matcher.getMatchSet().size();
            int matchesL2R = this.assocL2R.getMatches().size;
            this.verbose.printf("Viso: Det: %4d L2R: %4d, Quad: %4d Inliers: %d\n", leftDetections, matchesL2R, this.trackQuads.size, inliers);
        }
        return true;
    }

    private void abortTrackingResetKeyFrame() {
        this.swapFeatureFrames();
        for (int i = 0; i < 1; ++i) {
            SetMatches matches = this.setMatches[i];
            matches.swap();
        }
    }

    private void putConsistentTracksIntoList() {
        this.consistentTracks.clear();
        for (int i = 0; i < this.trackQuads.size; ++i) {
            if (((TrackQuad)this.trackQuads.get((int)i)).leftCurrIndex == -1) continue;
            this.consistentTracks.add((TrackQuad)this.trackQuads.get(i));
        }
    }

    private void triangulateWithFourCameras(Se3_F64 key_to_curr) {
        ((Se3_F64)this.listWorldToView.get(0)).reset();
        ((Se3_F64)this.listWorldToView.get(1)).set(this.left_to_right);
        ((Se3_F64)this.listWorldToView.get(2)).set(key_to_curr);
        key_to_curr.concat(this.left_to_right, (Se3_F64)this.listWorldToView.get(3));
        for (int quadIdx = 0; quadIdx < this.consistentTracks.size(); ++quadIdx) {
            TrackQuad q = this.consistentTracks.get(quadIdx);
            this.leftPixelToNorm.compute(q.v0.x, q.v0.y, (Point2D_F64)this.listNorm.get(0));
            this.rightPixelToNorm.compute(q.v1.x, q.v1.y, (Point2D_F64)this.listNorm.get(1));
            this.leftPixelToNorm.compute(q.v2.x, q.v2.y, (Point2D_F64)this.listNorm.get(2));
            this.rightPixelToNorm.compute(q.v3.x, q.v3.y, (Point2D_F64)this.listNorm.get(3));
            if (!this.triangulateN.triangulate(this.listNorm.toList(), this.listWorldToView.toList(), this.X)) {
                q.leftCurrIndex = -1;
                continue;
            }
            if (this.X.z <= 0.0) {
                q.leftCurrIndex = -1;
                continue;
            }
            q.X.set(this.X);
        }
    }

    private void performTrackMaintenance(Se3_F64 key_to_curr) {
        TrackQuad quad;
        int quadIdx;
        for (quadIdx = this.trackQuads.size - 1; quadIdx >= 0; --quadIdx) {
            quad = (TrackQuad)this.trackQuads.get(quadIdx);
            if (quad.leftCurrIndex == -1) {
                this.trackQuads.removeSwap(quadIdx);
                continue;
            }
            SePointOps_F64.transform((Se3_F64)key_to_curr, (Point3D_F64)quad.X, (Point3D_F64)quad.X);
            if (!(quad.X.z <= 0.0)) continue;
            this.trackQuads.removeSwap(quadIdx);
        }
        this.keyToTrackIdx.resize(this.featsLeft1.location[0].size);
        this.keyToTrackIdx.fill(-1);
        quadIdx = 0;
        while (quadIdx < this.trackQuads.size) {
            quad = (TrackQuad)this.trackQuads.get(quadIdx);
            this.keyToTrackIdx.data[quad.leftCurrIndex] = quadIdx++;
        }
    }

    private void detectFeatures(T left, T right) {
        this.swapFeatureFrames();
        this.featsLeft1.reset();
        this.featsRight1.reset();
        this.describeImage(left, this.featsLeft1);
        this.describeImage(right, this.featsRight1);
    }

    private void swapFeatureFrames() {
        ImageInfo<TD> tmp = this.featsLeft1;
        this.featsLeft1 = this.featsLeft0;
        this.featsLeft0 = tmp;
        tmp = this.featsRight1;
        this.featsRight1 = this.featsRight0;
        this.featsRight0 = tmp;
    }

    private void associateL2R() {
        for (int i = 0; i < 1; ++i) {
            SetMatches matches = this.setMatches[i];
            matches.swap();
            matches.match2to3.reset();
            FastQueue<Point2D_F64> leftLoc = this.featsLeft1.location[i];
            FastQueue<Point2D_F64> rightLoc = this.featsRight1.location[i];
            this.assocL2R.setSource(leftLoc, this.featsLeft1.description[i]);
            this.assocL2R.setDestination(rightLoc, this.featsRight1.description[i]);
            this.assocL2R.associate();
            FastAccess found = this.assocL2R.getMatches();
            this.setMatches(matches.match2to3, (FastAccess<AssociatedIndex>)found, leftLoc.size);
        }
    }

    private void associateF2F() {
        for (int i = 0; i < 1; ++i) {
            SetMatches matches = this.setMatches[i];
            this.assocF2F.setSource(this.featsLeft0.description[i]);
            this.assocF2F.setDestination(this.featsLeft1.description[i]);
            this.assocF2F.associate();
            this.setMatches(matches.match0to2, (FastAccess<AssociatedIndex>)this.assocF2F.getMatches(), this.featsLeft0.location[i].size);
            this.assocF2F.setSource(this.featsRight0.description[i]);
            this.assocF2F.setDestination(this.featsRight1.description[i]);
            this.assocF2F.associate();
            this.setMatches(matches.match1to3, (FastAccess<AssociatedIndex>)this.assocF2F.getMatches(), this.featsRight0.location[i].size);
        }
    }

    private void cyclicConsistency() {
        for (int i = 0; i < this.trackQuads.size; ++i) {
            ((TrackQuad)this.trackQuads.get((int)i)).leftCurrIndex = -1;
        }
        for (int setIdx = 0; setIdx < 1; ++setIdx) {
            FastQueue<Point2D_F64> obs0 = this.featsLeft0.location[setIdx];
            FastQueue<Point2D_F64> obs1 = this.featsRight0.location[setIdx];
            FastQueue<Point2D_F64> obs2 = this.featsLeft1.location[setIdx];
            FastQueue<Point2D_F64> obs3 = this.featsRight1.location[setIdx];
            SetMatches matches = this.setMatches[setIdx];
            if (matches.match0to1.size != matches.match0to2.size) {
                throw new RuntimeException("Failed sanity check");
            }
            for (int indexIn0 = 0; indexIn0 < matches.match0to1.size; ++indexIn0) {
                TrackQuad quad;
                int indexIn1 = matches.match0to1.data[indexIn0];
                int indexIn2 = matches.match0to2.data[indexIn0];
                if (indexIn1 < 0 || indexIn2 < 0) continue;
                int indexIn3a = matches.match1to3.data[indexIn1];
                int indexIn3b = matches.match2to3.data[indexIn2];
                if (indexIn3a < 0 || indexIn3b < 0 || indexIn3a != indexIn3b) continue;
                int trackIdx = this.keyToTrackIdx.get(indexIn0);
                if (trackIdx == -1) {
                    quad = (TrackQuad)this.trackQuads.grow();
                    ++this.totalTracks;
                    quad.id = quad.id;
                    quad.firstSceneFrameID = this.frameID;
                } else {
                    quad = (TrackQuad)this.trackQuads.get(trackIdx);
                    quad.inlier = false;
                }
                quad.v0 = (Point2D_F64)obs0.get(indexIn0);
                quad.v1 = (Point2D_F64)obs1.get(indexIn1);
                quad.v2 = (Point2D_F64)obs2.get(indexIn2);
                quad.v3 = (Point2D_F64)obs3.get(indexIn3a);
                if (trackIdx == -1 && !this.triangulateTrackTwoViews(quad)) continue;
                quad.leftCurrIndex = indexIn2;
            }
        }
    }

    private boolean triangulateTrackTwoViews(TrackQuad quad) {
        this.leftPixelToNorm.compute(quad.v0.x, quad.v0.y, this.normLeft);
        this.rightPixelToNorm.compute(quad.v1.x, quad.v1.y, this.normRight);
        boolean success = this.triangulate.triangulate(this.normLeft, this.normRight, this.left_to_right, quad.X);
        success &= !Double.isInfinite(quad.X.normSq());
        if (!(success &= quad.X.z > 0.0)) {
            this.trackQuads.removeTail();
            return false;
        }
        return true;
    }

    private void setMatches(GrowQueue_I32 matches, FastAccess<AssociatedIndex> found, int sizeSrc) {
        int j;
        matches.resize(sizeSrc);
        for (j = 0; j < sizeSrc; ++j) {
            matches.data[j] = -1;
        }
        for (j = 0; j < found.size; ++j) {
            AssociatedIndex a = (AssociatedIndex)found.get(j);
            matches.data[a.src] = a.dst;
        }
    }

    private void describeImage(T image, ImageInfo<TD> info) {
        this.detector.detect(image);
        FastQueue<Point2D_F64> l = info.location[0];
        FastQueue d = info.description[0];
        l.reset();
        d.reset();
        for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
            ((Point2D_F64)l.grow()).set(this.detector.getLocation(i));
            ((TupleDesc)d.grow()).setTo(this.detector.getDescription(i));
        }
    }

    private boolean robustMotionEstimate() {
        this.modelFitData.reset();
        for (int i = 0; i < this.consistentTracks.size(); ++i) {
            TrackQuad quad = this.consistentTracks.get(i);
            Stereo2D3D data = (Stereo2D3D)this.modelFitData.grow();
            this.leftPixelToNorm.compute(quad.v2.x, quad.v2.y, data.leftObs);
            this.rightPixelToNorm.compute(quad.v3.x, quad.v3.y, data.rightObs);
            data.location.set(quad.X);
        }
        if (!this.matcher.process(this.modelFitData.toList())) {
            return false;
        }
        int numInliers = this.matcher.getMatchSet().size();
        for (int i = 0; i < numInliers; ++i) {
            this.consistentTracks.get((int)this.matcher.getInputIndex((int)i)).inlier = true;
        }
        return true;
    }

    private void refineMotionEstimate(Se3_F64 key_to_curr) {
        if (this.modelRefiner != null && this.modelRefiner.fitModel(this.matcher.getMatchSet(), (Object)key_to_curr, (Object)this.found)) {
            key_to_curr.set(this.found);
        }
    }

    private void performBundleAdjustment(Se3_F64 key_to_curr) {
        TrackQuad t;
        int trackIdx;
        if (this.bundleConverge.maxIterations <= 0) {
            return;
        }
        this.inliers.clear();
        for (trackIdx = 0; trackIdx < this.consistentTracks.size(); ++trackIdx) {
            t = this.consistentTracks.get(trackIdx);
            if (t.leftCurrIndex == -1 || !t.inlier) continue;
            this.inliers.add(t);
        }
        this.bundleObservations.initialize(4);
        this.bundleScene.initialize(2, 4, this.inliers.size());
        this.bundleScene.setCamera(0, true, this.stereoParameters.left);
        this.bundleScene.setCamera(1, true, this.stereoParameters.right);
        this.bundleScene.setView(0, true, (Se3_F64)this.listWorldToView.get(0));
        this.bundleScene.setView(1, true, (Se3_F64)this.listWorldToView.get(1));
        this.bundleScene.setView(2, false, (Se3_F64)this.listWorldToView.get(2));
        this.bundleScene.setView(3, false, (Se3_F64)this.listWorldToView.get(3));
        this.bundleScene.connectViewToCamera(0, 0);
        this.bundleScene.connectViewToCamera(1, 1);
        this.bundleScene.connectViewToCamera(2, 0);
        this.bundleScene.connectViewToCamera(3, 1);
        for (trackIdx = 0; trackIdx < this.inliers.size(); ++trackIdx) {
            t = this.inliers.get(trackIdx);
            Point3D_F64 X = t.X;
            this.bundleScene.setPoint(trackIdx, X.x, X.y, X.z);
            this.bundleObservations.getView(0).add(trackIdx, (float)t.v0.x, (float)t.v0.y);
            this.bundleObservations.getView(1).add(trackIdx, (float)t.v1.x, (float)t.v1.y);
            this.bundleObservations.getView(2).add(trackIdx, (float)t.v2.x, (float)t.v2.y);
            this.bundleObservations.getView(3).add(trackIdx, (float)t.v3.x, (float)t.v3.y);
        }
        this.bundleAdjustment.setParameters((SceneStructure)this.bundleScene, this.bundleObservations);
        double scoreBefore = this.bundleAdjustment.getFitScore();
        this.bundleAdjustment.configure(this.bundleConverge.ftol, this.bundleConverge.gtol, this.bundleConverge.maxIterations);
        if (!this.bundleAdjustment.optimize((SceneStructure)this.bundleScene)) {
            return;
        }
        if (this.verbose != null) {
            this.verbose.printf("Bundle: Reduced score by %.2f with tracks %d\n", scoreBefore / (1.0E-16 + this.bundleAdjustment.getFitScore()), this.bundleScene.points.size);
        }
        for (int trackIdx2 = 0; trackIdx2 < this.inliers.size(); ++trackIdx2) {
            TrackQuad t2 = this.inliers.get(trackIdx2);
            ((SceneStructureCommon.Point)this.bundleScene.points.get(trackIdx2)).get(t2.X);
        }
        key_to_curr.set(((SceneStructureMetric.View)this.bundleScene.views.get((int)2)).worldToView);
    }

    public Se3_F64 getLeftToWorld() {
        return this.left_to_world;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        if (configuration == null) {
            this.verbose = out;
            return;
        }
        if (configuration.contains("runtime")) {
            this.profileOut = out;
        }
        if (configuration.contains("tracking")) {
            this.verbose = out;
        }
    }

    public ModelMatcher<Se3_F64, Stereo2D3D> getMatcher() {
        return this.matcher;
    }

    public ConfigConverge getBundleConverge() {
        return this.bundleConverge;
    }

    public FastQueue<TrackQuad> getTrackQuads() {
        return this.trackQuads;
    }

    public long getFrameID() {
        return this.frameID;
    }

    public PrintStream getProfileOut() {
        return this.profileOut;
    }

    public void setProfileOut(PrintStream profileOut) {
        this.profileOut = profileOut;
    }

    public PrintStream getVerbose() {
        return this.verbose;
    }

    public static class TrackQuad {
        public long id;
        public int leftCurrIndex;
        public long firstSceneFrameID;
        public Point3D_F64 X = new Point3D_F64();
        public Point2D_F64 v0;
        public Point2D_F64 v1;
        public Point2D_F64 v2;
        public Point2D_F64 v3;
        public boolean inlier;

        public void reset() {
            this.X.set(0.0, 0.0, 0.0);
            this.v3 = null;
            this.v2 = null;
            this.v1 = null;
            this.v0 = null;
            this.inlier = false;
            this.id = -1L;
            this.leftCurrIndex = -1;
            this.firstSceneFrameID = -1L;
        }
    }

    public static class SetMatches {
        GrowQueue_I32 match0to1 = new GrowQueue_I32(10);
        GrowQueue_I32 match0to2 = new GrowQueue_I32(10);
        GrowQueue_I32 match2to3 = new GrowQueue_I32(10);
        GrowQueue_I32 match1to3 = new GrowQueue_I32(10);

        public void swap() {
            GrowQueue_I32 tmp = this.match2to3;
            this.match2to3 = this.match0to1;
            this.match0to1 = tmp;
        }

        public void reset() {
            this.match0to1.reset();
            this.match0to2.reset();
            this.match2to3.reset();
            this.match1to3.reset();
        }
    }

    public static class ImageInfo<TD> {
        FastQueue<Point2D_F64>[] location = new FastQueue[1];
        FastQueue<TD>[] description = new FastQueue[1];

        public ImageInfo(DetectDescribePoint detector) {
            for (int i = 0; i < this.location.length; ++i) {
                this.location[i] = new FastQueue(100, Point2D_F64::new);
                this.description[i] = UtilFeature.createQueue((DescriptorInfo)detector, (int)100);
            }
        }

        public void reset() {
            for (int i = 0; i < this.location.length; ++i) {
                this.location[i].reset();
                this.description[i].reset();
            }
        }
    }
}

