/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.alg.geo.robust.GenerateAffine2D;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.sfm.ScaleTranslateRotate2D;
import georegression.struct.affine.Affine2D_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class GenerateScaleTranslateRotate2D
implements ModelGenerator<ScaleTranslateRotate2D, AssociatedPair> {
    private Affine2D_F64 affine = new Affine2D_F64();
    private GenerateAffine2D generateAffine = new GenerateAffine2D();
    private DMatrixRMaj R = new DMatrixRMaj(2, 2);
    private DMatrixRMaj U = new DMatrixRMaj(2, 2);
    private DMatrixRMaj V = new DMatrixRMaj(2, 2);
    private SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((int)2, (int)2, (boolean)true, (boolean)true, (boolean)true);

    public boolean generate(List<AssociatedPair> dataSet, ScaleTranslateRotate2D output) {
        if (!this.generateAffine.generate(dataSet, this.affine)) {
            return false;
        }
        this.R.data[0] = this.affine.a11;
        this.R.data[1] = this.affine.a12;
        this.R.data[2] = this.affine.a21;
        this.R.data[3] = this.affine.a22;
        if (!this.svd.decompose((Matrix)this.R)) {
            return false;
        }
        double[] sv = this.svd.getSingularValues();
        output.scale = (sv[0] + sv[1]) / 2.0;
        if (output.scale < 0.0) {
            throw new RuntimeException("Handle this case");
        }
        this.svd.getU((Matrix)this.U, false);
        this.svd.getV((Matrix)this.V, false);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.U, (DMatrix1Row)this.V, (DMatrix1Row)this.R);
        if (CommonOps_DDRM.det((DMatrixRMaj)this.R) < 0.0) {
            for (int i = 0; i < 2; ++i) {
                this.V.set(i, 1, -this.V.get(i, 1));
            }
            CommonOps_DDRM.mult((DMatrix1Row)this.U, (DMatrix1Row)this.V, (DMatrix1Row)this.R);
        }
        output.theta = Math.atan2(-this.R.data[1], this.R.data[0]);
        output.transX = this.affine.tx;
        output.transY = this.affine.ty;
        return true;
    }

    public int getMinimumPoints() {
        return 3;
    }
}

