/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure2;

import boofcv.alg.sfm.structure2.LookupSimilarImages;
import boofcv.alg.sfm.structure2.PairwiseImageGraph2;
import boofcv.factory.geo.ConfigFundamental;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.ops.ConvertDMatrixStruct;

public class GeneratePairwiseImageGraph {
    public PairwiseImageGraph2 graph = new PairwiseImageGraph2();
    private List<String> imageIds;
    ModelMatcher<DMatrixRMaj, AssociatedPair> ransac3D;
    ModelMatcher<Homography2D_F64, AssociatedPair> ransacH;
    public int minimumInliers = 30;
    public double ratio3D = 1.5;

    public GeneratePairwiseImageGraph() {
        ConfigRansac configRansacF = new ConfigRansac();
        configRansacF.iterations = 500;
        configRansacF.inlierThreshold = 1.0;
        ConfigRansac configRansacH = new ConfigRansac();
        configRansacH.iterations = 500;
        configRansacH.inlierThreshold = 2.0;
        ConfigFundamental configF = new ConfigFundamental();
        configF.errorModel = ConfigFundamental.ErrorModel.GEOMETRIC;
        configF.numResolve = 1;
        this.ransac3D = FactoryMultiViewRobust.fundamentalRansac((ConfigFundamental)configF, (ConfigRansac)configRansacF);
        this.ransacH = FactoryMultiViewRobust.homographyRansac(null, (ConfigRansac)configRansacH);
    }

    public void process(LookupSimilarImages db) {
        int idxTgt;
        this.imageIds = db.getImageIDs();
        this.graph.reset();
        ArrayList<String> similar = new ArrayList<String>();
        FastQueue srcFeats = new FastQueue(Point2D_F64::new);
        FastQueue dstFeats = new FastQueue(Point2D_F64::new);
        FastQueue matches = new FastQueue(AssociatedIndex::new);
        FastQueue pairs = new FastQueue(AssociatedPair::new);
        HashMap<String, Integer> imageToindex = new HashMap<String, Integer>();
        for (idxTgt = 0; idxTgt < this.imageIds.size(); ++idxTgt) {
            imageToindex.put(this.imageIds.get(idxTgt), idxTgt);
            this.graph.createNode(this.imageIds.get(idxTgt));
        }
        for (idxTgt = 0; idxTgt < this.imageIds.size(); ++idxTgt) {
            String src = this.imageIds.get(idxTgt);
            db.findSimilar(src, similar);
            db.lookupPixelFeats(src, (FastQueue<Point2D_F64>)srcFeats);
            ((PairwiseImageGraph2.View)this.graph.nodes.get((int)idxTgt)).totalFeatures = srcFeats.size;
            for (int idxSimilar = 0; idxSimilar < similar.size(); ++idxSimilar) {
                String dst = (String)similar.get(idxSimilar);
                int dstIdx = (Integer)imageToindex.get(dst);
                if (dstIdx <= idxTgt) continue;
                db.lookupPixelFeats(dst, (FastQueue<Point2D_F64>)dstFeats);
                db.lookupMatches(src, dst, (FastQueue<AssociatedIndex>)matches);
                pairs.reset();
                for (int i = 0; i < matches.size; ++i) {
                    AssociatedIndex m = (AssociatedIndex)matches.get(i);
                    ((AssociatedPair)pairs.grow()).set((Point2D_F64)srcFeats.get(m.src), (Point2D_F64)dstFeats.get(m.dst));
                }
                this.createEdge(src, dst, (FastQueue<AssociatedPair>)pairs, (FastQueue<AssociatedIndex>)matches);
            }
        }
    }

    protected void createEdge(String src, String dst, FastQueue<AssociatedPair> pairs, FastQueue<AssociatedIndex> matches) {
        int countF = 0;
        if (this.ransac3D.process(pairs.toList())) {
            countF = this.ransac3D.getMatchSet().size();
        }
        int countH = 0;
        if (this.ransacH.process(pairs.toList())) {
            countH = this.ransacH.getMatchSet().size();
        }
        if (Math.max(countF, countH) < this.minimumInliers) {
            return;
        }
        boolean is3D = (double)countF > (double)countH * this.ratio3D;
        PairwiseImageGraph2.Motion edge = (PairwiseImageGraph2.Motion)this.graph.edges.grow();
        edge.is3D = is3D;
        edge.countF = countF;
        edge.countH = countH;
        edge.index = this.graph.edges.size - 1;
        edge.src = this.graph.lookupNode(src);
        edge.dst = this.graph.lookupNode(dst);
        edge.src.connections.add((Object)edge);
        edge.dst.connections.add((Object)edge);
        if (is3D) {
            this.saveInlierMatches(this.ransac3D, matches, edge);
            edge.F.set((DMatrixD1)this.ransac3D.getModelParameters());
        } else {
            this.saveInlierMatches(this.ransacH, matches, edge);
            Homography2D_F64 H = (Homography2D_F64)this.ransacH.getModelParameters();
            ConvertDMatrixStruct.convert((DMatrix3x3)H, (DMatrixRMaj)edge.F);
        }
    }

    private void saveInlierMatches(ModelMatcher<?, ?> ransac, FastQueue<AssociatedIndex> matches, PairwiseImageGraph2.Motion edge) {
        int N = ransac.getMatchSet().size();
        edge.inliers.reset();
        for (int i = 0; i < N; ++i) {
            int idx = ransac.getInputIndex(i);
            ((AssociatedIndex)edge.inliers.grow()).set((AssociatedIndex)matches.get(idx));
        }
    }

    public PairwiseImageGraph2 getGraph() {
        return this.graph;
    }

    public int getMinimumInliers() {
        return this.minimumInliers;
    }

    public void setMinimumInliers(int minimumInliers) {
        this.minimumInliers = minimumInliers;
    }

    public double getRatio3D() {
        return this.ratio3D;
    }

    public void setRatio3D(double ratio3D) {
        this.ratio3D = ratio3D;
    }
}

