/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3.direct;

import georegression.struct.point.Point2D_F32;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.FMatrix2x2;
import org.ejml.dense.fixed.CommonOps_FDF2;

public class FeatureSpatialDiversity_F32 {
    FMatrix2x2 var = new FMatrix2x2();
    float meanX;
    float meanY;
    FastQueue<Point2D_F32> norm = new FastQueue(Point2D_F32::new);
    float sigmas = 3.0f;
    double spread;

    public void reset() {
        this.norm.reset();
    }

    public void addPoint(float x, float y, float z) {
        ((Point2D_F32)this.norm.grow()).set(x / z, y / z);
    }

    public void process() {
        this.computeCovarince();
        float eigenvalue = this.smallestEigenvalue();
        double stdev = Math.sqrt(eigenvalue);
        double angle0 = Math.atan2(1.0, (double)this.sigmas * ((double)this.meanX - stdev));
        double angle1 = Math.atan2(1.0, (double)this.sigmas * ((double)this.meanX + stdev));
        this.spread = Math.abs(angle1 - angle0);
    }

    private void computeCovarince() {
        Point2D_F32 p;
        int i;
        this.meanX = 0.0f;
        this.meanY = 0.0f;
        for (i = 0; i < this.norm.size; ++i) {
            p = (Point2D_F32)this.norm.get(i);
            this.meanX += p.x;
            this.meanY += p.y;
        }
        this.meanX /= (float)this.norm.size;
        this.meanY /= (float)this.norm.size;
        this.var.a22 = 0.0f;
        this.var.a12 = 0.0f;
        this.var.a11 = 0.0f;
        for (i = 0; i < this.norm.size; ++i) {
            p = (Point2D_F32)this.norm.get(i);
            float dx = p.x - this.meanX;
            float dy = p.y - this.meanY;
            this.var.a11 += dx * dx;
            this.var.a12 += dx * dy;
            this.var.a22 += dy * dy;
        }
        CommonOps_FDF2.divide((FMatrix2x2)this.var, (float)(this.norm.size - 1));
    }

    public double getSpread() {
        return this.spread;
    }

    private float smallestEigenvalue() {
        float left = (this.var.a11 + this.var.a22) * 0.5f;
        float b = (this.var.a11 - this.var.a22) * 0.5f;
        float right = (float)Math.sqrt(b * b + this.var.a12 * this.var.a12);
        return left - right;
    }
}

