/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3.structure;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.misc.Histogram2D_S32;
import boofcv.alg.misc.ImageCoverage;
import boofcv.alg.sfm.d3.structure.VisOdomBundleAdjustment;
import boofcv.alg.sfm.d3.structure.VisOdomKeyFrameManager;
import georegression.struct.point.Point2D_F64;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.io.PrintStream;
import java.util.Set;
import javax.annotation.Nullable;
import org.ddogleg.sorting.QuickSort_S32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class MaxGeoKeyFrameManager
implements VisOdomKeyFrameManager {
    public double minimumCoverage = 0.4;
    protected final GrowQueue_I32 discardKeyIndices = new GrowQueue_I32();
    protected FastQueue<CameraInfo> cameras = new FastQueue(CameraInfo::new, CameraInfo::reset);
    ImageCoverage coverage = new ImageCoverage();
    protected FastArray<PointTrack> activeTracks = new FastArray(PointTrack.class);
    protected Histogram2D_S32 histogram = new Histogram2D_S32();
    TLongIntMap frameToIndex = new TLongIntHashMap();
    QuickSort_S32 sorter = new QuickSort_S32();
    protected PrintStream verbose;

    public MaxGeoKeyFrameManager() {
    }

    public MaxGeoKeyFrameManager(double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
    }

    @Override
    public void initialize(FastAccess<VisOdomBundleAdjustment.BCamera> bundleCameras) {
        this.cameras.reset();
        for (int i = 0; i < bundleCameras.size; ++i) {
            VisOdomBundleAdjustment.BCamera bc = (VisOdomBundleAdjustment.BCamera)bundleCameras.get(i);
            CameraInfo ic = (CameraInfo)this.cameras.grow();
            ic.imageWidth = bc.original.width;
            ic.imageHeight = bc.original.height;
        }
        this.discardKeyIndices.reset();
    }

    @Override
    public GrowQueue_I32 selectFramesToDiscard(PointTracker<?> tracker, int maxKeyFrames, int newFrames, VisOdomBundleAdjustment<?> sba) {
        this.discardKeyIndices.reset();
        if (sba.frames.size <= maxKeyFrames) {
            return this.discardKeyIndices;
        }
        this.activeTracks.reset();
        tracker.getActiveTracks(this.activeTracks.toList());
        boolean keepCurrent = this.keepCurrentFrame(sba);
        if (!keepCurrent) {
            for (int i = 0; i < newFrames; ++i) {
                this.discardKeyIndices.add(sba.frames.size - i - 1);
            }
        }
        if (this.verbose != null) {
            this.verbose.println("keep_current=" + keepCurrent + " coverage=" + this.coverage.getFraction());
        }
        this.selectOldToDiscard(sba, sba.frames.size - maxKeyFrames - this.discardKeyIndices.size);
        this.sorter.sort(this.discardKeyIndices.data, this.discardKeyIndices.size);
        return this.discardKeyIndices;
    }

    protected boolean keepCurrentFrame(VisOdomBundleAdjustment<?> sba) {
        VisOdomBundleAdjustment.BFrame current = (VisOdomBundleAdjustment.BFrame)sba.frames.getTail();
        CameraInfo camera = (CameraInfo)this.cameras.get(current.camera.index);
        this.coverage.reset(camera.maxFeaturesPerFrame, camera.imageWidth, camera.imageHeight);
        for (int i = 0; i < this.activeTracks.size; ++i) {
            Point2D_F64 p = ((PointTrack)this.activeTracks.get((int)i)).pixel;
            this.coverage.markPixel((int)p.x, (int)p.y);
        }
        this.coverage.process();
        return this.coverage.getFraction() < this.minimumCoverage;
    }

    protected void selectOldToDiscard(VisOdomBundleAdjustment<?> sba, int totalDiscard) {
        if (totalDiscard <= 0 || sba.frames.size < 2) {
            return;
        }
        this.frameToIndex.clear();
        for (int i = 0; i < sba.frames.size; ++i) {
            this.frameToIndex.put(((VisOdomBundleAdjustment.BFrame)sba.frames.get((int)i)).id, i);
        }
        int N = sba.frames.size;
        this.histogram.reshape(N, N);
        this.histogram.zero();
        for (int frameIdxA = 0; frameIdxA < N - 1; ++frameIdxA) {
            VisOdomBundleAdjustment.BFrame frame = (VisOdomBundleAdjustment.BFrame)sba.frames.get(frameIdxA);
            for (int trackIdx = 0; trackIdx < frame.tracks.size; ++trackIdx) {
                VisOdomBundleAdjustment.BTrack track = (VisOdomBundleAdjustment.BTrack)frame.tracks.get(trackIdx);
                for (int obsIdx = 0; obsIdx < track.observations.size; ++obsIdx) {
                    VisOdomBundleAdjustment.BObservation o = (VisOdomBundleAdjustment.BObservation)track.observations.get(obsIdx);
                    int frameIdxB = this.frameToIndex.get(o.frame.id);
                    if (frameIdxA == frameIdxB) continue;
                    this.histogram.increment(frameIdxA, frameIdxB);
                }
            }
        }
        if (this.verbose != null) {
            this.histogram.print("%4d");
        }
        int bestFrame = this.histogram.maximumRowIdx(N - 1);
        if (this.verbose != null) {
            this.verbose.println("Frame with best connection to current " + bestFrame);
        }
        this.histogram.set(bestFrame, bestFrame, Integer.MAX_VALUE);
        for (int i = 0; i < totalDiscard; ++i) {
            int lowestCount = Integer.MAX_VALUE;
            int worstIdx = -1;
            for (int frameIdx = 0; frameIdx < N - 1; ++frameIdx) {
                int connection = this.histogram.get(frameIdx, bestFrame);
                if (connection == Integer.MAX_VALUE) continue;
                if (connection == 0) {
                    if (this.verbose != null) {
                        this.verbose.println("No connection index " + frameIdx);
                    }
                    lowestCount = 0;
                    worstIdx = frameIdx;
                    break;
                }
                if (connection >= lowestCount) continue;
                lowestCount = connection;
                worstIdx = frameIdx;
            }
            if (this.verbose != null) {
                this.verbose.println("Worst index " + worstIdx + "  count " + lowestCount);
            }
            this.discardKeyIndices.add(worstIdx);
            this.histogram.set(worstIdx, bestFrame, Integer.MAX_VALUE);
        }
    }

    @Override
    public void handleSpawnedTracks(PointTracker<?> tracker, VisOdomBundleAdjustment.BCamera camera) {
        CameraInfo info = (CameraInfo)this.cameras.get(camera.index);
        info.maxFeaturesPerFrame = tracker.getMaxSpawn() <= 0 ? Math.max(tracker.getTotalActive(), info.maxFeaturesPerFrame) : tracker.getMaxSpawn();
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    protected static class CameraInfo {
        public int imageWidth;
        public int imageHeight;
        public int maxFeaturesPerFrame;

        protected CameraInfo() {
        }

        public void reset() {
            this.imageWidth = -1;
            this.imageHeight = -1;
            this.maxFeaturesPerFrame = 0;
        }
    }
}

