/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure2;

import boofcv.alg.sfm.structure2.PairwiseImageGraph2;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.AssociatedTripleIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;

public class SceneWorkingGraph {
    private Map<String, View> views = new HashMap<String, View>();
    private List<Feature> features = new ArrayList<Feature>();
    private List<Observation> observations = new ArrayList<Observation>();

    public View lookupView(String id) {
        return this.views.get(id);
    }

    public View initialize(PairwiseImageGraph2.View pv) {
        View v = this.addView(pv);
        for (int featIdx = 0; featIdx < pv.totalFeatures; ++featIdx) {
            Feature f = this.createFeature();
            f.index = featIdx;
            f.known = false;
            Observation o = this.createObservation();
            o.viewIdx = featIdx;
            o.view = v;
            f.visible.add(o);
            v.v2g.put(featIdx, f);
        }
        return v;
    }

    public boolean isKnown(PairwiseImageGraph2.View pview) {
        return this.views.containsKey(pview.id);
    }

    public Feature lookupFeature(PairwiseImageGraph2.View pview, int viewIdx) {
        View v = this.views.get(pview.id);
        if (v == null) {
            return null;
        }
        return v.v2g.get(viewIdx);
    }

    public View addView(PairwiseImageGraph2.View pview) {
        View v = new View();
        v.pview = pview;
        this.views.put(v.pview.id, v);
        return v;
    }

    public View addViewAndFeatures(PairwiseImageGraph2.View pview) {
        View viewA = this.addView(pview);
        int[] l2g = this.findKnownFeatures(pview);
        this.addLocalFeatures(pview, viewA, l2g);
        return viewA;
    }

    private int[] findKnownFeatures(PairwiseImageGraph2.View pview) {
        int[] l2g = new int[pview.totalFeatures];
        Arrays.fill(l2g, -1);
        for (int connIdx = 0; connIdx < pview.connections.size; ++connIdx) {
            PairwiseImageGraph2.Motion m = (PairwiseImageGraph2.Motion)pview.connections.get(connIdx);
            boolean isSrc = m.src == pview;
            View viewB = this.lookupView((isSrc ? m.dst : m.src).id);
            for (int inlierIdx = 0; inlierIdx < m.inliers.size; ++inlierIdx) {
                Feature f;
                int indexA;
                AssociatedIndex a = ((AssociatedIndex[])m.inliers.data)[inlierIdx];
                if (isSrc) {
                    indexA = a.src;
                    f = viewB.v2g.get(a.dst);
                } else {
                    indexA = a.dst;
                    f = viewB.v2g.get(a.src);
                }
                if (f == null) continue;
                int currentId = l2g[indexA];
                if (currentId == -1) {
                    l2g[indexA] = f.index;
                    continue;
                }
                if (currentId == -2 || currentId == f.index) continue;
                l2g[indexA] = -2;
            }
        }
        return l2g;
    }

    private void addLocalFeatures(PairwiseImageGraph2.View pview, View viewA, int[] l2g) {
        for (int viewIdx = 0; viewIdx < pview.totalFeatures; ++viewIdx) {
            if (l2g[viewIdx] == -2) continue;
            Observation o = this.createObservation();
            o.view = viewA;
            o.viewIdx = viewIdx;
            Feature f = l2g[viewIdx] == -1 ? this.createFeature() : this.features.get(l2g[viewIdx]);
            f.visible.add(o);
            viewA.v2g.put(viewIdx, f);
        }
    }

    public Feature createFeature() {
        Feature f = new Feature();
        f.reset();
        f.index = this.features.size();
        this.features.add(f);
        return f;
    }

    private Observation createObservation() {
        Observation o = new Observation();
        this.observations.add(o);
        return o;
    }

    public void addObservation(Feature feature, View view, int index) {
        Observation o = this.createObservation();
        o.view = view;
        o.viewIdx = index;
        feature.visible.add(o);
    }

    public void lookupCommon(String viewA, String viewB, String viewC, List<Feature> features, FastQueue<AssociatedTripleIndex> matches) {
    }

    public class View {
        public PairwiseImageGraph2.View pview;
        public final Map<Integer, Feature> v2g = new HashMap<Integer, Feature>();
        public final DMatrixRMaj camera = new DMatrixRMaj(3, 4);

        public void reset() {
            this.pview = null;
            this.v2g.clear();
        }
    }

    public class Observation {
        public View view;
        public int viewIdx;

        public void reset() {
            this.view = null;
            this.viewIdx = -1;
        }
    }

    public class Feature {
        public int index;
        public boolean known;
        public final List<Observation> visible = new ArrayList<Observation>();

        public void reset() {
            this.index = -1;
            this.known = false;
            this.visible.clear();
        }
    }
}

