/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.feature.associate.StereoConsistencyCheck;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.sfm.d3.VisOdomBundlePnPBase;
import boofcv.alg.sfm.d3.structure.VisOdomBundleAdjustment;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class VisOdomDualTrackPnP<T extends ImageBase<T>, TD extends TupleDesc<TD>>
extends VisOdomBundlePnPBase<TrackInfo> {
    public static final int CAMERA_LEFT = 0;
    public static final int CAMERA_RIGHT = 1;
    private T inputLeft;
    private T inputRight;
    private final ModelMatcher<Se3_F64, Stereo2D3D> matcher;
    private final ModelFitter<Se3_F64, Stereo2D3D> modelRefiner;
    private final PointTracker<T> trackerLeft;
    private final PointTracker<T> trackerRight;
    private final DescribePointRadiusAngle<T, TD> describe;
    private double describeRadius = 11.0;
    private final FastArray<Point2D_F64> pointsLeft = new FastArray(Point2D_F64.class);
    private final FastArray<Point2D_F64> pointsRight = new FastArray(Point2D_F64.class);
    private final DogArray<TD> descLeft;
    private final DogArray<TD> descRight;
    private final AssociateDescription2D<TD> assocL2R;
    private final Triangulate2ViewsMetric triangulate2;
    private VisOdomBundleAdjustment.BFrame currentLeft;
    private VisOdomBundleAdjustment.BFrame currentRight;
    private VisOdomBundleAdjustment.BFrame previousLeft;
    private final StereoConsistencyCheck stereoCheck;
    private final Se3_F64 world_to_prev = new Se3_F64();
    private final List<PointTrack> candidates = new ArrayList<PointTrack>();
    private double timeTracking;
    private double timeEstimate;
    private double timeBundle;
    private double timeDropUnused;
    private double timeSceneMaintenance;
    private double timeSpawn;
    DogArray<Stereo2D3D> listStereo2D3D = new DogArray(Stereo2D3D::new);
    private final Se3_F64 left_to_right = new Se3_F64();
    private final Se3_F64 right_to_left = new Se3_F64();
    Point4D_F64 prevLoc4 = new Point4D_F64();
    Point3D_F64 cameraP3 = new Point3D_F64();
    Point2D_F64 normLeft = new Point2D_F64();
    Point2D_F64 normRight = new Point2D_F64();

    public VisOdomDualTrackPnP(double epilolarTol, PointTracker<T> trackerLeft, PointTracker<T> trackerRight, DescribePointRadiusAngle<T, TD> describe, AssociateDescription2D<TD> assocL2R, Triangulate2ViewsMetric triangulate2, ModelMatcher<Se3_F64, Stereo2D3D> matcher, ModelFitter<Se3_F64, Stereo2D3D> modelRefiner) {
        if (!assocL2R.uniqueSource() || !assocL2R.uniqueDestination()) {
            throw new IllegalArgumentException("Both unique source and destination must be ensure by association");
        }
        this.describe = describe;
        this.trackerLeft = trackerLeft;
        this.trackerRight = trackerRight;
        this.assocL2R = assocL2R;
        this.triangulate2 = triangulate2;
        this.matcher = matcher;
        this.modelRefiner = modelRefiner;
        this.descLeft = new DogArray(() -> describe.createDescription());
        this.descRight = new DogArray(() -> describe.createDescription());
        this.stereoCheck = new StereoConsistencyCheck(epilolarTol, epilolarTol);
        this.bundleViso = new VisOdomBundleAdjustment(TrackInfo::new);
        ConfigTriangulation config = new ConfigTriangulation();
        config.type = ConfigTriangulation.Type.GEOMETRIC;
        config.converge.maxIterations = 10;
        this.triangulateN = FactoryMultiView.triangulateNViewMetric((ConfigTriangulation)config);
    }

    public void setCalibration(StereoParameters param) {
        this.right_to_left.setTo(param.right_to_left);
        param.right_to_left.invert(this.left_to_right);
        VisOdomBundlePnPBase.CameraModel left = new VisOdomBundlePnPBase.CameraModel();
        left.pixelToNorm = LensDistortionFactory.narrow((CameraModel)param.left).undistort_F64(true, false);
        VisOdomBundlePnPBase.CameraModel right = new VisOdomBundlePnPBase.CameraModel();
        right.pixelToNorm = LensDistortionFactory.narrow((CameraModel)param.right).undistort_F64(true, false);
        this.stereoCheck.setCalibration(param);
        this.cameraModels.add(left);
        this.cameraModels.add(right);
        this.bundleViso.addCamera(param.left);
        this.bundleViso.addCamera(param.right);
    }

    @Override
    public void reset() {
        super.reset();
        this.trackerLeft.reset();
        this.trackerRight.reset();
    }

    public boolean process(T left, T right) {
        if (this.verbose != null) {
            this.verbose.println("----------- Process --------------");
            this.verbose.println("Scene: Frames=" + this.bundleViso.frames.size + " Tracks=" + this.bundleViso.tracks.size);
            for (int frameIdx = 0; frameIdx < this.bundleViso.frames.size; ++frameIdx) {
                VisOdomBundleAdjustment.BFrame bf = (VisOdomBundleAdjustment.BFrame)this.bundleViso.frames.get(frameIdx);
                this.verbose.printf("   frame[%2d] cam=%d tracks=%d\n", frameIdx, bf.camera.index, bf.tracks.size);
            }
        }
        this.inputLeft = left;
        this.inputRight = right;
        double time0 = System.nanoTime();
        this.inlierTracks.clear();
        this.visibleTracks.clear();
        this.initialVisible.clear();
        this.candidates.clear();
        this.currentLeft = this.bundleViso.addFrame(0, this.trackerLeft.getFrameID());
        this.currentRight = this.bundleViso.addFrame(1, this.trackerRight.getFrameID());
        this.trackerLeft.process(left);
        this.trackerRight.process(right);
        double time1 = System.nanoTime();
        if (this.first) {
            this.first = false;
            this.frameManager.initialize((FastAccess<VisOdomBundleAdjustment.BCamera>)this.bundleViso.cameras);
            this.addNewTracks();
            this.currentLeft.frame_to_world.reset();
            this.currentRight.frame_to_world.setTo(this.right_to_left);
            return true;
        }
        this.previousLeft = (VisOdomBundleAdjustment.BFrame)this.bundleViso.frames.getTail(3);
        this.mutualTrackDrop();
        this.selectCandidateStereoTracks();
        if (!this.estimateMotion()) {
            if (this.verbose != null) {
                this.verbose.println("!!! Motion Failed !!!");
            }
            this.removedBundleTracks.clear();
            this.bundleViso.removeFrame(this.currentRight, this.removedBundleTracks);
            this.bundleViso.removeFrame(this.currentLeft, this.removedBundleTracks);
            return false;
        }
        this.addInlierObservationsToScene();
        this.removeOldUnusedVisibleTracks();
        double time2 = System.nanoTime();
        this.optimizeTheScene();
        double time3 = System.nanoTime();
        this.dropBadBundleTracks();
        long time4 = System.nanoTime();
        boolean droppedCurrentFrame = this.performKeyFrameMaintenance(this.trackerLeft, 2);
        long time5 = System.nanoTime();
        if (!droppedCurrentFrame) {
            if (this.verbose != null) {
                this.verbose.println("Saving new key frames");
            }
            this.addNewTracks();
        }
        long time6 = System.nanoTime();
        this.timeTracking = (time1 - time0) * 1.0E-6;
        this.timeEstimate = (time2 - time1) * 1.0E-6;
        this.timeBundle = (time3 - time2) * 1.0E-6;
        this.timeDropUnused = ((double)time4 - time3) * 1.0E-6;
        this.timeSceneMaintenance = (double)(time5 - time4) * 1.0E-6;
        this.timeSpawn = (double)(time6 - time5) * 1.0E-6;
        if (this.profileOut != null) {
            double timeTotal = ((double)time6 - time0) * 1.0E-6;
            this.profileOut.printf("TIME: TRK %5.1f Est %5.1f Bun %5.1f DU %5.1f Scene %5.1f Spn  %5.1f TOTAL %5.1f\n", this.timeTracking, this.timeEstimate, this.timeBundle, this.timeDropUnused, this.timeSceneMaintenance, this.timeSpawn, timeTotal);
        }
        return true;
    }

    private void optimizeTheScene() {
        if (this.bundleViso.isOptimizeActive()) {
            this.bundleViso.optimize(this.verbose);
            this.triangulateNotSelectedBundleTracks();
        }
        this.current_to_world.setTo(this.currentLeft.frame_to_world);
    }

    private boolean estimateMotion() {
        VisOdomBundlePnPBase.CameraModel leftCM = (VisOdomBundlePnPBase.CameraModel)this.cameraModels.get(0);
        VisOdomBundlePnPBase.CameraModel rightCM = (VisOdomBundlePnPBase.CameraModel)this.cameraModels.get(1);
        this.previousLeft.frame_to_world.invert(this.world_to_prev);
        this.listStereo2D3D.reserve(this.candidates.size());
        this.listStereo2D3D.reset();
        for (int candidateIdx = 0; candidateIdx < this.candidates.size(); ++candidateIdx) {
            PointTrack l = this.candidates.get(candidateIdx);
            Stereo2D3D stereo = (Stereo2D3D)this.listStereo2D3D.grow();
            TrackInfo bt = (TrackInfo)l.getCookie();
            PointTrack r = bt.visualRight;
            SePointOps_F64.transform((Se3_F64)this.world_to_prev, (Point4D_F64)bt.worldLoc, (Point4D_F64)this.prevLoc4);
            PerspectiveOps.homogenousTo3dPositiveZ((Point4D_F64)this.prevLoc4, (double)1.0E8, (double)1.0E-8, (Point3D_F64)stereo.location);
            leftCM.pixelToNorm.compute(l.pixel.x, l.pixel.y, stereo.leftObs);
            rightCM.pixelToNorm.compute(r.pixel.x, r.pixel.y, stereo.rightObs);
        }
        if (!this.matcher.process(this.listStereo2D3D.toList())) {
            return false;
        }
        if (this.modelRefiner != null) {
            this.modelRefiner.fitModel(this.matcher.getMatchSet(), (Object)((Se3_F64)this.matcher.getModelParameters()), (Object)this.previous_to_current);
        } else {
            this.previous_to_current.setTo((Se3_F64)this.matcher.getModelParameters());
        }
        this.previous_to_current.invert(this.current_to_previous);
        this.current_to_previous.concat(this.previousLeft.frame_to_world, this.currentLeft.frame_to_world);
        this.right_to_left.concat(this.currentLeft.frame_to_world, this.currentRight.frame_to_world);
        return true;
    }

    private void addInlierObservationsToScene() {
        int N = this.matcher.getMatchSet().size();
        if (this.verbose != null) {
            this.verbose.println("Total Inliers " + N + " / " + this.candidates.size());
        }
        for (int i = 0; i < N; ++i) {
            int index = this.matcher.getInputIndex(i);
            TrackInfo bt = (TrackInfo)this.candidates.get(index).getCookie();
            if (bt.visualTrack == null) {
                throw new RuntimeException("BUG!");
            }
            bt.lastInlier = this.getFrameID();
            bt.hasBeenInlier = true;
            PointTrack l = bt.visualTrack;
            PointTrack r = bt.visualRight;
            this.bundleViso.addObservation(this.currentLeft, bt, l.pixel.x, l.pixel.y);
            this.bundleViso.addObservation(this.currentRight, bt, r.pixel.x, r.pixel.y);
            this.inlierTracks.add(bt);
        }
    }

    private void mutualTrackDrop() {
        TrackInfo bt;
        int total = 0;
        for (PointTrack t : this.trackerLeft.getDroppedTracks(null)) {
            bt = (TrackInfo)t.getCookie();
            this.trackerRight.dropTrack(bt.visualRight);
            bt.visualTrack = null;
            ++total;
        }
        for (PointTrack t : this.trackerRight.getDroppedTracks(null)) {
            bt = (TrackInfo)t.getCookie();
            if (bt.visualTrack == null) continue;
            this.trackerLeft.dropTrack(bt.visualTrack);
            bt.visualTrack = null;
            ++total;
        }
        if (this.verbose != null) {
            this.verbose.println("Dropped Tracks Mutual: " + total);
        }
    }

    private void selectCandidateStereoTracks() {
        long frameID = this.getFrameID();
        List activeRight = this.trackerRight.getActiveTracks(null);
        for (PointTrack t : activeRight) {
            TrackInfo bt = (TrackInfo)t.getCookie();
            if (bt.visualTrack == null) continue;
            bt.lastSeenRightFrame = frameID;
            this.initialVisible.add(bt);
        }
        List activeLeft = this.trackerLeft.getActiveTracks(null);
        this.candidates.clear();
        for (PointTrack left : activeLeft) {
            TrackInfo bt = (TrackInfo)left.getCookie();
            if (bt.lastSeenRightFrame != frameID) continue;
            if (bt.visualTrack == null) {
                throw new RuntimeException("BUG!!! Should have been skipped over in the right camera");
            }
            if (!this.stereoCheck.checkPixel(bt.visualTrack.pixel, bt.visualRight.pixel)) continue;
            bt.lastStereoFrame = frameID;
            this.candidates.add(left);
        }
        if (this.verbose != null) {
            this.verbose.println("Visual Tracks: Left: " + activeLeft.size() + " Right: " + activeRight.size() + " Candidates: " + this.candidates.size());
        }
    }

    private void removeOldUnusedVisibleTracks() {
        long currentFrameID = this.getFrameID();
        this.trackerLeft.dropTracks(track -> {
            TrackInfo bt = (TrackInfo)track.getCookie();
            if (bt == null) {
                throw new RuntimeException("BUG!");
            }
            if (currentFrameID - bt.lastInlier >= (long)this.thresholdRetireTracks) {
                bt.visualTrack = null;
                return true;
            }
            return false;
        });
        this.trackerRight.dropTracks(track -> {
            TrackInfo bt = (TrackInfo)track.getCookie();
            if (bt == null) {
                throw new RuntimeException("BUG!");
            }
            if (bt.visualTrack == null) {
                return true;
            }
            if (currentFrameID - bt.lastInlier >= (long)this.thresholdRetireTracks) {
                throw new RuntimeException("BUG! Should have already been dropped by left camera");
            }
            return false;
        });
    }

    private void addNewTracks() {
        VisOdomBundlePnPBase.CameraModel leftCM = (VisOdomBundlePnPBase.CameraModel)this.cameraModels.get(0);
        VisOdomBundlePnPBase.CameraModel rightCM = (VisOdomBundlePnPBase.CameraModel)this.cameraModels.get(1);
        long frameID = this.getFrameID();
        this.trackerLeft.spawnTracks();
        this.trackerRight.spawnTracks();
        List spawnedLeft = this.trackerLeft.getNewTracks(null);
        List spawnedRight = this.trackerRight.getNewTracks(null);
        this.describeSpawnedTracks(this.inputLeft, spawnedLeft, this.pointsLeft, this.descLeft);
        this.describeSpawnedTracks(this.inputRight, spawnedRight, this.pointsRight, this.descRight);
        this.assocL2R.setSource(this.pointsLeft, this.descLeft);
        this.assocL2R.setDestination(this.pointsRight, this.descRight);
        this.assocL2R.associate();
        FastAccess matches = this.assocL2R.getMatches();
        int total = 0;
        for (int i = 0; i < matches.size; ++i) {
            AssociatedIndex m = (AssociatedIndex)matches.get(i);
            PointTrack trackL = (PointTrack)spawnedLeft.get(m.src);
            PointTrack trackR = (PointTrack)spawnedRight.get(m.dst);
            TrackInfo bt = (TrackInfo)this.bundleViso.tracks.grow();
            leftCM.pixelToNorm.compute(trackL.pixel.x, trackL.pixel.y, this.normLeft);
            rightCM.pixelToNorm.compute(trackR.pixel.x, trackR.pixel.y, this.normRight);
            if (this.triangulate2.triangulate(this.normLeft, this.normRight, this.left_to_right, this.cameraP3)) {
                SePointOps_F64.transform((Se3_F64)this.currentLeft.frame_to_world, (Point3D_F64)this.cameraP3, (Point3D_F64)this.cameraP3);
                bt.worldLoc.setTo(this.cameraP3.x, this.cameraP3.y, this.cameraP3.z, 1.0);
                bt.id = trackL.featureId;
                bt.visualTrack = trackL;
                bt.visualRight = trackR;
                bt.lastStereoFrame = bt.lastSeenRightFrame = frameID;
                trackL.cookie = bt;
                trackR.cookie = bt;
                this.bundleViso.addObservation(this.currentLeft, bt, trackL.pixel.x, trackL.pixel.y);
                this.bundleViso.addObservation(this.currentRight, bt, trackR.pixel.x, trackR.pixel.y);
                this.visibleTracks.add(bt);
                ++total;
                continue;
            }
            this.trackerLeft.dropTrack(trackL);
            this.trackerRight.dropTrack(trackR);
            this.bundleViso.tracks.removeTail();
        }
        if (this.verbose != null) {
            this.verbose.println("New Tracks: left=" + spawnedLeft.size() + " right=" + spawnedRight.size() + " stereo=" + total);
        }
        DogArray_I32 unassignedRight = this.assocL2R.getUnassociatedDestination();
        for (int i = 0; i < unassignedRight.size; ++i) {
            int index = unassignedRight.get(i);
            this.trackerRight.dropTrack((PointTrack)spawnedRight.get(index));
        }
        DogArray_I32 unassignedLeft = this.assocL2R.getUnassociatedSource();
        for (int i = 0; i < unassignedLeft.size; ++i) {
            int index = unassignedLeft.get(i);
            this.trackerLeft.dropTrack((PointTrack)spawnedLeft.get(index));
        }
        this.frameManager.handleSpawnedTracks(this.trackerLeft, (VisOdomBundleAdjustment.BCamera)this.bundleViso.cameras.get(0));
        this.frameManager.handleSpawnedTracks(this.trackerRight, (VisOdomBundleAdjustment.BCamera)this.bundleViso.cameras.get(1));
    }

    private void describeSpawnedTracks(T image, List<PointTrack> tracks, FastArray<Point2D_F64> points, DogArray<TD> descs) {
        this.describe.setImage(image);
        points.reset();
        descs.reset();
        for (int i = 0; i < tracks.size(); ++i) {
            PointTrack t = tracks.get(i);
            this.describe.process(t.pixel.x, t.pixel.y, 0.0, this.describeRadius, (TupleDesc)descs.grow());
            points.add((Object)t.pixel);
        }
    }

    @Override
    public long getFrameID() {
        return this.trackerLeft.getFrameID();
    }

    public boolean isFault() {
        return this.candidates.isEmpty();
    }

    @Override
    protected void dropVisualTrack(PointTrack left) {
        TrackInfo info = (TrackInfo)left.getCookie();
        PointTrack right = info.visualRight;
        this.trackerLeft.dropTrack(left);
        this.trackerRight.dropTrack(right);
    }

    public ModelMatcher<Se3_F64, Stereo2D3D> getMatcher() {
        return this.matcher;
    }

    public ModelFitter<Se3_F64, Stereo2D3D> getModelRefiner() {
        return this.modelRefiner;
    }

    public double getDescribeRadius() {
        return this.describeRadius;
    }

    public void setDescribeRadius(double describeRadius) {
        this.describeRadius = describeRadius;
    }

    public List<PointTrack> getCandidates() {
        return this.candidates;
    }

    public double getTimeTracking() {
        return this.timeTracking;
    }

    public double getTimeEstimate() {
        return this.timeEstimate;
    }

    public double getTimeBundle() {
        return this.timeBundle;
    }

    public double getTimeDropUnused() {
        return this.timeDropUnused;
    }

    public double getTimeSceneMaintenance() {
        return this.timeSceneMaintenance;
    }

    public double getTimeSpawn() {
        return this.timeSpawn;
    }

    public static class TrackInfo
    extends VisOdomBundleAdjustment.BTrack {
        public PointTrack visualRight;
        public long lastStereoFrame;
        public long lastInlier;
        public long lastSeenRightFrame;

        @Override
        public void reset() {
            super.reset();
            this.visualRight = null;
            this.lastStereoFrame = -1L;
            this.lastInlier = -1L;
            this.lastSeenRightFrame = -1L;
        }
    }
}

