/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;

public class ConfigPlanarTrackPnP
implements Configuration {
    public int thresholdAdd;
    public int thresholdRetire = 2;
    public double thresholdPixelError = 1.5;
    public ConfigRansac ransac = new ConfigRansac(500, 1.5);
    public ConfigPointTracker tracker = new ConfigPointTracker();

    public void checkValidity() {
        this.tracker.checkValidity();
        this.ransac.checkValidity();
        BoofMiscOps.checkTrue((this.thresholdAdd > 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.thresholdRetire >= 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.thresholdPixelError >= 0.0 ? 1 : 0) != 0);
    }

    public void setTo(ConfigPlanarTrackPnP src) {
        this.thresholdAdd = src.thresholdAdd;
        this.thresholdRetire = src.thresholdRetire;
        this.thresholdPixelError = src.thresholdPixelError;
        this.tracker.setTo(src.tracker);
        this.ransac.setTo(src.ransac);
    }
}

