/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.abst.disparity.StereoDisparitySparse;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.EnforceUniqueByScore;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.EstimateNofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.sfm.DepthSparse3D_to_PixelTo3D;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.abst.sfm.d3.MonoOverhead_to_MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonoPlaneInfinity_to_MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometryScaleInput;
import boofcv.abst.sfm.d3.PyramidDirectColorDepth_to_DepthVisualOdometry;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.abst.sfm.d3.StereoVisualOdometryScaleInput;
import boofcv.abst.sfm.d3.VisOdomPixelDepthPnP_to_DepthVisualOdometry;
import boofcv.abst.sfm.d3.WrapVisOdomDualTrackPnP;
import boofcv.abst.sfm.d3.WrapVisOdomMonoStereoDepthPnP;
import boofcv.abst.sfm.d3.WrapVisOdomQuadPnP;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.feature.associate.AssociateStereo2D;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.pose.PnPDistanceReprojectionSq;
import boofcv.alg.geo.pose.PnPStereoDistanceReprojectionSq;
import boofcv.alg.geo.pose.PnPStereoEstimator;
import boofcv.alg.geo.pose.PnPStereoRefineRodrigues;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.sfm.StereoSparse3D;
import boofcv.alg.sfm.d3.VisOdomDualTrackPnP;
import boofcv.alg.sfm.d3.VisOdomMonoDepthPnP;
import boofcv.alg.sfm.d3.VisOdomMonoOverheadMotion2D;
import boofcv.alg.sfm.d3.VisOdomMonoPlaneInfinity;
import boofcv.alg.sfm.d3.VisOdomStereoQuadPnP;
import boofcv.alg.sfm.d3.direct.PyramidDirectColorDepth;
import boofcv.alg.sfm.d3.structure.MaxGeoKeyFrameManager;
import boofcv.alg.sfm.d3.structure.TickTockKeyFrameManager;
import boofcv.alg.sfm.d3.structure.VisOdomKeyFrameManager;
import boofcv.alg.sfm.robust.DistancePlane2DToPixelSq;
import boofcv.alg.sfm.robust.GenerateSe2_PlanePtPixel;
import boofcv.factory.disparity.ConfigDisparityBM;
import boofcv.factory.disparity.FactoryStereoDisparity;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.describe.FactoryDescribePointRadiusAngle;
import boofcv.factory.feature.detdesc.ConfigDetectDescribe;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.EstimatorToGenerator;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.factory.sfm.ConfigPlanarTrackPnP;
import boofcv.factory.sfm.ConfigRgbDepthTrackPnP;
import boofcv.factory.sfm.ConfigStereoDualTrackPnP;
import boofcv.factory.sfm.ConfigStereoMonoTrackPnP;
import boofcv.factory.sfm.ConfigStereoQuadPnP;
import boofcv.factory.sfm.ConfigVisOdomTrackPnP;
import boofcv.factory.sfm.FactoryMotion2D;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.geo.GeoModelEstimator1;
import boofcv.struct.geo.GeoModelEstimatorN;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import boofcv.struct.sfm.PlanePtPixel;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.fitting.se.ModelManagerSe2_F64;
import georegression.fitting.se.ModelManagerSe3_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.jetbrains.annotations.Nullable;

public class FactoryVisualOdometry {
    public static <T extends ImageGray<T>> MonocularPlaneVisualOdometry<T> monoPlaneInfinity(@Nullable ConfigPlanarTrackPnP config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigPlanarTrackPnP();
        }
        PointTracker tracker = FactoryPointTracker.tracker((ConfigPointTracker)config.tracker, imageType, null);
        double ransacTOL = config.ransac.inlierThreshold * config.ransac.inlierThreshold;
        ModelManagerSe2_F64 manager = new ModelManagerSe2_F64();
        DistancePlane2DToPixelSq distance = new DistancePlane2DToPixelSq();
        GenerateSe2_PlanePtPixel generator = new GenerateSe2_PlanePtPixel();
        Ransac motion = FactoryMultiViewRobust.createRansac((ConfigRansac)config.ransac, (double)ransacTOL, (ModelManager)manager, PlanePtPixel.class);
        motion.setModel(generator::newConcurrent, distance::newConcurrent);
        VisOdomMonoPlaneInfinity alg = new VisOdomMonoPlaneInfinity(config.thresholdAdd, config.thresholdRetire, config.ransac.inlierThreshold, (ModelMatcher<Se2_F64, PlanePtPixel>)motion, tracker);
        return new MonoPlaneInfinity_to_MonocularPlaneVisualOdometry(alg, distance, generator, ImageType.single(imageType));
    }

    public static <T extends ImageGray<T>> MonocularPlaneVisualOdometry<T> monoPlaneOverhead(double cellSize, double maxCellsPerPixel, double mapHeightFraction, double inlierGroundTol, int ransacIterations, int thresholdRetire, int absoluteMinimumTracks, double respawnTrackFraction, double respawnCoverageFraction, PointTracker<T> tracker, ImageType<T> imageType) {
        ImageMotion2D<T, Se2_F64> motion2D = FactoryMotion2D.createMotion2D(ransacIterations, inlierGroundTol * inlierGroundTol, thresholdRetire, absoluteMinimumTracks, respawnTrackFraction, respawnCoverageFraction, false, tracker, new Se2_F64());
        VisOdomMonoOverheadMotion2D<T> alg = new VisOdomMonoOverheadMotion2D<T>(cellSize, maxCellsPerPixel, mapHeightFraction, motion2D, imageType);
        return new MonoOverhead_to_MonocularPlaneVisualOdometry<T>(alg, imageType);
    }

    public static <T extends ImageGray<T>> StereoVisualOdometry<T> stereoMonoPnP(@Nullable ConfigStereoMonoTrackPnP config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigStereoMonoTrackPnP();
        }
        PointTracker tracker = FactoryPointTracker.tracker((ConfigPointTracker)config.tracker, imageType, null);
        StereoDisparitySparse disparity = FactoryStereoDisparity.sparseRectifiedBM((ConfigDisparityBM)config.disparity, imageType);
        return FactoryVisualOdometry.stereoMonoPnP(config.scene, disparity, tracker, imageType);
    }

    public static <T extends ImageGray<T>> StereoVisualOdometry<T> stereoMonoPnP(@Nullable ConfigVisOdomTrackPnP configVO, StereoDisparitySparse<T> sparseDisparity, PointTracker<T> tracker, Class<T> imageType) {
        VisOdomKeyFrameManager visOdomKeyFrameManager;
        if (configVO == null) {
            configVO = new ConfigVisOdomTrackPnP();
        }
        ConfigVisOdomTrackPnP _configVO = configVO;
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        double ransacTOL = configVO.ransac.inlierThreshold * configVO.ransac.inlierThreshold;
        Ransac motion = FactoryMultiViewRobust.createRansac((ConfigRansac)configVO.ransac, (double)ransacTOL, (ModelManager)manager, Point2D3D.class);
        motion.setModel(() -> {
            Estimate1ofPnP estimator = FactoryMultiView.pnp_1((EnumPNP)_configVO.pnp, (int)-1, (int)1);
            return new EstimatorToGenerator((GeoModelEstimator1)estimator);
        }, () -> ((PnPDistanceReprojectionSq)distance).newConcurrentChild());
        RefinePnP refine = null;
        if (configVO.refineIterations > 0) {
            refine = FactoryMultiView.pnpRefine((double)1.0E-12, (int)configVO.refineIterations);
        }
        switch (configVO.keyframes.type) {
            case MAX_GEO: {
                visOdomKeyFrameManager = new MaxGeoKeyFrameManager(configVO.keyframes.geoMinCoverage);
                break;
            }
            case TICK_TOCK: {
                visOdomKeyFrameManager = new TickTockKeyFrameManager(configVO.keyframes.tickPeriod);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        VisOdomKeyFrameManager keyframe = visOdomKeyFrameManager;
        StereoSparse3D<T> pixelTo3D = new StereoSparse3D<T>(sparseDisparity, imageType);
        VisOdomMonoDepthPnP<T> alg = new VisOdomMonoDepthPnP<T>((ModelMatcher<Se3_F64, Point2D3D>)motion, pixelTo3D, refine, tracker);
        alg.getBundleViso().bundle.setSba(FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)configVO.bundle));
        alg.getBundleViso().bundle.configConverge.setTo(configVO.bundleConverge);
        alg.setFrameManager(keyframe);
        alg.setThresholdRetireTracks(configVO.dropOutlierTracks);
        alg.getBundleViso().getSelectTracks().maxFeaturesPerFrame = configVO.bundleMaxFeaturesPerFrame;
        alg.getBundleViso().getSelectTracks().minTrackObservations = configVO.bundleMinObservations;
        return new WrapVisOdomMonoStereoDepthPnP<T>(alg, pixelTo3D, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distance, imageType);
    }

    public static <Vis extends ImageGray<Vis>, Depth extends ImageGray<Depth>> DepthVisualOdometry<Vis, Depth> rgbDepthPnP(ConfigRgbDepthTrackPnP config, Class<Vis> visualType, Class<Depth> depthType) {
        PointTracker tracker = FactoryPointTracker.tracker((ConfigPointTracker)config.tracker, visualType, null);
        ImageType depthInfo = ImageType.single(depthType);
        DepthSparse3D sparseDepth = depthInfo.getDataType().isInteger() ? new DepthSparse3D.I(config.depthScale) : new DepthSparse3D.F32(config.depthScale);
        return FactoryVisualOdometry.rgbDepthPnP(config.scene, sparseDepth, tracker, visualType, depthType);
    }

    public static <Vis extends ImageGray<Vis>, Depth extends ImageGray<Depth>> DepthVisualOdometry<Vis, Depth> rgbDepthPnP(ConfigVisOdomTrackPnP configVO, DepthSparse3D<Depth> sparseDepth, PointTracker<Vis> tracker, Class<Vis> visualType, Class<Depth> depthType) {
        VisOdomKeyFrameManager visOdomKeyFrameManager;
        DepthSparse3D_to_PixelTo3D<Depth> pixelTo3D = new DepthSparse3D_to_PixelTo3D<Depth>(sparseDepth);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        ModelManagerSe3_F64 manager = new ModelManagerSe3_F64();
        double ransacTOL = configVO.ransac.inlierThreshold * configVO.ransac.inlierThreshold;
        Ransac motion = FactoryMultiViewRobust.createRansac((ConfigRansac)configVO.ransac, (double)ransacTOL, (ModelManager)manager, Point2D3D.class);
        motion.setModel(() -> {
            Estimate1ofPnP estimator = FactoryMultiView.pnp_1((EnumPNP)configVO.pnp, (int)-1, (int)1);
            return new EstimatorToGenerator((GeoModelEstimator1)estimator);
        }, () -> ((PnPDistanceReprojectionSq)distance).newConcurrentChild());
        RefinePnP refine = null;
        if (configVO.refineIterations > 0) {
            refine = FactoryMultiView.pnpRefine((double)1.0E-12, (int)configVO.refineIterations);
        }
        switch (configVO.keyframes.type) {
            case MAX_GEO: {
                visOdomKeyFrameManager = new MaxGeoKeyFrameManager(configVO.keyframes.geoMinCoverage);
                break;
            }
            case TICK_TOCK: {
                visOdomKeyFrameManager = new TickTockKeyFrameManager(configVO.keyframes.tickPeriod);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        VisOdomKeyFrameManager keyframe = visOdomKeyFrameManager;
        VisOdomMonoDepthPnP<Vis> alg = new VisOdomMonoDepthPnP<Vis>((ModelMatcher<Se3_F64, Point2D3D>)motion, pixelTo3D, refine, tracker);
        alg.getBundleViso().bundle.setSba(FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)configVO.bundle));
        alg.getBundleViso().bundle.configConverge.setTo(configVO.bundleConverge);
        alg.setFrameManager(keyframe);
        alg.setThresholdRetireTracks(configVO.dropOutlierTracks);
        alg.getBundleViso().getSelectTracks().maxFeaturesPerFrame = configVO.bundleMaxFeaturesPerFrame;
        alg.getBundleViso().getSelectTracks().minTrackObservations = configVO.bundleMinObservations;
        return new VisOdomPixelDepthPnP_to_DepthVisualOdometry<Vis, Depth>(sparseDepth, alg, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distance, ImageType.single(visualType), depthType);
    }

    public static <T extends ImageGray<T>> StereoVisualOdometry<T> stereoDualTrackerPnP(@Nullable ConfigStereoDualTrackPnP configVO, Class<T> imageType) {
        if (configVO == null) {
            configVO = new ConfigStereoDualTrackPnP();
        }
        configVO.checkValidity();
        PointTracker trackerLeft = FactoryPointTracker.tracker((ConfigPointTracker)configVO.tracker, imageType, null);
        PointTracker trackerRight = FactoryPointTracker.tracker((ConfigPointTracker)configVO.tracker, imageType, null);
        return FactoryVisualOdometry.stereoDualTrackerPnP(configVO.scene, trackerLeft, trackerRight, configVO, imageType);
    }

    public static <T extends ImageGray<T>, Desc extends TupleDesc<Desc>> StereoVisualOdometry<T> stereoDualTrackerPnP(ConfigVisOdomTrackPnP configVO, PointTracker<T> trackerLeft, PointTracker<T> trackerRight, ConfigStereoDualTrackPnP hack, Class<T> imageType) {
        VisOdomKeyFrameManager visOdomKeyFrameManager;
        if (configVO == null) {
            configVO = new ConfigVisOdomTrackPnP();
        }
        configVO.checkValidity();
        double ransacTOL = 2.0 * configVO.ransac.inlierThreshold * configVO.ransac.inlierThreshold;
        Se3_F64 sharedLeftToRight = new Se3_F64();
        PnPDistanceReprojectionSq distanceLeft = new PnPDistanceReprojectionSq();
        PnPDistanceReprojectionSq distanceRight = new PnPDistanceReprojectionSq();
        PnPStereoDistanceReprojectionSq distanceStereo = new PnPStereoDistanceReprojectionSq();
        Ransac motion = FactoryMultiViewRobust.createRansac((ConfigRansac)configVO.ransac, (double)ransacTOL, (ModelManager)new ModelManagerSe3_F64(), Stereo2D3D.class);
        ConfigVisOdomTrackPnP _configVO = configVO;
        motion.setModel(() -> {
            EstimateNofPnP pnp = FactoryMultiView.pnp_N((EnumPNP)_configVO.pnp, (int)-1);
            PnPStereoEstimator pnpStereo = new PnPStereoEstimator((GeoModelEstimatorN<Se3_F64, Point2D3D>)pnp, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceLeft.newConcurrentChild(), (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceRight.newConcurrentChild(), 0);
            pnpStereo.setLeftToRightReference(sharedLeftToRight);
            return new EstimatorToGenerator((GeoModelEstimator1)pnpStereo);
        }, distanceStereo::newConcurrentChild);
        PnPStereoRefineRodrigues refinePnP = null;
        if (configVO.refineIterations > 0) {
            refinePnP = new PnPStereoRefineRodrigues(1.0E-12, configVO.refineIterations);
        }
        Triangulate2ViewsMetric triangulate2 = FactoryMultiView.triangulate2ViewMetric((ConfigTriangulation)new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
        switch (configVO.keyframes.type) {
            case MAX_GEO: {
                visOdomKeyFrameManager = new MaxGeoKeyFrameManager(configVO.keyframes.geoMinCoverage);
                break;
            }
            case TICK_TOCK: {
                visOdomKeyFrameManager = new TickTockKeyFrameManager(configVO.keyframes.tickPeriod);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        VisOdomKeyFrameManager keyframe = visOdomKeyFrameManager;
        DescribePointRadiusAngle descriptor = FactoryDescribePointRadiusAngle.generic((ConfigDescribeRegion)hack.stereoDescribe, (ImageType)ImageType.single(imageType));
        Class descType = descriptor.getDescriptionType();
        ScoreAssociation scorer = FactoryAssociation.defaultScore((Class)descType);
        AssociateStereo2D associateL2R = new AssociateStereo2D(scorer, hack.epipolarTol);
        AssociateDescription2D associateUnique = FactoryAssociation.ensureUnique(associateL2R);
        if (!associateL2R.uniqueDestination() || !associateL2R.uniqueSource()) {
            associateUnique = new EnforceUniqueByScore.Describe2D(associateL2R, true, true);
        }
        VisOdomDualTrackPnP alg = new VisOdomDualTrackPnP(hack.epipolarTol, trackerLeft, trackerRight, descriptor, associateUnique, triangulate2, (ModelMatcher<Se3_F64, Stereo2D3D>)motion, refinePnP);
        alg.getBundleViso().bundle.setSba(FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)configVO.bundle));
        alg.getBundleViso().bundle.configConverge.setTo(configVO.bundleConverge);
        alg.setDescribeRadius(hack.stereoRadius);
        alg.setFrameManager(keyframe);
        alg.setThresholdRetireTracks(configVO.dropOutlierTracks);
        alg.getBundleViso().getSelectTracks().maxFeaturesPerFrame = configVO.bundleMaxFeaturesPerFrame;
        alg.getBundleViso().getSelectTracks().minTrackObservations = configVO.bundleMinObservations;
        return new WrapVisOdomDualTrackPnP<T>(alg, sharedLeftToRight, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceLeft, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceRight, distanceStereo, associateL2R, refinePnP, imageType);
    }

    public static <T extends ImageGray<T>, Desc extends TupleDesc<Desc>> StereoVisualOdometry<T> stereoQuadPnP(ConfigStereoQuadPnP config, Class<T> imageType) {
        double ransacTOL = 2.0 * config.ransac.inlierThreshold * config.ransac.inlierThreshold;
        Ransac motion = FactoryMultiViewRobust.createRansac((ConfigRansac)config.ransac, (double)ransacTOL, (ModelManager)new ModelManagerSe3_F64(), Stereo2D3D.class);
        Se3_F64 sharedLeftToRight = new Se3_F64();
        PnPDistanceReprojectionSq distanceLeft = new PnPDistanceReprojectionSq();
        PnPDistanceReprojectionSq distanceRight = new PnPDistanceReprojectionSq();
        PnPStereoDistanceReprojectionSq distanceStereo = new PnPStereoDistanceReprojectionSq();
        motion.setModel(() -> {
            EstimateNofPnP pnp = FactoryMultiView.pnp_N((EnumPNP)config.pnp, (int)-1);
            PnPStereoEstimator pnpStereo = new PnPStereoEstimator((GeoModelEstimatorN<Se3_F64, Point2D3D>)pnp, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceLeft.newConcurrentChild(), (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceRight.newConcurrentChild(), 0);
            pnpStereo.setLeftToRightReference(sharedLeftToRight);
            return new EstimatorToGenerator((GeoModelEstimator1)pnpStereo);
        }, distanceStereo::newConcurrentChild);
        PnPStereoRefineRodrigues refinePnP = null;
        if (config.refineIterations > 0) {
            refinePnP = new PnPStereoRefineRodrigues(1.0E-12, config.refineIterations);
        }
        DetectDescribePoint detector = FactoryDetectDescribe.generic((ConfigDetectDescribe)config.detectDescribe, imageType);
        Class descType = detector.getDescriptionType();
        ScoreAssociation scorer = FactoryAssociation.defaultScore((Class)descType);
        AssociateStereo2D associateL2R = new AssociateStereo2D(scorer, config.epipolarTol);
        associateL2R.setMaxScoreThreshold(config.associateL2R.maxErrorThreshold);
        AssociateDescription2D associateF2F = FactoryAssociation.generic2((ConfigAssociate)config.associateF2F, (DescriptorInfo)detector);
        Triangulate2ViewsMetric triangulate = FactoryMultiView.triangulate2ViewMetric((ConfigTriangulation)new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
        VisOdomStereoQuadPnP alg = new VisOdomStereoQuadPnP(detector, associateF2F, associateL2R, triangulate, (ModelMatcher<Se3_F64, Stereo2D3D>)motion, refinePnP);
        alg.getBundle().sba = FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)config.bundle);
        alg.getBundle().configConverge.setTo(config.bundleConverge);
        return new WrapVisOdomQuadPnP(alg, refinePnP, associateL2R, distanceStereo, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceLeft, (DistanceFromModelMultiView<Se3_F64, Point2D3D>)distanceRight, imageType);
    }

    public static <T extends ImageBase<T>> StereoVisualOdometry<T> scaleInput(StereoVisualOdometry<T> vo, double scaleFactor) {
        return new StereoVisualOdometryScaleInput<T>(vo, scaleFactor);
    }

    public static <T extends ImageBase<T>> MonocularPlaneVisualOdometry<T> scaleInput(MonocularPlaneVisualOdometry<T> vo, double scaleFactor) {
        return new MonocularPlaneVisualOdometryScaleInput<T>(vo, scaleFactor);
    }

    public static <Vis extends ImageGray<Vis>, Depth extends ImageGray<Depth>> DepthVisualOdometry<Planar<Vis>, Depth> depthDirect(DepthSparse3D<Depth> sparse3D, ImageType<Planar<Vis>> visualType, Class<Depth> depthType) {
        PyramidDiscrete pyramid = FactoryPyramid.discreteGaussian((ConfigDiscreteLevels)ConfigDiscreteLevels.levels((int)3), (double)-1.0, (int)2, (boolean)false, visualType);
        PyramidDirectColorDepth alg = new PyramidDirectColorDepth(pyramid);
        return new PyramidDirectColorDepth_to_DepthVisualOdometry(sparse3D, alg, depthType);
    }
}

