/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.RodriguesRotationJacobian_F64;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class PnPStereoJacobianRodrigues
implements FunctionNtoMxN<DMatrixRMaj> {
    private final Se3_F64 worldToLeft = new Se3_F64();
    private Se3_F64 leftToRight;
    private List<Stereo2D3D> observations;
    private final RodriguesRotationJacobian_F64 rodJacobian = new RodriguesRotationJacobian_F64();
    private final Rodrigues_F64 rodrigues = new Rodrigues_F64();
    private final Point3D_F64 cameraPt = new Point3D_F64();
    private double[] output;
    private int indexX;
    private int indexY;
    private final DMatrixRMaj rotR = new DMatrixRMaj(3, 3);

    public void setObservations(List<Stereo2D3D> observations) {
        this.observations = observations;
    }

    public void setLeftToRight(Se3_F64 leftToRight) {
        this.leftToRight = leftToRight;
    }

    public int getNumOfInputsN() {
        return 6;
    }

    public int getNumOfOutputsM() {
        return this.observations.size() * 4;
    }

    public void process(double[] input, DMatrixRMaj J) {
        this.output = J.data;
        this.rodrigues.setParamVector(input[0], input[1], input[2]);
        this.rodJacobian.process(input[0], input[1], input[2]);
        this.worldToLeft.T.x = input[3];
        this.worldToLeft.T.y = input[4];
        this.worldToLeft.T.z = input[5];
        ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)this.rodrigues, (DMatrixRMaj)this.worldToLeft.getR());
        for (int i = 0; i < this.observations.size(); ++i) {
            Stereo2D3D o = this.observations.get(i);
            SePointOps_F64.transform((Se3_F64)this.worldToLeft, (Point3D_F64)o.location, (Point3D_F64)this.cameraPt);
            this.indexX = 24 * i;
            this.indexY = this.indexX + 6;
            this.addRodriguesJacobian(this.rodJacobian.Rx, o.location, this.cameraPt);
            this.addRodriguesJacobian(this.rodJacobian.Ry, o.location, this.cameraPt);
            this.addRodriguesJacobian(this.rodJacobian.Rz, o.location, this.cameraPt);
            this.addTranslationJacobian(this.cameraPt);
            SePointOps_F64.transform((Se3_F64)this.leftToRight, (Point3D_F64)this.cameraPt, (Point3D_F64)this.cameraPt);
            this.indexX = this.indexY;
            this.indexY += 6;
            CommonOps_DDRM.mult((DMatrix1Row)this.leftToRight.getR(), (DMatrix1Row)this.rodJacobian.Rx, (DMatrix1Row)this.rotR);
            this.addRodriguesJacobian(this.rotR, o.location, this.cameraPt);
            CommonOps_DDRM.mult((DMatrix1Row)this.leftToRight.getR(), (DMatrix1Row)this.rodJacobian.Ry, (DMatrix1Row)this.rotR);
            this.addRodriguesJacobian(this.rotR, o.location, this.cameraPt);
            CommonOps_DDRM.mult((DMatrix1Row)this.leftToRight.getR(), (DMatrix1Row)this.rodJacobian.Rz, (DMatrix1Row)this.rotR);
            this.addRodriguesJacobian(this.rotR, o.location, this.cameraPt);
            this.addTranslationJacobian(this.leftToRight.getR(), this.cameraPt);
        }
    }

    public DMatrixRMaj declareMatrixMxN() {
        return new DMatrixRMaj(this.getNumOfOutputsM(), this.getNumOfInputsN());
    }

    private void addRodriguesJacobian(DMatrixRMaj Rj, Point3D_F64 worldPt, Point3D_F64 cameraPt) {
        double Rx = (Rj.data[0] * worldPt.x + Rj.data[1] * worldPt.y + Rj.data[2] * worldPt.z) / cameraPt.z;
        double Ry = (Rj.data[3] * worldPt.x + Rj.data[4] * worldPt.y + Rj.data[5] * worldPt.z) / cameraPt.z;
        double zDot_div_z2 = (Rj.data[6] * worldPt.x + Rj.data[7] * worldPt.y + Rj.data[8] * worldPt.z) / (cameraPt.z * cameraPt.z);
        this.output[this.indexX++] = -zDot_div_z2 * cameraPt.x + Rx;
        this.output[this.indexY++] = -zDot_div_z2 * cameraPt.y + Ry;
    }

    private void addTranslationJacobian(Point3D_F64 cameraPt) {
        double divZ = 1.0 / cameraPt.z;
        double divZ2 = 1.0 / (cameraPt.z * cameraPt.z);
        this.output[this.indexX++] = divZ;
        this.output[this.indexY++] = 0.0;
        this.output[this.indexX++] = 0.0;
        this.output[this.indexY++] = divZ;
        this.output[this.indexX++] = -cameraPt.x * divZ2;
        this.output[this.indexY++] = -cameraPt.y * divZ2;
    }

    private void addTranslationJacobian(DMatrixRMaj R, Point3D_F64 cameraPt) {
        double z = cameraPt.z;
        double z2 = z * z;
        this.output[this.indexX++] = R.get(0, 0) / cameraPt.z - R.get(2, 0) / z2 * cameraPt.x;
        this.output[this.indexY++] = R.get(1, 0) / cameraPt.z - R.get(2, 0) / z2 * cameraPt.y;
        this.output[this.indexX++] = R.get(0, 1) / cameraPt.z - R.get(2, 1) / z2 * cameraPt.x;
        this.output[this.indexY++] = R.get(1, 1) / cameraPt.z - R.get(2, 1) / z2 * cameraPt.y;
        this.output[this.indexX++] = R.get(0, 2) / cameraPt.z - R.get(2, 2) / z2 * cameraPt.x;
        this.output[this.indexY++] = R.get(1, 2) / cameraPt.z - R.get(2, 2) / z2 * cameraPt.y;
    }
}

