/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.abst.tracker.PointTrack;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.sfm.d3.VisOdomMonoDepthPnP;
import boofcv.alg.sfm.d3.structure.VisOdomBundleAdjustment;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.sfm.Point2D3DTrack;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class VisOdomPixelDepthPnP_to_DepthVisualOdometry<Vis extends ImageBase<Vis>, Depth extends ImageGray<Depth>>
implements DepthVisualOdometry<Vis, Depth>,
AccessPointTracks3D {
    DepthSparse3D<Depth> sparse3D;
    VisOdomMonoDepthPnP<Vis> alg;
    DistanceFromModelMultiView<Se3_F64, Point2D3D> distance;
    ImageType<Vis> visualType;
    Class<Depth> depthType;
    boolean success;
    List<PointTrack> active = new ArrayList<PointTrack>();
    long frameID;

    public VisOdomPixelDepthPnP_to_DepthVisualOdometry(DepthSparse3D<Depth> sparse3D, VisOdomMonoDepthPnP<Vis> alg, DistanceFromModelMultiView<Se3_F64, Point2D3D> distance, ImageType<Vis> visualType, Class<Depth> depthType) {
        this.sparse3D = sparse3D;
        this.alg = alg;
        this.distance = distance;
        this.visualType = visualType;
        this.depthType = depthType;
    }

    @Override
    public boolean getTrackWorld3D(int index, Point3D_F64 world) {
        try {
            Point4D_F64 p = ((VisOdomBundleAdjustment.BTrack)this.active.get((int)index).getCookie()).worldLoc;
            world.setTo(p.x / p.w, p.y / p.w, p.z / p.w);
            return true;
        }
        catch (RuntimeException runtimeException) {
            world.setTo((GeoTuple3D_F64)((Point2D3D)this.active.get(index).getCookie()).getLocation());
            return true;
        }
    }

    @Override
    public int getTotalTracks() {
        return this.active.size();
    }

    @Override
    public long getTrackId(int index) {
        return this.active.get((int)index).featureId;
    }

    @Override
    public void getTrackPixel(int index, Point2D_F64 pixel) {
        pixel.setTo((GeoTuple2D_F64)this.active.get((int)index).pixel);
    }

    @Override
    public List<Point2D_F64> getAllTracks(@Nullable List<Point2D_F64> storage) {
        return PointTrack.extractTrackPixels(storage, this.active);
    }

    @Override
    public boolean isTrackInlier(int index) {
        try {
            Point2D3DTrack t = (Point2D3DTrack)((Object)this.active.get(index).getCookie());
            return t.lastInlier == this.alg.getFrameID();
        }
        catch (RuntimeException t) {
            VisOdomMonoDepthPnP.Track t2 = (VisOdomMonoDepthPnP.Track)this.active.get(index).getCookie();
            return t2.lastUsed == this.alg.getFrameID();
        }
    }

    @Override
    public boolean isTrackNew(int index) {
        return this.active.get((int)index).spawnFrameID == this.frameID;
    }

    @Override
    public void setCalibration(CameraPinholeBrown paramVisual, Point2Transform2_F32 visToDepth) {
        PointToPixelTransform_F32 visToDepth_pixel = new PointToPixelTransform_F32(visToDepth);
        this.sparse3D.configure(LensDistortionFactory.narrow((CameraModel)paramVisual), (PixelTransform<Point2D_F32>)visToDepth_pixel);
        this.alg.setCamera(paramVisual);
        this.distance.setIntrinsic(0, (CameraPinhole)paramVisual);
    }

    @Override
    public boolean process(Vis visual, Depth depth) {
        this.sparse3D.setDepthImage(depth);
        this.success = this.alg.process(visual);
        this.frameID = this.alg.getFrameID();
        this.active.clear();
        this.alg.getTracker().getActiveTracks(this.active);
        return this.success;
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return !this.success;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getCurrentToWorld();
    }

    @Override
    public long getFrameID() {
        return this.alg.getFrameID();
    }

    @Override
    public ImageType<Vis> getVisualType() {
        return this.visualType;
    }

    @Override
    public Class<Depth> getDepthType() {
        return this.depthType;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.alg.setVerbose(out, configuration);
    }
}

