/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.abst.disparity.StereoDisparity;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.BundleCameraState;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.rectify.DisparityParameters;
import boofcv.alg.mvs.BundleToRectificationStereoParameters;
import boofcv.alg.mvs.CreateCloudFromDisparityImages;
import boofcv.alg.mvs.MultiBaselineStereoIndependent;
import boofcv.alg.mvs.ScoreRectifiedViewCoveragePixels;
import boofcv.alg.mvs.StereoPairGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.LookUpImages;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.PointToPixelTransform_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class MultiViewStereoFromKnownSceneStructure<T extends ImageGray<T>>
implements VerbosePrint {
    public double minimumQuality3D = 0.05;
    public double maximumCenterOverlap = 0.8;
    public int maxCombinePairs = 10;
    @Nullable
    protected Listener<T> listener;
    protected final List<ViewInfo> listCenters = new ArrayList<ViewInfo>();
    protected LookUpImages imageLookUp;
    final ScoreRectifiedViewCoveragePixels scoreCoverage = new ScoreRectifiedViewCoveragePixels();
    final BundleToRectificationStereoParameters computeRectification = new BundleToRectificationStereoParameters();
    final MultiBaselineStereoIndependent<T> computeFused;
    final CreateCloudFromDisparityImages disparityCloud = new CreateCloudFromDisparityImages();
    final Map<String, ViewInfo> mapScores = new HashMap<String, ViewInfo>();
    final DogArray<ViewInfo> arrayScores = new DogArray(ViewInfo::new, ViewInfo::reset);
    TIntObjectMap<String> indexSbaToViewID = new TIntObjectHashMap();
    DogArray_I32 imagePairIndexesSba = new DogArray_I32();
    CameraPinholeBrown brown = new CameraPinholeBrown();
    Se3_F64 world_to_view1 = new Se3_F64();
    Se3_F64 world_to_view2 = new Se3_F64();
    Se3_F64 view1_to_view2 = new Se3_F64();
    Se3_F64 tmp = new Se3_F64();
    final ImageType<T> imageType;
    @Nullable
    PrintStream verbose = null;

    public MultiViewStereoFromKnownSceneStructure(LookUpImages imageLookUp, ImageType<T> imageType) {
        this.computeFused = new MultiBaselineStereoIndependent(imageLookUp, imageType);
        this.imageLookUp = imageLookUp;
        this.imageType = imageType;
    }

    public MultiViewStereoFromKnownSceneStructure(ImageType<T> imageType) {
        this.computeFused = new MultiBaselineStereoIndependent(imageType);
        this.imageType = imageType;
    }

    public void process(SceneStructureMetric scene, @Nullable SceneObservations observations, StereoPairGraph pairs) {
        this.initializeListener();
        this.initializeScores(scene, pairs);
        this.scoreViewsSelectStereoPairs(scene, observations);
        this.disparityCloud.reset();
        this.listCenters.clear();
        Collections.sort(this.arrayScores.toList(), Comparator.comparingDouble(a -> -a.score));
        this.pruneViewsThatAreSimilarByNeighbors(scene, observations);
        for (int index = 0; index < this.arrayScores.size; ++index) {
            ViewInfo center = (ViewInfo)this.arrayScores.get(index);
            if (center.used) continue;
            if (this.verbose != null) {
                this.verbose.println("Center[" + index + "] View='" + center.relations.id + "'");
            }
            this.selectAndLoadConnectedImages(pairs, center.relations);
            if (this.imagePairIndexesSba.size() < 1) {
                if (this.verbose == null) continue;
                this.verbose.println("_ too few connections to use as a center");
                continue;
            }
            this.listCenters.add(center);
            this.indexSbaToViewID.put(center.relations.indexSba, (Object)center.relations.id);
            if (this.computeFusedDisparityAddCloud(scene, observations, center, this.indexSbaToViewID, this.imagePairIndexesSba)) continue;
            this.listCenters.remove(this.listCenters.size() - 1);
            this.indexSbaToViewID.remove(center.relations.indexSba);
        }
    }

    void initializeListener() {
        Objects.requireNonNull(this.computeFused.getStereoDisparity(), "Must call setStereoDisparity() first");
        if (this.listener != null) {
            Listener<T> _listener = this.listener;
            this.computeFused.setListener((left, right, rectLeft, rectRight, disparity, parameters, rect) -> {
                String leftID = (String)this.indexSbaToViewID.get(left);
                String rightID = (String)this.indexSbaToViewID.get(right);
                _listener.handlePairDisparity(leftID, rightID, rectLeft, rectRight, disparity, parameters);
            });
        } else {
            this.computeFused.setListener(null);
        }
    }

    void initializeScores(SceneStructureMetric scene, StereoPairGraph stereoPairs) {
        this.arrayScores.resize(stereoPairs.vertexes.size());
        this.arrayScores.reset();
        this.mapScores.clear();
        for (StereoPairGraph.Vertex node : stereoPairs.vertexes.values()) {
            ViewInfo info = (ViewInfo)this.arrayScores.grow();
            info.metric = (SceneStructureMetric.View)scene.views.get(node.indexSba);
            this.imageLookUp.loadShape(node.id, info.dimension);
            info.index = this.arrayScores.size - 1;
            info.relations = node;
            this.mapScores.put(info.relations.id, info);
        }
    }

    void scoreViewsSelectStereoPairs(SceneStructureMetric scene, @Nullable SceneObservations observations) {
        for (int i = 0; i < this.arrayScores.size; ++i) {
            ViewInfo center = (ViewInfo)this.arrayScores.get(i);
            List<StereoPairGraph.Edge> pairs = center.relations.pairs;
            BundleAdjustmentCamera candidateCamera = ((SceneStructureCommon.Camera)scene.cameras.get((int)center.metric.camera)).model;
            BundleCameraState candidateState = observations != null ? observations.getView((int)center.index).cameraState : null;
            this.computeRectification.setView1(candidateCamera, candidateState, center.dimension.width, center.dimension.height);
            this.scoreCoverage.initialize(center.dimension.width, center.dimension.height, this.computeRectification.view1_dist_to_undist);
            scene.getWorldToView(center.metric, this.world_to_view1, this.tmp);
            int totalQualifiedConnections = 0;
            double averageQuality = 0.0;
            for (int pairIdx = 0; pairIdx < pairs.size(); ++pairIdx) {
                StereoPairGraph.Edge pair = pairs.get(pairIdx);
                BoofMiscOps.checkTrue((pair.quality3D >= 0.0 && pair.quality3D <= 1.0 ? 1 : 0) != 0);
                if (pair.quality3D < this.minimumQuality3D) continue;
                ++totalQualifiedConnections;
                averageQuality += pair.quality3D;
                ViewInfo connected = Objects.requireNonNull(this.mapScores.get(pair.other((StereoPairGraph.Vertex)center.relations).id));
                BundleAdjustmentCamera connectedCamera = ((SceneStructureCommon.Camera)scene.cameras.get((int)connected.metric.camera)).model;
                BundleCameraState connectedState = observations != null ? observations.getView((int)connected.index).cameraState : null;
                scene.getWorldToView(connected.metric, this.world_to_view2, this.tmp);
                this.world_to_view1.invert(this.tmp).concat(this.world_to_view2, this.view1_to_view2);
                this.computeRectification.processView2(connectedCamera, connectedState, connected.dimension.width, connected.dimension.height, this.view1_to_view2);
                this.scoreCoverage.addView(connected.dimension.width, connected.dimension.height, this.computeRectification.undist_to_rect2, (float)pair.quality3D, Float::sum);
            }
            this.scoreCoverage.process();
            center.score = this.scoreCoverage.getScore();
            if (this.verbose == null) continue;
            averageQuality = totalQualifiedConnections > 0 ? averageQuality / (double)totalQualifiedConnections : -1.0;
            this.verbose.printf("View[%s] center score=%5.2f aveQuality=%.2f conn=%d/%d\n", center.relations.id, center.score, averageQuality, totalQualifiedConnections, pairs.size());
        }
    }

    protected void pruneViewsThatAreSimilarByNeighbors(SceneStructureMetric scene, @Nullable SceneObservations observations) {
        for (int rankIndex = 0; rankIndex < this.arrayScores.size; ++rankIndex) {
            ViewInfo center = (ViewInfo)this.arrayScores.get(rankIndex);
            List<StereoPairGraph.Edge> pairs = center.relations.pairs;
            BundleAdjustmentCamera candidateCamera = ((SceneStructureCommon.Camera)scene.cameras.get((int)center.metric.camera)).model;
            BundleCameraState candidateState = observations != null ? observations.getView((int)center.index).cameraState : null;
            this.computeRectification.setView1(candidateCamera, candidateState, center.dimension.width, center.dimension.height);
            this.scoreCoverage.initialize(center.dimension.width, center.dimension.height, this.computeRectification.view1_dist_to_undist);
            scene.getWorldToView(center.metric, this.world_to_view1, this.tmp);
            boolean tooSimilar = false;
            for (int pairIdx = 0; pairIdx < pairs.size(); ++pairIdx) {
                double intersection;
                StereoPairGraph.Edge pair = pairs.get(pairIdx);
                ViewInfo connected = Objects.requireNonNull(this.mapScores.get(pair.other((StereoPairGraph.Vertex)center.relations).id));
                if (connected.used || connected.score < center.score || connected.score == center.score && connected.relations.id.compareTo(center.relations.id) < 0 || !((intersection = this.computeIntersection(scene, observations, connected)) > this.maximumCenterOverlap)) continue;
                tooSimilar = true;
                if (this.verbose == null) break;
                this.verbose.printf("excluding view['%s'] because view['%s'] covered %.2f\n", center.relations.id, connected.relations.id, intersection);
                break;
            }
            if (!tooSimilar) continue;
            center.used = true;
        }
    }

    protected double computeIntersection(SceneStructureMetric scene, @Nullable SceneObservations observations, ViewInfo connected) {
        BundleAdjustmentCamera connectedCamera = ((SceneStructureCommon.Camera)scene.cameras.get((int)connected.metric.camera)).model;
        scene.getWorldToView(connected.metric, this.world_to_view2, this.tmp);
        this.world_to_view1.invert(this.tmp).concat(this.world_to_view2, this.view1_to_view2);
        BundleCameraState state = observations != null ? observations.getView((int)connected.index).cameraState : null;
        this.computeRectification.processView2(connectedCamera, state, connected.dimension.width, connected.dimension.height, this.view1_to_view2);
        return this.scoreCoverage.fractionIntersection(connected.dimension.width, connected.dimension.height, this.computeRectification.undist_to_rect2);
    }

    boolean computeFusedDisparityAddCloud(SceneStructureMetric scene, @Nullable SceneObservations observations, ViewInfo center, TIntObjectMap<String> sbaIndexToName, DogArray_I32 pairIndexes) {
        if (!this.computeFused.process(scene, observations, center.relations.indexSba, pairIndexes, arg_0 -> sbaIndexToName.get(arg_0))) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: fused disparity. center.index=" + center.index);
            }
            return false;
        }
        GrayF32 inverseDepth = this.computeFused.fusedInvDepth;
        if (this.listener != null) {
            this.listener.handleFused(center.relations.id, inverseDepth);
        }
        BundleAdjustmentCamera camera = ((SceneStructureCommon.Camera)scene.cameras.get((int)center.metric.camera)).model;
        BundleCameraState state = observations != null ? observations.getView((int)center.index).cameraState : null;
        BundleAdjustmentOps.convert((BundleAdjustmentCamera)camera, (BundleCameraState)state, (int)inverseDepth.width, (int)inverseDepth.height, (CameraPinholeBrown)this.brown);
        Point2Transform2_F64 norm_to_pixel = new LensDistortionBrown(this.brown).distort_F64(false, true);
        Point2Transform2_F64 pixel_to_norm = new LensDistortionBrown(this.brown).undistort_F64(true, false);
        scene.getWorldToView(center.metric, this.world_to_view1, this.tmp);
        this.disparityCloud.addInverseDepth(inverseDepth, this.world_to_view1, norm_to_pixel, (PixelTransform)new PointToPixelTransform_F64(pixel_to_norm));
        if (this.verbose != null) {
            this.verbose.println("fused cloud.size=" + this.disparityCloud.cloud.size);
        }
        return true;
    }

    void selectAndLoadConnectedImages(StereoPairGraph pairs, StereoPairGraph.Vertex center) {
        this.indexSbaToViewID.clear();
        this.imagePairIndexesSba.reset();
        List<StereoPairGraph.Edge> connections = Objects.requireNonNull(pairs.vertexes.get((Object)center.id)).pairs;
        ArrayList<StereoPairGraph.Edge> connectionsSorted = new ArrayList<StereoPairGraph.Edge>(connections);
        Collections.sort(connectionsSorted, Comparator.comparingDouble(a -> -a.quality3D));
        int totalConsider = Math.min(this.maxCombinePairs, connectionsSorted.size());
        for (int connIdx = 0; connIdx < totalConsider; ++connIdx) {
            StereoPairGraph.Edge connected = (StereoPairGraph.Edge)connectionsSorted.get(connIdx);
            if (connected.quality3D < this.minimumQuality3D) continue;
            StereoPairGraph.Vertex other = connected.other(center);
            this.indexSbaToViewID.put(other.indexSba, (Object)other.id);
            this.imagePairIndexesSba.add(other.indexSba);
        }
        if (this.verbose != null) {
            this.verbose.print("_ connected: consider=" + totalConsider + " views=[");
            for (String id : this.indexSbaToViewID.valueCollection()) {
                this.verbose.print(" '" + id + "'");
            }
            if (this.verbose != null) {
                this.verbose.println(" ].size=" + this.indexSbaToViewID.size());
            }
        }
    }

    public List<Point3D_F64> getCloud() {
        return this.disparityCloud.cloud.toList();
    }

    public void setStereoDisparity(StereoDisparity<T, GrayF32> stereoDisparity) {
        this.computeFused.setStereoDisparity(stereoDisparity);
    }

    public void setImageLookUp(LookUpImages imageLookUp) {
        this.computeFused.setLookUpImages(imageLookUp);
        this.imageLookUp = imageLookUp;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.computeFused});
    }

    public double getMinimumQuality3D() {
        return this.minimumQuality3D;
    }

    public void setMinimumQuality3D(double minimumQuality3D) {
        this.minimumQuality3D = minimumQuality3D;
    }

    public double getMaximumCenterOverlap() {
        return this.maximumCenterOverlap;
    }

    public void setMaximumCenterOverlap(double maximumCenterOverlap) {
        this.maximumCenterOverlap = maximumCenterOverlap;
    }

    public int getMaxCombinePairs() {
        return this.maxCombinePairs;
    }

    public void setMaxCombinePairs(int maxCombinePairs) {
        this.maxCombinePairs = maxCombinePairs;
    }

    @Nullable
    public Listener<T> getListener() {
        return this.listener;
    }

    public void setListener(@Nullable Listener<T> listener) {
        this.listener = listener;
    }

    public List<ViewInfo> getListCenters() {
        return this.listCenters;
    }

    public LookUpImages getImageLookUp() {
        return this.imageLookUp;
    }

    public ScoreRectifiedViewCoveragePixels getScoreCoverage() {
        return this.scoreCoverage;
    }

    public BundleToRectificationStereoParameters getComputeRectification() {
        return this.computeRectification;
    }

    public MultiBaselineStereoIndependent<T> getComputeFused() {
        return this.computeFused;
    }

    public CreateCloudFromDisparityImages getDisparityCloud() {
        return this.disparityCloud;
    }

    public ImageType<T> getImageType() {
        return this.imageType;
    }

    public static class ViewInfo {
        SceneStructureMetric.View metric;
        StereoPairGraph.Vertex relations;
        final ImageDimension dimension = new ImageDimension();
        int index;
        double score;
        boolean used;

        void reset() {
            this.metric = null;
            this.relations = null;
            this.dimension.setTo(0, 0);
            this.index = -1;
            this.score = -1.0;
            this.used = false;
        }
    }

    public static interface Listener<RectImg> {
        public void handlePairDisparity(String var1, String var2, RectImg var3, RectImg var4, GrayF32 var5, DisparityParameters var6);

        public void handleFused(String var1, GrayF32 var2);
    }
}

