/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.geo.GeoModelEstimator1;
import boofcv.struct.geo.GeoModelEstimatorN;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class PnPStereoEstimator
implements GeoModelEstimator1<Se3_F64, Stereo2D3D> {
    private final GeoModelEstimatorN<Se3_F64, Point2D3D> alg;
    private final DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceLeft;
    private final DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceRight;
    private final DogArray<Point2D3D> monoPoints = new DogArray(10, Point2D3D::new);
    private Se3_F64 leftToRight = new Se3_F64();
    private final Se3_F64 worldToRight = new Se3_F64();
    private final DogArray<Se3_F64> solutions = new DogArray(4, Se3_F64::new);
    int extraForTest;

    public PnPStereoEstimator(GeoModelEstimatorN<Se3_F64, Point2D3D> alg, DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceLeft, DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceRight, int extraForTest) {
        this.alg = alg;
        this.distanceLeft = distanceLeft;
        this.distanceRight = distanceRight;
        this.extraForTest = extraForTest;
    }

    public void setLeftToRight(Se3_F64 leftToRight) {
        this.leftToRight.setTo(leftToRight);
    }

    public void setLeftToRightReference(Se3_F64 leftToRight) {
        this.leftToRight = leftToRight;
    }

    public boolean process(List<Stereo2D3D> points, Se3_F64 estimatedModel) {
        int N = this.alg.getMinimumPoints();
        this.monoPoints.reset();
        for (int i = 0; i < N; ++i) {
            Stereo2D3D s = points.get(i);
            Point2D3D p = (Point2D3D)this.monoPoints.grow();
            p.observation = s.leftObs;
            p.location = s.location;
        }
        this.solutions.reset();
        this.alg.process(this.monoPoints.toList(), this.solutions);
        Point2D3D p = (Point2D3D)this.monoPoints.get(0);
        Se3_F64 bestMotion = null;
        double bestError = Double.MAX_VALUE;
        for (int i = 0; i < this.solutions.size; ++i) {
            Stereo2D3D s;
            int j;
            Se3_F64 worldToLeft = ((Se3_F64[])this.solutions.data)[i];
            double totalError = 0.0;
            this.distanceLeft.setModel((Object)worldToLeft);
            for (j = N; j < points.size(); ++j) {
                s = points.get(i);
                p.observation = s.leftObs;
                p.location = s.location;
                totalError += this.distanceLeft.distance((Object)p);
            }
            worldToLeft.concat(this.leftToRight, this.worldToRight);
            this.distanceRight.setModel((Object)this.worldToRight);
            for (j = 0; j < points.size(); ++j) {
                s = points.get(j);
                p.observation = s.rightObs;
                p.location = s.location;
                totalError += this.distanceRight.distance((Object)p);
            }
            if (!(totalError < bestError)) continue;
            bestError = totalError;
            bestMotion = worldToLeft;
        }
        if (bestMotion == null) {
            return false;
        }
        estimatedModel.setTo(bestMotion);
        return true;
    }

    public void setStereoParameters(StereoParameters param) {
        param.right_to_left.invert(this.leftToRight);
        this.distanceLeft.setIntrinsic(0, (CameraPinhole)param.left);
        this.distanceRight.setIntrinsic(0, (CameraPinhole)param.right);
    }

    public int getMinimumPoints() {
        return this.alg.getMinimumPoints() + this.extraForTest;
    }
}

