/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3.direct;

import boofcv.abst.sfm.ImagePixelTo3D;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.sfm.d3.direct.VisOdomDirectColorDepth;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import boofcv.struct.pyramid.ImagePyramid;
import georegression.struct.se.Se3_F32;
import lombok.Generated;

public class PyramidDirectColorDepth<T extends ImageGray<T>> {
    private final ImageType<Planar<T>> imageType;
    private final ImagePyramid<Planar<T>> pyramid;
    private VisOdomDirectColorDepth<T, ?>[] layersOdom;
    private double diversityThreshold = 0.75;
    private double keyframeDiversity;
    private double diversity;
    private double fractionInBounds = 0.0;
    private final LayerTo3D layerTo3D;
    private final Se3_F32 worldToKey = new Se3_F32();
    private final Se3_F32 keyToCurrent = new Se3_F32();
    private final Se3_F32 work = new Se3_F32();
    private final Se3_F32 worldToCurrent = new Se3_F32();
    private long frameID = -1L;

    public PyramidDirectColorDepth(ImagePyramid<Planar<T>> pyramid) {
        this.pyramid = pyramid;
        this.imageType = this.pyramid.getImageType();
        this.layerTo3D = new LayerTo3D();
    }

    public void setCameraParameters(float fx, float fy, float cx, float cy, int width, int height) {
        this.pyramid.initialize(width, height);
        this.layersOdom = new VisOdomDirectColorDepth[this.pyramid.getNumLayers()];
        for (int i = 0; i < this.layersOdom.length; ++i) {
            ImageType derivType = GImageDerivativeOps.getDerivativeType(this.imageType);
            this.layersOdom[i] = new VisOdomDirectColorDepth(this.imageType.getNumBands(), this.imageType.getImageClass(), derivType.getImageClass());
        }
        for (int layer = 0; layer < this.layersOdom.length; ++layer) {
            VisOdomDirectColorDepth<T, ?> o = this.layersOdom[layer];
            int layerWidth = this.pyramid.getWidth(layer);
            int layerHeight = this.pyramid.getHeight(layer);
            float scale = (float)this.pyramid.getScale(layer);
            o.setCameraParameters(fx / scale, fy / scale, cx / scale, cy / scale, layerWidth, layerHeight);
        }
    }

    public boolean process(Planar<T> input, ImagePixelTo3D inputDepth) {
        this.pyramid.process(input);
        ++this.frameID;
        if (this.fractionInBounds == 0.0) {
            this.setKeyFrame(inputDepth);
            this.fractionInBounds = 1.0;
        } else if (this.estimateMotion()) {
            boolean keyframeTriggered = false;
            if (this.diversity < this.keyframeDiversity * this.diversityThreshold) {
                keyframeTriggered = true;
            }
            if (this.fractionInBounds < 0.5) {
                keyframeTriggered = true;
            }
            if (keyframeTriggered) {
                this.setKeyFrame(inputDepth);
            }
        } else {
            return false;
        }
        return true;
    }

    protected void setKeyFrame(ImagePixelTo3D inputDepth) {
        this.layerTo3D.wrap(inputDepth);
        for (int layer = 0; layer < this.layersOdom.length; ++layer) {
            Planar layerImage = (Planar)this.pyramid.getLayer(layer);
            this.layerTo3D.scale = this.pyramid.getScale(layer);
            this.layersOdom[layer].setKeyFrame(layerImage, this.layerTo3D);
        }
        this.worldToKey.concat(this.keyToCurrent, this.work);
        this.worldToKey.setTo(this.work);
        this.keyToCurrent.reset();
        this.keyframeDiversity = this.layersOdom[this.layersOdom.length - 1].computeFeatureDiversity(this.keyToCurrent);
    }

    protected boolean estimateMotion() {
        Planar layerImage;
        VisOdomDirectColorDepth<T, ?> o;
        this.work.setTo(this.keyToCurrent);
        boolean oneLayerWorked = false;
        for (int layer = this.layersOdom.length - 1; layer >= 0 && (o = this.layersOdom[layer]).estimateMotion(layerImage = (Planar)this.pyramid.getLayer(layer), this.work); --layer) {
            oneLayerWorked = true;
            this.work.setTo(o.getKeyToCurrent());
            this.fractionInBounds = (double)o.getInboundsPixels() / (double)o.getKeyframePixels();
        }
        if (oneLayerWorked) {
            this.keyToCurrent.setTo(this.work);
            this.worldToKey.concat(this.keyToCurrent, this.worldToCurrent);
            this.diversity = this.layersOdom[this.layersOdom.length - 1].computeFeatureDiversity(this.keyToCurrent);
        }
        return oneLayerWorked;
    }

    public boolean isFatalError() {
        return false;
    }

    public Se3_F32 worldToCurrent() {
        return this.worldToCurrent;
    }

    public ImageType<Planar<T>> getInputType() {
        return this.imageType;
    }

    public void reset() {
        this.fractionInBounds = 0.0;
        this.keyToCurrent.reset();
        this.worldToCurrent.reset();
    }

    public void setDiversityThreshold(double diversityThreshold) {
        this.diversityThreshold = diversityThreshold;
    }

    public double getFractionInBounds() {
        return this.fractionInBounds;
    }

    @Generated
    public long getFrameID() {
        return this.frameID;
    }

    public static class LayerTo3D
    implements ImagePixelTo3D {
        ImagePixelTo3D orig;
        public double scale;

        public void wrap(ImagePixelTo3D orig) {
            this.orig = orig;
        }

        @Override
        public boolean process(double x, double y) {
            return this.orig.process((x + 0.5) * this.scale, (y + 0.5) * this.scale);
        }

        @Override
        public double getX() {
            return this.orig.getX();
        }

        @Override
        public double getY() {
            return this.orig.getY();
        }

        @Override
        public double getZ() {
            return this.orig.getZ();
        }

        @Override
        public double getW() {
            return this.orig.getW();
        }
    }
}

