/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.JavaRuntimeLauncher;
import boofcv.gui.ProcessTabPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class ApplicationLauncherApp
extends JPanel
implements ActionListener,
ListDataListener {
    private JTree tree;
    JButton bKill = new JButton("Kill");
    JCheckBox checkRemoveOnDeath = new JCheckBox("Auto Remove");
    JButton bKillAll = new JButton("Kill All");
    JList processList;
    DefaultListModel<ActiveProcess> listModel = new DefaultListModel();
    JTabbedPane outputPanel = new JTabbedPane();
    int memoryMB = 1024;
    final List<ActiveProcess> processes = new ArrayList<ActiveProcess>();
    boolean defaultRemoveTabOnDeath;

    public ApplicationLauncherApp(boolean defaultRemoveTabOnDeath) {
        this.setLayout(new BorderLayout());
        this.checkRemoveOnDeath.setSelected(defaultRemoveTabOnDeath);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("All Categories");
        this.createTree(root);
        this.tree = new JTree(root);
        this.tree.getSelectionModel().setSelectionMode(1);
        final JTextField searchBox = new JTextField();
        searchBox.setToolTipText("Search");
        searchBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefaultMutableTreeNode selection;
                String text = searchBox.getText();
                TreePath path = ApplicationLauncherApp.this.searchTree(text, selection = (DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getModel().getRoot(), true);
                if (path != null) {
                    ApplicationLauncherApp.this.tree.setSelectionPath(path);
                    ApplicationLauncherApp.this.tree.scrollPathToVisible(path);
                } else {
                    ApplicationLauncherApp.this.tree.setSelectionPath(null);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefaultMutableTreeNode selection;
                String text = searchBox.getText();
                TreePath path = ApplicationLauncherApp.this.searchTree(text, selection = (DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getModel().getRoot(), true);
                if (path != null) {
                    ApplicationLauncherApp.this.tree.setSelectionPath(path);
                    ApplicationLauncherApp.this.tree.scrollPathToVisible(path);
                } else {
                    ApplicationLauncherApp.this.tree.setSelectionPath(null);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        KeyStroke down = KeyStroke.getKeyStroke(40, 0, true);
        KeyStroke up = KeyStroke.getKeyStroke(38, 0, true);
        AbstractAction nextSearch = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode currentSelection;
                DefaultMutableTreeNode defaultMutableTreeNode = currentSelection = ApplicationLauncherApp.this.tree.getLastSelectedPathComponent() != null ? (DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getLastSelectedPathComponent() : (DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getModel().getRoot();
                if (currentSelection != null && searchBox.getText() != null) {
                    TreePath path = ApplicationLauncherApp.this.searchTree(searchBox.getText(), currentSelection, true);
                    if (path != null) {
                        ApplicationLauncherApp.this.tree.setSelectionPath(path);
                        ApplicationLauncherApp.this.tree.scrollPathToVisible(path);
                    } else {
                        ApplicationLauncherApp.this.tree.setSelectionPath(null);
                    }
                }
            }
        };
        AbstractAction prevSearch = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode currentSelection;
                DefaultMutableTreeNode defaultMutableTreeNode = currentSelection = ApplicationLauncherApp.this.tree.getLastSelectedPathComponent() != null ? (DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getLastSelectedPathComponent() : (DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getModel().getRoot();
                if (currentSelection != null && searchBox.getText() != null) {
                    TreePath path = ApplicationLauncherApp.this.searchTree(searchBox.getText(), currentSelection, false);
                    if (path != null) {
                        ApplicationLauncherApp.this.tree.setSelectionPath(path);
                        ApplicationLauncherApp.this.tree.scrollPathToVisible(path);
                    } else {
                        ApplicationLauncherApp.this.tree.setSelectionPath(null);
                    }
                }
            }
        };
        searchBox.getInputMap().put(down, "nextSearch");
        searchBox.getActionMap().put("nextSearch", nextSearch);
        searchBox.getInputMap().put(up, "prevSearch");
        searchBox.getActionMap().put("prevSearch", prevSearch);
        searchBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode selection = (DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getLastSelectedPathComponent();
                if (selection != null) {
                    ApplicationLauncherApp.this.handleClick(selection);
                }
                System.out.println("action");
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ApplicationLauncherApp.this.handleClick((DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getLastSelectedPathComponent());
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    ApplicationLauncherApp.this.handleContextMenu(ApplicationLauncherApp.this.tree, e.getX(), e.getY());
                }
            }
        };
        this.tree.addMouseListener(ml);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.add(new JLabel("Search"));
        searchPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        searchPanel.add(searchBox);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)searchPanel, "North");
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(300, 600));
        leftPanel.add((Component)treeView, "Center");
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new BoxLayout(actionPanel, 0));
        actionPanel.add(this.bKill);
        actionPanel.add(this.checkRemoveOnDeath);
        actionPanel.add(Box.createHorizontalGlue());
        actionPanel.add(this.bKillAll);
        this.bKill.addActionListener(this);
        this.bKillAll.addActionListener(this);
        this.processList = new JList<ActiveProcess>(this.listModel);
        this.processList.setSelectionMode(1);
        this.processList.setLayoutOrientation(0);
        this.processList.setVisibleRowCount(-1);
        this.processList.getModel().addListDataListener(this);
        this.processList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ActiveProcess process = (ActiveProcess)value;
                if (!process.isAlive()) {
                    c.setForeground(Color.RED);
                }
                return c;
            }
        });
        JPanel processPanel = new JPanel();
        processPanel.setLayout(new BorderLayout());
        processPanel.add((Component)actionPanel, "North");
        processPanel.add((Component)this.processList, "Center");
        JSplitPane verticalSplitPane = new JSplitPane(0, processPanel, this.outputPanel);
        verticalSplitPane.setDividerLocation(150);
        verticalSplitPane.setResizeWeight(0.0);
        JSplitPane horizontalSplitPane = new JSplitPane(1, leftPanel, verticalSplitPane);
        horizontalSplitPane.setDividerLocation(250);
        horizontalSplitPane.setResizeWeight(0.0);
        this.add((Component)horizontalSplitPane, "Center");
        new ProcessStatusThread().start();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.setPreferredSize(new Dimension(gd.getDisplayMode().getWidth(), 600));
    }

    protected abstract void createTree(DefaultMutableTreeNode var1);

    protected void createNodes(DefaultMutableTreeNode root, String subjectName, Class ... apps) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(subjectName);
        for (int i = 0; i < apps.length; ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new AppInfo(apps[i]));
            top.add(node);
        }
        root.add(top);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch(AppInfo info) {
        URL[] urls;
        ArrayList<String> classPath = new ArrayList<String>();
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
            classPath.add(url.getFile());
        }
        final ActiveProcess process = new ActiveProcess();
        process.info = info;
        process.launcher = new JavaRuntimeLauncher(classPath);
        process.launcher.setFrozenTime(-1L);
        process.launcher.setMemoryInMB(this.memoryMB);
        List<ActiveProcess> list = this.processes;
        synchronized (list) {
            this.processes.add(process);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationLauncherApp.this.listModel.addElement(process);
                ApplicationLauncherApp.this.processList.invalidate();
            }
        });
        process.start();
    }

    private TreePath searchTree(String text, DefaultMutableTreeNode node, boolean forward) {
        Enumeration e = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).breadthFirstEnumeration();
        if (!forward) {
            final Stack<TreeNode> tmp = new Stack<TreeNode>();
            while (e.hasMoreElements()) {
                tmp.push(e.nextElement());
            }
            e = new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return !tmp.isEmpty();
                }

                public Object nextElement() {
                    return tmp.pop();
                }
            };
        }
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!n.equals(node)) continue;
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode candidate = (DefaultMutableTreeNode)e.nextElement();
                if (!(candidate.getUserObject() instanceof AppInfo)) continue;
                AppInfo candidateInfo = (AppInfo)candidate.getUserObject();
                if (!candidateInfo.app.getSimpleName().toLowerCase().contains(text)) continue;
                return new TreePath(candidate.getPath());
            }
        }
        return null;
    }

    public void handleClick(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            return;
        }
        AppInfo info = (AppInfo)node.getUserObject();
        this.launch(info);
        System.out.println("clicked " + info);
    }

    private void handleContextMenu(JTree tree, int x, int y) {
        TreePath path = tree.getPathForLocation(x, y);
        tree.setSelectionPath(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            tree.setSelectionPath(null);
            return;
        }
        final AppInfo info = (AppInfo)node.getUserObject();
        JMenuItem copyname = new JMenuItem("Copy Name");
        copyname.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(info.app.getSimpleName()), null);
            }
        });
        JMenuItem copypath = new JMenuItem("Copy Path");
        copypath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = UtilIO.getSourcePath((String)info.app.getPackage().getName(), (String)info.app.getSimpleName());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(path), null);
            }
        });
        JMenuItem github = new JMenuItem("Go to Github");
        github.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationLauncherApp.this.openInGitHub(info);
            }
        });
        JPopupMenu submenu = new JPopupMenu();
        submenu.add(copyname);
        submenu.add(copypath);
        submenu.add(github);
        submenu.show(tree, x, y);
    }

    private void openInGitHub(AppInfo info) {
        if (Desktop.isDesktopSupported()) {
            try {
                URI uri = new URI(UtilIO.getGithubURL((String)info.app.getPackage().getName(), (String)info.app.getSimpleName()));
                if (!uri.getPath().isEmpty()) {
                    Desktop.getDesktop().browse(uri);
                } else {
                    System.err.println("Bad URL received");
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, "Open GitHub Error", "Error connecting: " + e1.getMessage(), 0);
                System.err.println(e1.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bKill) {
            ActiveProcess selected = (ActiveProcess)this.processList.getSelectedValue();
            if (selected == null) {
                return;
            }
            if (selected.isAlive()) {
                selected.requestKill();
            } else {
                this.removeProcessTab(selected, false);
            }
        } else if (e.getSource() == this.bKillAll) {
            this.killAllProcesses(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllProcesses(long blockTimeMS) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel model = (DefaultListModel)ApplicationLauncherApp.this.processList.getModel();
                for (int i = model.size() - 1; i >= 0; --i) {
                    ActiveProcess p = (ActiveProcess)model.get(i);
                    ApplicationLauncherApp.this.removeProcessTab(p, false);
                }
            }
        });
        List<ActiveProcess> list = this.processes;
        synchronized (list) {
            for (int i = 0; i < this.processes.size(); ++i) {
                this.processes.get(i).requestKill();
            }
        }
        if (blockTimeMS > 0L) {
            long abortTime = System.currentTimeMillis() + blockTimeMS;
            while (abortTime > System.currentTimeMillis()) {
                int total = 0;
                List<ActiveProcess> list2 = this.processes;
                synchronized (list2) {
                    for (int i = 0; i < this.processes.size(); ++i) {
                        if (this.processes.get(i).isActive()) continue;
                        ++total;
                    }
                    if (this.processes.size() == total) {
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        DefaultListModel listModel = (DefaultListModel)e.getSource();
        ActiveProcess process = (ActiveProcess)listModel.get(listModel.getSize() - 1);
        this.addProcessTab(process, this.outputPanel);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    private void displaySource(final JTextArea sourceTextArea, ActiveProcess process) {
        if (sourceTextArea == null) {
            return;
        }
        String path = UtilIO.getSourcePath((String)process.info.app.getPackage().getName(), (String)process.info.app.getSimpleName());
        File source = new File(path);
        String code = null;
        if (source.exists() && source.canRead()) {
            code = UtilIO.readAsString((String)path);
        } else {
            InputStream in = process.info.app.getResourceAsStream(process.info.app.getSimpleName() + ".java");
            code = UtilIO.readAsString((InputStream)in);
        }
        if (code != null) {
            sourceTextArea.setText(code);
            sourceTextArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (SwingUtilities.isRightMouseButton(e) && !sourceTextArea.getText().isEmpty()) {
                        JPopupMenu menu = new JPopupMenu();
                        JMenuItem copy = new JMenuItem("Copy");
                        copy.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                clipboard.setContents(new StringSelection(sourceTextArea.getText()), null);
                            }
                        });
                        menu.add(copy);
                        menu.show(sourceTextArea, e.getX(), e.getY());
                    }
                }
            });
        } else {
            sourceTextArea.setText("Source not found!");
        }
    }

    private void addProcessTab(final ActiveProcess process, JTabbedPane pane) {
        String title = process.info.app.getSimpleName();
        ProcessTabPanel component = new ProcessTabPanel(process.getId());
        final JTextArea sourceTextArea = new JTextArea();
        sourceTextArea.setFont(new Font("monospaced", 0, 12));
        sourceTextArea.setEditable(false);
        sourceTextArea.setLineWrap(true);
        sourceTextArea.setWrapStyleWord(true);
        final JTextArea outputTextArea = new JTextArea();
        outputTextArea.setFont(new Font("monospaced", 0, 12));
        outputTextArea.setEditable(false);
        outputTextArea.setLineWrap(true);
        outputTextArea.setWrapStyleWord(true);
        final JScrollPane container = new JScrollPane();
        container.setVerticalScrollBarPolicy(22);
        component.bOpenInGitHub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationLauncherApp.this.openInGitHub(process.info);
            }
        });
        component.options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                if (source.getSelectedIndex() == 0) {
                    container.getViewport().removeAll();
                    container.getViewport().add(sourceTextArea);
                    ApplicationLauncherApp.this.displaySource(sourceTextArea, process);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String code = sourceTextArea.getText();
                            int scrollTo = UtilIO.indexOfSourceStart((String)code);
                            sourceTextArea.setCaretPosition(scrollTo);
                        }
                    });
                } else if (source.getSelectedIndex() == 1) {
                    container.getViewport().removeAll();
                    container.getViewport().add(outputTextArea);
                }
            }
        });
        process.launcher.setPrintOut(new PrintStream(new TextOutputStream(outputTextArea, false)));
        process.launcher.setPrintErr(new PrintStream(new TextOutputStream(outputTextArea, false)));
        component.options.setSelectedIndex(1);
        component.add((Component)container, "Center");
        pane.add(title, component);
        pane.setSelectedIndex(pane.getComponentCount() - 1);
    }

    private void removeProcessTab(ActiveProcess process, boolean autoClose) {
        int index = -1;
        for (int i = 0; i < this.outputPanel.getComponents().length; ++i) {
            ProcessTabPanel component = (ProcessTabPanel)this.outputPanel.getComponent(i);
            if (component.getProcessId() != process.getId()) continue;
            if (autoClose && !this.checkRemoveOnDeath.isSelected()) {
                this.processList.repaint();
                return;
            }
            index = i;
        }
        if (index == -1) {
            return;
        }
        this.outputPanel.remove(index);
        this.listModel.removeElement(process);
        this.processList.invalidate();
    }

    public void showWindow(String title) {
        JFrame frame = ShowImages.showWindow(this, title, true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ApplicationLauncherApp.this.killAllProcesses(2000L);
            }
        });
    }

    class ProcessStatusThread
    extends Thread {
        ProcessStatusThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                List<ActiveProcess> list = ApplicationLauncherApp.this.processes;
                synchronized (list) {
                    for (int i = ApplicationLauncherApp.this.processes.size() - 1; i >= 0; --i) {
                        final ActiveProcess p = ApplicationLauncherApp.this.processes.get(i);
                        if (p.isActive()) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ApplicationLauncherApp.this.removeProcessTab(p, true);
                            }
                        });
                        ApplicationLauncherApp.this.processes.remove(i);
                    }
                }
                try {
                    ProcessStatusThread.sleep(250L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public class ActiveProcess
    extends Thread {
        AppInfo info;
        JavaRuntimeLauncher launcher;
        volatile boolean active = false;
        JavaRuntimeLauncher.Exit exit;

        @Override
        public void run() {
            this.active = true;
            this.exit = this.launcher.launch(this.info.app, new String[0]);
            this.launcher.getPrintOut().println("\n\n~~~~~~~~~ Finished ~~~~~~~~~");
            System.out.println();
            System.out.println("------------------- Exit condition " + (Object)((Object)this.exit));
            this.active = false;
        }

        public void requestKill() {
            this.launcher.requestKill();
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public String toString() {
            if (this.launcher.isKillRequested() && this.active) {
                return "Killing " + this.info;
            }
            return this.info.toString();
        }
    }

    public static class AppInfo {
        Class app;

        public AppInfo(Class app) {
            this.app = app;
        }

        public String toString() {
            return this.app.getSimpleName();
        }
    }

    class TextOutputStream
    extends OutputStream {
        private JTextArea textArea;
        private boolean mirror;

        public TextOutputStream(JTextArea textArea, boolean mirror) {
            this.textArea = textArea;
            this.mirror = mirror;
        }

        @Override
        public void write(final int b) throws IOException {
            if (this.mirror) {
                System.out.write(b);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextOutputStream.this.textArea.append(String.valueOf((char)b));
                }
            });
        }
    }
}

