/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.binary;

import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.alg.filter.binary.Contour;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_I32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Random;

public class VisualizeBinaryData {
    public static BufferedImage renderContours(List<EdgeContour> edges, int[] colors, int width, int height, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(width, height, 1);
        } else {
            Graphics2D g2 = out.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, width, height);
        }
        colors = VisualizeBinaryData.checkColors(colors, edges.size());
        for (int i = 0; i < edges.size(); ++i) {
            EdgeContour e = edges.get(i);
            int color = colors[i];
            for (EdgeSegment s : e.segments) {
                for (Point2D_I32 p : s.points) {
                    out.setRGB(p.x, p.y, color);
                }
            }
        }
        return out;
    }

    public static BufferedImage renderContours(List<Contour> contours, int colorExternal, int colorInternal, int width, int height, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(width, height, 1);
        } else {
            Graphics2D g2 = out.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, width, height);
        }
        for (Contour c : contours) {
            for (Point2D_I32 p : c.external) {
                out.setRGB(p.x, p.y, colorExternal);
            }
            for (List l : c.internal) {
                for (Point2D_I32 p : l) {
                    out.setRGB(p.x, p.y, colorInternal);
                }
            }
        }
        return out;
    }

    public static BufferedImage renderContours(List<Contour> contours, int[] colorExternal, int colorInternal, int width, int height, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(width, height, 1);
        } else {
            Graphics2D g2 = out.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, width, height);
        }
        colorExternal = VisualizeBinaryData.checkColors(colorExternal, contours.size());
        int index = 0;
        for (Contour c : contours) {
            int color = colorExternal[index++];
            for (Point2D_I32 p : c.external) {
                out.setRGB(p.x, p.y, color);
            }
            for (List l : c.internal) {
                for (Point2D_I32 p : l) {
                    out.setRGB(p.x, p.y, colorInternal);
                }
            }
        }
        return out;
    }

    public static void render(List<Contour> contours, int[] colors, BufferedImage out) {
        colors = VisualizeBinaryData.checkColors(colors, contours.size());
        for (Contour c : contours) {
            int color = colors[c.id - 1];
            for (Point2D_I32 p : c.external) {
                out.setRGB(p.x, p.y, color);
            }
        }
    }

    public static int[] checkColors(int[] colors, int size) {
        if (colors == null) {
            colors = new int[size];
            Random rand = new Random(123L);
            for (int i = 0; i < size; ++i) {
                colors[i] = rand.nextInt();
            }
        }
        return colors;
    }

    public static BufferedImage render(List<Contour> contours, Color color, BufferedImage out) {
        for (Contour c : contours) {
            for (Point2D_I32 p : c.external) {
                out.setRGB(p.x, p.y, color.getRGB());
            }
        }
        return out;
    }

    public static void render(List<Contour> contours, Color internal, Color external, double scale, Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double l = new Line2D.Double();
        g2.setStroke(new BasicStroke(Math.max(1.0f, (float)scale)));
        for (Contour c : contours) {
            if (external != null) {
                g2.setColor(external);
                VisualizeBinaryData.renderContour(scale, g2, l, c.external);
            }
            if (internal == null) continue;
            g2.setColor(internal);
            for (List inner : c.internal) {
                VisualizeBinaryData.renderContour(scale, g2, l, inner);
            }
        }
        if (scale > 4.0) {
            Color before = g2.getColor();
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.LIGHT_GRAY);
            for (Contour c : contours) {
                if (external != null) {
                    VisualizeBinaryData.renderContour(scale, g2, l, c.external);
                }
                if (internal == null) continue;
                for (List inner : c.internal) {
                    VisualizeBinaryData.renderContour(scale, g2, l, inner);
                }
            }
            g2.setColor(before);
        }
    }

    private static void renderContour(double scale, Graphics2D g2, Line2D.Double l, List<Point2D_I32> list) {
        int i = 0;
        int j = list.size() - 1;
        while (i < list.size()) {
            Point2D_I32 p0 = list.get(i);
            Point2D_I32 p1 = list.get(j);
            l.setLine(((double)p0.x + 0.5) * scale, ((double)p0.y + 0.5) * scale, ((double)p1.x + 0.5) * scale, ((double)p1.y + 0.5) * scale);
            g2.draw(l);
            j = i++;
        }
    }

    public static BufferedImage renderLabeled(GrayS32 labelImage, int[] colors, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(labelImage.getWidth(), labelImage.getHeight(), 1);
        }
        WritableRaster raster = out.getRaster();
        DataBuffer buffer = raster.getDataBuffer();
        try {
            if (buffer.getDataType() == 3) {
                VisualizeBinaryData.renderLabeled(labelImage, colors, (DataBufferInt)buffer, raster);
            } else {
                VisualizeBinaryData._renderLabeled(labelImage, out, colors);
            }
            out.setRGB(0, 0, out.getRGB(0, 0));
        }
        catch (SecurityException e) {
            VisualizeBinaryData._renderLabeled(labelImage, out, colors);
        }
        return out;
    }

    public static BufferedImage renderLabeledBG(GrayS32 labelImage, int numRegions, BufferedImage out) {
        int[] colors = new int[numRegions + 1];
        Random rand = new Random(123L);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = rand.nextInt();
        }
        colors[0] = 0;
        return VisualizeBinaryData.renderLabeled(labelImage, colors, out);
    }

    public static BufferedImage renderLabeled(GrayS32 labelImage, int numRegions, BufferedImage out) {
        int[] colors = new int[numRegions];
        Random rand = new Random(123L);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = rand.nextInt();
        }
        return VisualizeBinaryData.renderLabeled(labelImage, colors, out);
    }

    private static void _renderLabeled(GrayS32 labelImage, BufferedImage out, int[] colors) {
        int w = labelImage.getWidth();
        int h = labelImage.getHeight();
        for (int y = 0; y < h; ++y) {
            int indexSrc = labelImage.startIndex + y * labelImage.stride;
            for (int x = 0; x < w; ++x) {
                int rgb = colors[labelImage.data[indexSrc++]];
                out.setRGB(x, y, rgb);
            }
        }
    }

    private static void renderLabeled(GrayS32 labelImage, int[] colors, DataBufferInt buffer, WritableRaster raster) {
        int rasterIndex = 0;
        int[] data = buffer.getData();
        int w = labelImage.getWidth();
        int h = labelImage.getHeight();
        for (int y = 0; y < h; ++y) {
            int indexSrc = labelImage.startIndex + y * labelImage.stride;
            for (int x = 0; x < w; ++x) {
                data[rasterIndex++] = colors[labelImage.data[indexSrc++]];
            }
        }
    }

    public static BufferedImage renderBinary(GrayU8 binaryImage, boolean invert, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(binaryImage.getWidth(), binaryImage.getHeight(), 10);
        }
        try {
            WritableRaster raster = out.getRaster();
            DataBuffer buffer = raster.getDataBuffer();
            if (buffer.getDataType() == 0) {
                VisualizeBinaryData.renderBinary(binaryImage, invert, (DataBufferByte)buffer, raster);
            } else if (buffer.getDataType() == 3) {
                VisualizeBinaryData.renderBinary(binaryImage, invert, (DataBufferInt)buffer, raster);
            } else {
                VisualizeBinaryData._renderBinary(binaryImage, invert, out);
            }
        }
        catch (SecurityException e) {
            VisualizeBinaryData._renderBinary(binaryImage, invert, out);
        }
        out.setRGB(0, 0, out.getRGB(0, 0));
        return out;
    }

    private static void _renderBinary(GrayU8 binaryImage, boolean invert, BufferedImage out) {
        int w = binaryImage.getWidth();
        int h = binaryImage.getHeight();
        if (invert) {
            for (int y = 0; y < h; ++y) {
                int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                for (int x = 0; x < w; ++x) {
                    int rgb = binaryImage.data[indexSrc++] > 0 ? 0 : 0xFFFFFF;
                    out.setRGB(x, y, rgb);
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                for (int x = 0; x < w; ++x) {
                    int rgb = binaryImage.data[indexSrc++] > 0 ? 0xFFFFFF : 0;
                    out.setRGB(x, y, rgb);
                }
            }
        }
    }

    private static void renderBinary(GrayU8 binaryImage, boolean invert, DataBufferByte buffer, WritableRaster raster) {
        int rasterIndex = 0;
        byte[] data = buffer.getData();
        int w = binaryImage.getWidth();
        int h = binaryImage.getHeight();
        int numBands = raster.getNumBands();
        if (numBands == 1) {
            if (invert) {
                for (int y = 0; y < h; ++y) {
                    int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                    for (int x = 0; x < w; ++x) {
                        data[rasterIndex++] = (byte)((1 - binaryImage.data[indexSrc++]) * 255);
                    }
                }
            } else {
                for (int y = 0; y < h; ++y) {
                    int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                    for (int x = 0; x < w; ++x) {
                        data[rasterIndex++] = (byte)(binaryImage.data[indexSrc++] * 255);
                    }
                }
            }
        } else if (invert) {
            for (int y = 0; y < h; ++y) {
                int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                for (int x = 0; x < w; ++x) {
                    byte val = (byte)((1 - binaryImage.data[indexSrc++]) * 255);
                    for (int i = 0; i < numBands; ++i) {
                        data[rasterIndex++] = val;
                    }
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                for (int x = 0; x < w; ++x) {
                    byte val = (byte)(binaryImage.data[indexSrc++] * 255);
                    for (int i = 0; i < numBands; ++i) {
                        data[rasterIndex++] = val;
                    }
                }
            }
        }
    }

    private static void renderBinary(GrayU8 binaryImage, boolean invert, DataBufferInt buffer, WritableRaster raster) {
        int rasterIndex = 0;
        int[] data = buffer.getData();
        int w = binaryImage.getWidth();
        int h = binaryImage.getHeight();
        if (invert) {
            for (int y = 0; y < h; ++y) {
                int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                for (int x = 0; x < w; ++x) {
                    data[rasterIndex++] = binaryImage.data[indexSrc++] > 0 ? 0 : -1;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
                for (int x = 0; x < w; ++x) {
                    data[rasterIndex++] = binaryImage.data[indexSrc++] > 0 ? -1 : 0;
                }
            }
        }
    }
}

