/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.gui.d3.ColorPoint3D;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;

public class PointCloudViewer
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    FastQueue<ColorPoint3D> cloud = new FastQueue(200, ColorPoint3D.class, true);
    DMatrixRMaj K;
    Se3_F64 worldToCamera = new Se3_F64();
    double focalLengthX;
    double focalLengthY;
    double centerX;
    double centerY;
    double stepSize;
    Pixel[] data = new Pixel[0];
    public int tiltAngle = 0;
    public double radius = 5.0;
    int prevX;
    int prevY;

    public PointCloudViewer(double keyStepSize) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.stepSize = keyStepSize;
    }

    public PointCloudViewer(DMatrixRMaj K, double keyStepSize) {
        this(keyStepSize);
        this.configure(K);
    }

    public PointCloudViewer(CameraPinholeRadial intrinsic, double keyStepSize) {
        this(keyStepSize);
        this.configure(PerspectiveOps.calibrationMatrix((CameraPinhole)intrinsic, (DMatrixRMaj)null));
        this.setPreferredSize(new Dimension(intrinsic.width, intrinsic.height));
    }

    public void setWorldToCamera(Se3_F64 worldToCamera) {
        this.worldToCamera.set(worldToCamera);
    }

    public void configure(DMatrixRMaj K) {
        this.K = K;
        this.focalLengthX = K.get(0, 0);
        this.focalLengthY = K.get(1, 1);
        this.centerX = K.get(0, 2);
        this.centerY = K.get(1, 2);
    }

    public void reset() {
        this.cloud.reset();
    }

    public void addPoint(double x, double y, double z, int rgb) {
        ColorPoint3D p = (ColorPoint3D)((Object)this.cloud.grow());
        p.set(x, y, z);
        p.rgb = rgb;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.projectScene();
        int width = this.getWidth();
        int h = this.getHeight();
        int r = 2;
        int w = r * 2 + 1;
        Graphics2D g2 = (Graphics2D)g;
        int index = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < width; ++x) {
                Pixel p = this.data[index++];
                if (p.rgb == -1) continue;
                g2.setColor(new Color(p.rgb));
                g2.fillRect(x - r, y - r, w, w);
            }
        }
    }

    private void projectScene() {
        int i;
        int h;
        int w = this.getWidth();
        int N = w * (h = this.getHeight());
        if (this.data.length < N) {
            this.data = new Pixel[N];
            for (i = 0; i < N; ++i) {
                this.data[i] = new Pixel();
            }
        } else {
            for (i = 0; i < N; ++i) {
                this.data[i].reset();
            }
        }
        Point3D_F64 cameraPt = new Point3D_F64();
        Point2D_F64 pixel = new Point2D_F64();
        for (int i2 = 0; i2 < this.cloud.size(); ++i2) {
            ColorPoint3D p = (ColorPoint3D)((Object)this.cloud.get(i2));
            SePointOps_F64.transform((Se3_F64)this.worldToCamera, (Point3D_F64)p, (Point3D_F64)cameraPt);
            pixel.x = cameraPt.x / cameraPt.z;
            pixel.y = cameraPt.y / cameraPt.z;
            GeometryMath_F64.mult((DMatrixRMaj)this.K, (GeoTuple2D_F64)pixel, (GeoTuple2D_F64)pixel);
            int x = (int)(pixel.x + 0.5);
            int y = (int)(pixel.y + 0.5);
            if (x < 0 || y < 0 || x >= w || y >= h) continue;
            Pixel d = this.data[y * w + x];
            if (!(d.height > cameraPt.z)) continue;
            d.height = cameraPt.z;
            d.rgb = p.rgb;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Vector3D_F64 T = this.worldToCamera.getT();
        if (e.getKeyChar() == 'w') {
            T.z -= this.stepSize;
        } else if (e.getKeyChar() == 's') {
            T.z += this.stepSize;
        } else if (e.getKeyChar() == 'a') {
            T.x += this.stepSize;
        } else if (e.getKeyChar() == 'd') {
            T.x -= this.stepSize;
        } else if (e.getKeyChar() == 'q') {
            T.y -= this.stepSize;
        } else if (e.getKeyChar() == 'e') {
            T.y += this.stepSize;
        } else if (e.getKeyChar() == 'h') {
            this.worldToCamera.reset();
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        double rotX = 0.0;
        double rotY = 0.0;
        double rotZ = 0.0;
        Se3_F64 rotTran = new Se3_F64();
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)(rotX += (double)(this.prevY - e.getY()) * 0.01), (double)(rotY += (double)(e.getX() - this.prevX) * 0.01), (double)rotZ, (DMatrixRMaj)rotTran.getR());
        Se3_F64 temp = this.worldToCamera.concat(rotTran, null);
        this.worldToCamera.set(temp);
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private static class Pixel {
        public double height;
        public int rgb;

        private Pixel() {
            this.reset();
        }

        public void reset() {
            this.height = Double.MAX_VALUE;
            this.rgb = -1;
        }
    }
}

