/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.alg.misc.PixelMath;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import java.awt.image.BufferedImage;

public class VisualizeOpticalFlow {
    public static void colorizeDirection(ImageFlow flowImage, BufferedImage out) {
        int[] tableSine = new int[360];
        int[] tableCosine = new int[360];
        for (int i = 0; i < 360; ++i) {
            double angle = (double)i * Math.PI / 180.0;
            tableSine[i] = (int)(255.0 * (Math.sin(angle) + 1.0) / 2.0);
            tableCosine[i] = (int)(255.0 * (Math.cos(angle) + 1.0) / 2.0);
        }
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 255);
                    continue;
                }
                double angle = Math.atan2(f.y, f.x);
                int degree = (int)(180.0 + angle * 179.999 / Math.PI);
                int r = tableSine[degree];
                int g = tableCosine[degree];
                out.setRGB(x, y, r << 16 | g << 8);
            }
        }
    }

    public static void magnitudeAbs(ImageFlow flowImage, BufferedImage out) {
        GrayF32 magnitude = new GrayF32(flowImage.width, flowImage.height);
        float max = 0.0f;
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 255);
                    continue;
                }
                float m = Math.max(Math.abs(f.x), Math.abs(f.y));
                if (m > max) {
                    max = m;
                }
                magnitude.unsafe_set(x, y, m);
            }
        }
        PixelMath.multiply((GrayF32)magnitude, (float)(255.0f / max), (GrayF32)magnitude);
        ConvertBufferedImage.convertTo((GrayF32)magnitude, (BufferedImage)out);
    }

    public static void magnitudeAbs(ImageFlow flowImage, float maxValue, BufferedImage out) {
        GrayF32 magnitude = new GrayF32(flowImage.width, flowImage.height);
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 255);
                    continue;
                }
                float m = Math.max(Math.abs(f.x), Math.abs(f.y));
                magnitude.unsafe_set(x, y, m);
            }
        }
        PixelMath.multiply((GrayF32)magnitude, (float)(255.0f / maxValue), (GrayF32)magnitude);
        PixelMath.boundImage((GrayF32)magnitude, (float)0.0f, (float)255.0f);
        ConvertBufferedImage.convertTo((GrayF32)magnitude, (BufferedImage)out);
    }

    public static void colorized(ImageFlow flowImage, float maxValue, BufferedImage out) {
        int[] tableSine = new int[360];
        int[] tableCosine = new int[360];
        for (int i = 0; i < 360; ++i) {
            double angle = (double)i * Math.PI / 180.0;
            tableSine[i] = (int)(255.0 * (Math.sin(angle) + 1.0) / 2.0);
            tableCosine[i] = (int)(255.0 * (Math.cos(angle) + 1.0) / 2.0);
        }
        for (int y = 0; y < flowImage.height; ++y) {
            for (int x = 0; x < flowImage.width; ++x) {
                ImageFlow.D f = flowImage.unsafe_get(x, y);
                if (!f.isValid()) {
                    out.setRGB(x, y, 85);
                    continue;
                }
                float m = Math.max(Math.abs(f.x), Math.abs(f.y)) / maxValue;
                if (m > 1.0f) {
                    m = 1.0f;
                }
                double angle = Math.atan2(f.y, f.x);
                int degree = (int)(180.0 + angle * 179.999 / Math.PI);
                int r = (int)(m * (float)tableSine[degree]);
                int g = (int)(m * (float)tableCosine[degree]);
                out.setRGB(x, y, r << 16 | g << 8);
            }
        }
    }
}

