/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.io.image.UtilImageIO;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SaveImageOnClick
extends MouseAdapter {
    private static int saveCounter = 0;
    private static boolean hideSaveDialog = false;
    Component parent;

    public SaveImageOnClick(Component parent) {
        this.parent = parent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean clicked = SwingUtilities.isMiddleMouseButton(e);
        if (clicked) {
            String fileName = String.format("saved_image%03d.png", saveCounter++);
            System.out.println("Image saved to " + fileName);
            BufferedImage output = new BufferedImage(this.parent.getWidth(), this.parent.getHeight(), 4);
            this.parent.paint(output.createGraphics());
            UtilImageIO.saveImage((BufferedImage)output, (String)fileName);
            if (hideSaveDialog) {
                return;
            }
            Object[] options = new Object[]{"Hide in Future", "OK"};
            int n = JOptionPane.showOptionDialog(this.parent, "Saved image to " + fileName, "Middle Mouse Click Image Saving", 2, 3, null, options, options[1]);
            if (n == 0) {
                hideSaveDialog = true;
            }
        }
    }
}

