/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageGray;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class ImageHistogramPanel
extends JPanel {
    private final Object lock = new Object();
    protected int totalBins;
    protected double maxValue;
    protected int[] bins;
    public int marker = -1;

    public ImageHistogramPanel(int totalBins, double maxValue) {
        this.totalBins = totalBins;
        this.maxValue = maxValue;
        this.bins = new int[totalBins];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSafe(ImageGray image) {
        Object object = this.lock;
        synchronized (object) {
            this.update(image);
        }
    }

    public void update(ImageGray image) {
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = 0;
        }
        if (image instanceof GrayF32) {
            this.update((GrayF32)image);
        } else if (GrayI.class.isAssignableFrom(image.getClass())) {
            this.update((GrayI)image);
        } else {
            throw new IllegalArgumentException("Image type not yet supported");
        }
    }

    private void update(GrayF32 image) {
        if (image.width * image.height < 40000) {
            for (int y = 0; y < image.height; ++y) {
                for (int x = 0; x < image.width; ++x) {
                    int index;
                    int n = index = (int)((double)this.totalBins * ((double)image.unsafe_get(x, y) / this.maxValue));
                    this.bins[n] = this.bins[n] + 1;
                }
            }
        } else {
            int periodX = (int)Math.ceil((double)image.width / 250.0);
            int periodY = (int)Math.ceil((double)image.width / 250.0);
            for (int y = 0; y < image.height; y += periodY) {
                for (int x = 0; x < image.width; x += periodX) {
                    int index;
                    int n = index = (int)((double)this.totalBins * ((double)image.unsafe_get(x, y) / this.maxValue));
                    this.bins[n] = this.bins[n] + 1;
                }
            }
        }
    }

    private void update(GrayI image) {
        int max = (int)this.maxValue;
        if (image.width * image.height < 40000) {
            for (int y = 0; y < image.height; ++y) {
                for (int x = 0; x < image.width; ++x) {
                    int index;
                    int n = index = this.totalBins * (image.unsafe_get(x, y) / max);
                    this.bins[n] = this.bins[n] + 1;
                }
            }
        } else {
            int periodX = (int)Math.ceil((double)image.width / 250.0);
            int periodY = (int)Math.ceil((double)image.width / 250.0);
            for (int y = 0; y < image.height; y += periodY) {
                for (int x = 0; x < image.width; x += periodX) {
                    int index;
                    int n = index = this.totalBins * (image.unsafe_get(x, y) / max);
                    this.bins[n] = this.bins[n] + 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        int w = this.getWidth();
        int h = this.getHeight();
        Object object = this.lock;
        synchronized (object) {
            int i;
            int maxCount = 0;
            for (i = 0; i < this.totalBins; ++i) {
                if (this.bins[i] <= maxCount) continue;
                maxCount = this.bins[i];
            }
            if (maxCount == 0) {
                return;
            }
            g2.setColor(Color.BLACK);
            for (i = 0; i < this.totalBins; ++i) {
                int x1 = w * i / this.totalBins;
                int x2 = w * (i + 1) / this.totalBins;
                int y = h - h * this.bins[i] / maxCount;
                g2.fillRect(x1, y, x2 - x1, h - y);
            }
        }
        int marker = this.marker;
        if (marker >= 0) {
            int x = marker * w / this.totalBins;
            g2.setColor(Color.RED);
            g2.fillRect(x - 1, 0, 3, h);
        }
    }

    public void setMarker(int marker) {
        this.marker = marker;
    }
}

