/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.awt.image.BufferedImage;
import org.ddogleg.struct.GrowQueue_F32;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.data.DMatrixRMaj;

public class DisparityToColorPointCloud {
    float baseline;
    DMatrixRMaj K;
    float focalLengthX;
    float focalLengthY;
    float centerX;
    float centerY;
    int minDisparity;
    int rangeDisparity;
    double range = 1.0;
    GrowQueue_F32 cloudXyz = new GrowQueue_F32();
    GrowQueue_I32 cloudRgb = new GrowQueue_I32();
    public int tiltAngle = 0;
    public double radius = 5.0;
    Point2Transform2_F64 rectifiedToColor;
    Point2D_F64 colorPt = new Point2D_F64();

    public void configure(double baseline, DMatrixRMaj K, Point2Transform2_F64 rectifiedToColor, int minDisparity, int maxDisparity) {
        this.K = K;
        this.rectifiedToColor = rectifiedToColor;
        this.baseline = (float)baseline;
        this.focalLengthX = (float)K.get(0, 0);
        this.focalLengthY = (float)K.get(1, 1);
        this.centerX = (float)K.get(0, 2);
        this.centerY = (float)K.get(1, 2);
        this.minDisparity = minDisparity;
        this.rangeDisparity = maxDisparity - minDisparity;
    }

    public void process(ImageGray disparity, BufferedImage color) {
        this.cloudRgb.setMaxSize(disparity.width * disparity.height);
        this.cloudXyz.setMaxSize(disparity.width * disparity.height * 3);
        this.cloudRgb.reset();
        this.cloudXyz.reset();
        if (disparity instanceof GrayU8) {
            this.process((GrayU8)disparity, color);
        } else {
            this.process((GrayF32)disparity, color);
        }
    }

    private void process(GrayU8 disparity, BufferedImage color) {
        for (int pixelY = 0; pixelY < disparity.height; ++pixelY) {
            int index = disparity.startIndex + disparity.stride * pixelY;
            for (int pixelX = 0; pixelX < disparity.width; ++pixelX) {
                int value;
                if ((value = disparity.data[index++] & 0xFF) >= this.rangeDisparity || (value += this.minDisparity) == 0) continue;
                float z = this.baseline * this.focalLengthX / (float)value;
                float x = z * ((float)pixelX - this.centerX) / this.focalLengthX;
                float y = z * ((float)pixelY - this.centerY) / this.focalLengthY;
                this.cloudRgb.add(this.getColor((ImageBase)disparity, color, pixelX, pixelY));
                this.cloudXyz.add(x);
                this.cloudXyz.add(y);
                this.cloudXyz.add(z);
            }
        }
    }

    private void process(GrayF32 disparity, BufferedImage color) {
        for (int pixelY = 0; pixelY < disparity.height; ++pixelY) {
            int index = disparity.startIndex + disparity.stride * pixelY;
            for (int pixelX = 0; pixelX < disparity.width; ++pixelX) {
                float value;
                if ((value = disparity.data[index++]) >= (float)this.rangeDisparity || (value += (float)this.minDisparity) == 0.0f) continue;
                float z = this.baseline * this.focalLengthX / value;
                float x = z * ((float)pixelX - this.centerX) / this.focalLengthX;
                float y = z * ((float)pixelY - this.centerY) / this.focalLengthY;
                this.cloudRgb.add(this.getColor((ImageBase)disparity, color, pixelX, pixelY));
                this.cloudXyz.add(x);
                this.cloudXyz.add(y);
                this.cloudXyz.add(z);
            }
        }
    }

    private int getColor(ImageBase disparity, BufferedImage color, int x, int y) {
        this.rectifiedToColor.compute((double)x, (double)y, this.colorPt);
        if (BoofMiscOps.checkInside((ImageBase)disparity, (double)this.colorPt.x, (double)this.colorPt.y)) {
            return color.getRGB((int)this.colorPt.x, (int)this.colorPt.y);
        }
        return 0;
    }

    public GrowQueue_F32 getCloud() {
        return this.cloudXyz;
    }

    public GrowQueue_I32 getCloudColor() {
        return this.cloudRgb;
    }
}

