/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.d3.PointCloudViewerPanelSwing;
import boofcv.visualize.PointCloudViewer;
import georegression.struct.ConvertFloatType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F32;
import georegression.struct.se.Se3_F64;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.GrowQueue_F32;
import org.ddogleg.struct.GrowQueue_I32;

public class PointCloudViewerSwing
implements PointCloudViewer {
    PointCloudViewerPanelSwing panel = new PointCloudViewerPanelSwing(60.0f, 1.0f);

    public void setShowAxis(boolean show) {
    }

    public void setTranslationStep(double step) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.stepSize = (float)step;
        });
    }

    public void setDotSize(int pixels) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setDotRadius(pixels));
    }

    public void setClipDistance(double distance) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.maxRenderDistance = (float)distance;
        });
    }

    public void setFog(boolean active) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.fog = active;
        });
    }

    public void setBackgroundColor(int rgb) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.backgroundColor = rgb;
        });
    }

    public void addCloud(List<Point3D_F64> cloudXyz, int[] colorsRgb) {
        if (cloudXyz.size() > colorsRgb.length) {
            throw new IllegalArgumentException("Number of points do not match");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i = 0; i < cloudXyz.size(); ++i) {
                Point3D_F64 p = cloudXyz.get(i);
                this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, colorsRgb[i]);
            }
        } else {
            SwingUtilities.invokeLater(() -> {
                for (int i = 0; i < cloudXyz.size(); ++i) {
                    Point3D_F64 p = (Point3D_F64)cloudXyz.get(i);
                    this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, colorsRgb[i]);
                }
            });
        }
    }

    public void addCloud(List<Point3D_F64> cloud) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i = 0; i < cloud.size(); ++i) {
                Point3D_F64 p = cloud.get(i);
                this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, 0xFF0000);
            }
        } else {
            SwingUtilities.invokeLater(() -> {
                for (int i = 0; i < cloud.size(); ++i) {
                    Point3D_F64 p = (Point3D_F64)cloud.get(i);
                    this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, 0xFF0000);
                }
            });
        }
    }

    public void addCloud(GrowQueue_F32 cloudXYZ, GrowQueue_I32 colorRGB) {
        if (cloudXYZ.size / 3 != colorRGB.size) {
            throw new IllegalArgumentException("Number of points do not match");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.addPoints(cloudXYZ.data, colorRGB.data, cloudXYZ.size / 3);
        } else {
            SwingUtilities.invokeLater(() -> this.panel.addPoints(cloudXYZ.data, colorRGB.data, cloudXYZ.size / 3));
        }
    }

    public void addPoint(double x, double y, double z, int rgb) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.addPoint((float)x, (float)y, (float)z, rgb);
        } else {
            SwingUtilities.invokeLater(() -> this.panel.addPoint((float)x, (float)y, (float)z, rgb));
        }
    }

    public void clearPoints() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.clearCloud();
        } else {
            SwingUtilities.invokeLater(() -> this.panel.clearCloud());
        }
    }

    public void setCameraHFov(double radians) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setHorizontalFieldOfView((float)radians));
    }

    public void setCameraToWorld(Se3_F64 cameraToWorld) {
        Se3_F64 worldToCamera = cameraToWorld.invert(null);
        Se3_F32 worldToCameraF32 = new Se3_F32();
        ConvertFloatType.convert((Se3_F64)worldToCamera, (Se3_F32)worldToCameraF32);
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setWorldToCamera(worldToCameraF32));
    }

    public JComponent getComponent() {
        return this.panel;
    }
}

