/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.image.SaveImageOnClick;
import boofcv.io.image.ConvertBufferedImage;
import georegression.struct.point.Point2D_F64;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ImageZoomPanel
extends JScrollPane {
    protected BufferedImage img;
    protected ImagePanel panel = new ImagePanel();
    protected double scale = 1.0;
    protected double transX = 0.0;
    protected double transY = 0.0;
    boolean checkEventDispatch = true;

    public ImageZoomPanel(BufferedImage img) {
        this.img = img;
        this.setScale(1.0);
    }

    public ImageZoomPanel() {
        this.getViewport().setView(this.panel);
    }

    public void disableSaveOnClick() {
        this.panel.removeMouseListener(this.panel.mouseListener);
        this.panel.mouseListener = null;
    }

    public synchronized void setScale(double scale) {
        if (this.scale == scale) {
            return;
        }
        Rectangle r = this.panel.getVisibleRect();
        double centerX = ((double)r.x + (double)r.width / 2.0) / this.scale;
        double centerY = ((double)r.y + (double)r.height / 2.0) / this.scale;
        this.scale = scale;
        if (this.img != null) {
            int w = (int)Math.ceil((double)this.img.getWidth() * scale);
            int h = (int)Math.ceil((double)this.img.getHeight() * scale);
            this.panel.setPreferredSize(new Dimension(w, h));
        }
        this.getViewport().setView(this.panel);
        this.centerView(centerX, centerY);
    }

    public synchronized void setScaleAndCenter(double scale, double cx, double cy) {
        this.scale = scale;
        if (this.img != null) {
            int w = (int)Math.ceil((double)this.img.getWidth() * scale);
            int h = (int)Math.ceil((double)this.img.getHeight() * scale);
            this.panel.setPreferredSize(new Dimension(w, h));
        }
        this.getViewport().setView(this.panel);
        this.centerView(cx, cy);
    }

    public synchronized void centerView(double cx, double cy) {
        Rectangle r = this.panel.getVisibleRect();
        int x = (int)(cx * this.scale - (double)(r.width / 2));
        int y = (int)(cy * this.scale - (double)(r.height / 2));
        this.getHorizontalScrollBar().setValue(x);
        this.getVerticalScrollBar().setValue(y);
    }

    public synchronized void setBufferedImage(BufferedImage image) {
        if (this.checkEventDispatch && this.img != null && !SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Changed image when not in GUI thread?");
        }
        this.img = image;
        if (image != null) {
            this.updateSize(image.getWidth(), image.getHeight());
        }
    }

    public void updateSize(int width, int height) {
        Dimension prev = this.getPreferredSize();
        int w = (int)Math.ceil((double)width * this.scale);
        int h = (int)Math.ceil((double)height * this.scale);
        if (prev.getWidth() != (double)w || prev.getHeight() != (double)h) {
            this.panel.setPreferredSize(new Dimension(w, h));
            this.getViewport().setView(this.panel);
        }
    }

    public synchronized void setBufferedImageNoChange(BufferedImage image) {
        if (this.checkEventDispatch && this.img != null && !SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Changed image when not in GUI thread?");
        }
        this.img = image;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public Point2D_F64 pixelToPoint(int x, int y) {
        Point2D_F64 ret = new Point2D_F64();
        ret.x = (double)x / this.scale;
        ret.y = (double)y / this.scale;
        return ret;
    }

    protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
    }

    public double getScale() {
        return this.scale;
    }

    public ImagePanel getImagePanel() {
        return this.panel;
    }

    public class ImagePanel
    extends JPanel {
        SaveImageOnClick mouseListener;
        BufferedImage buffer;

        public ImagePanel() {
            this.mouseListener = new SaveImageOnClick(ImageZoomPanel.this.getViewport());
            this.buffer = new BufferedImage(1, 1, 2);
            this.addMouseListener(this.mouseListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ImageZoomPanel.this.img == null) {
                return;
            }
            int w = ImageZoomPanel.this.getWidth();
            int h = ImageZoomPanel.this.getHeight();
            this.buffer = ConvertBufferedImage.checkDeclare((int)w, (int)h, (BufferedImage)this.buffer, (int)this.buffer.getType());
            Graphics2D g2 = this.buffer.createGraphics();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, w, h);
            ImageZoomPanel.this.transX = -ImageZoomPanel.this.getHorizontalScrollBar().getValue();
            ImageZoomPanel.this.transY = -ImageZoomPanel.this.getVerticalScrollBar().getValue();
            AffineTransform tran = new AffineTransform(ImageZoomPanel.this.scale, 0.0, 0.0, ImageZoomPanel.this.scale, ImageZoomPanel.this.transX, ImageZoomPanel.this.transY);
            ImageZoomPanel imageZoomPanel = ImageZoomPanel.this;
            synchronized (imageZoomPanel) {
                g2.drawImage(ImageZoomPanel.this.img, tran, null);
            }
            AffineTransform orig = g2.getTransform();
            tran = new AffineTransform(1.0, 0.0, 0.0, 1.0, ImageZoomPanel.this.transX, ImageZoomPanel.this.transY);
            g2.setTransform(tran);
            ImageZoomPanel.this.paintInPanel(tran, g2);
            g2.setTransform(orig);
            g.drawImage(this.buffer, (int)(-ImageZoomPanel.this.transX), (int)(-ImageZoomPanel.this.transY), null);
        }
    }
}

